<?php
/**
 * The template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 */

get_header(); ?>
<section id="primary" class="content-area">
	<div id="content" class="main-content site-content archive-event" role="main">
		<div class="container">
			<div class="row">
				<?php 
					if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php $thumb_url = get_the_post_thumbnail_url(); ?>
							<article class="col-md-4">
								<div class="wrap-item" style="background-image: url('<?php echo esc_url($thumb_url); ?>' );">
									<div class="event-item">
								
										<div class="meta-post">
											<div class="date-post"><span class="lnr lnr-clock"></span><?php echo date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ); ?></div>
										</div>

										<a href="<?php the_permalink(); ?> "><?php the_title( '<h1 class="entry-title">', '</h1>' ); ?></a>

										<div class="entry-summary">
											<?php the_excerpt(); ?>
										</div>

										<div class="read-more">
											<a href="<?php the_permalink(); ?> "><?php esc_html_e('Continue Read','thebrilliance'); ?><span class="lnr lnr-arrow-right"></span></a>
										</div>
									</div>
								</div>
							</article>
						<?php endwhile; 
						// Previous/next page navigation.
						jws_theme_paging_nav();

					else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' );

					endif;
				?>
			</div>
		</div>
	</div><!-- #content -->
</section><!-- #primary -->
<?php
get_footer();