<?php 
/**
 * Template Name: Coming Soon
 */
if ( !session_id() ) session_start(); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="robots" content="noindex" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div id="main-site" class="page-coming-soon">
		<div class="site-main">
			<?php
			global $post;
			while ( have_posts() ) :
				the_post();
				echo do_shortcode(apply_filters('the_content', $post->post_content)); // echo manual the post_content, when page has many shortcodes
			endwhile;
			?>
		</div>
	</div><!-- /#page -->
	<?php wp_footer(); ?>
</body>
</html>