<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */

if ( post_password_required() ) {
	return;
}

$jws_commenter     = wp_get_current_commenter();
$jws_aria_required = get_option( 'require_name_email' ) ? " aria-required='true'" : '';
$jws_permalink     = get_permalink();

$args = array(
	'id_form'              => 'addcomments',
	'id_submit'            => 'submit',
    'class_submit'         => 'submit fw-btn fw-btn-1 fw-btn-md',
	'title_reply'          => esc_html__('Leave a Comment', 'thebrilliance' ),
	'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'thebrilliance' ),
	'cancel_reply_link'    => esc_html__( 'Cancel Reply', 'thebrilliance' ),
	'label_submit'         => esc_html__( 'Submit', 'thebrilliance' ),
	'comment_field'        => '<div class="right-side-comment row">
		<p class="comment-form-comment col-md-12">
			<textarea id="comment" name="comment" placeholder = "'.esc_attr__('Message','thebrilliance').'" class="required" required></textarea>
		</p>
	</div>',
	'must_log_in'          => '<p class="must-log-in">' . sprintf(
									esc_html__( 'You must be', 'thebrilliance').' <a href="%s">'. esc_html__('logged in', 'thebrilliance').'</a> '. esc_html__('to post a comment.', 'thebrilliance' ),
									wp_login_url( apply_filters( 'the_permalink', $jws_permalink ) )
								) . '</p>',
	'logged_in_as'         => '<p class="logged-in-as">' . sprintf(
									esc_html__( 'Logged in as', 'thebrilliance').' <a href="%1$s">%2$s</a>. <a href="%3$s" title="'.esc_attr__('Log out of this account', 'thebrilliance').'">'.esc_html__('Log out?', 'thebrilliance').'</a>',
									admin_url( 'profile.php' ),
									$user_identity,
									wp_logout_url( apply_filters( 'the_permalink', $jws_permalink ) )
								) . '</p>',
	'comment_notes_before' => '',
	'comment_notes_after'  => '',
	'fields'               => apply_filters( 'comment_form_default_fields', array(
		'author' => '<div class="left-side-comment row">
			<p class="comment-form-author col-md-4">
				<input type="text" placeholder="'.esc_attr__('full name','thebrilliance').'" id="author" name="author" class="required" '.$jws_aria_required.' />
			</p>',
		'email'  => '
			<p class="comment-form-email col-md-4">
				<input type="email" placeholder="'.esc_attr__('email address','thebrilliance').'" id="email" name="email" class="required" '.$jws_aria_required.' />
			</p>',
		'website' =>
            '<p class="comment-form-website col-md-4">
                <input type="text" placeholder = "'.esc_attr__('website','thebrilliance').'" id="url" name="url" size="999" aria-required="false" />
            </p>
		</div>',
		)
	),
);
?>
	<div id="comments" class="comments-area <?php if ( is_user_logged_in() ) {
		echo 'user-is-logged';
	} ?>">
		<?php if ( have_comments() ) : ?>
			<h3 class="comments-title">
				<?php esc_html_e('Reviews','thebrilliance'); ?>
			</h3>
		<?php endif; ?>

		<?php if ( have_comments() ) : ?>
			<ol class="comment-list">
				<?php
				get_template_part( 'comments', 'template' );
				wp_list_comments( array( 'callback' => 'jws_theme_comment' ) );
				?>
			</ol><!-- .comment-list -->

			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
				<nav id="comment-nav-below" class="navigation paging-navigation comment-navigation" role="navigation">
					<div class="pagination loop-pagination">
						<?php paginate_comments_links( array(
							'prev_text' => '<i class="fa fa-angle-left"></i><span>' . esc_html__( 'Previous', 'thebrilliance' ) . '</span>',
							'next_text' => '<span>' . esc_html__( 'Next', 'thebrilliance' ) . '</span><i class="fa fa-angle-right"></i>'
						) ); ?>
					</div>
				</nav>
			<?php endif; // Check for comment navigation. ?>

			<?php if ( ! comments_open() ) : ?>
				<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'thebrilliance' ); ?></p>
			<?php endif; ?>
		<?php endif; // have_comments() ?>
		
			<?php comment_form( $args ); ?>
		
	</div><!-- #comments -->
