<?php
$page_setting = fw_get_db_settings_option( 'general_page' );


?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	
	<div class="col-md-9">

		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		<!-- <div class="meta-post">
			<div class="date-post"><span class="lnr lnr-clock"></span><?php //echo date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ); ?></div>
		</div> -->
		<?php jws_theme_post_thumbnail('full'); ?>

	</div>


	<div class="col-md-3">







		<div class="lp-tab-info">
			
			<?php 
			global $EM_Event;
			$EM_Tickets = $EM_Event->get_bookings()->get_tickets();
			$regular_price = (array_pop($EM_Tickets->tickets)->get_price(true));
			$sale_price = get_field('sale_promote');
			$speaker = get_field('speaker');
			$seat = get_field('seat');
			$cancellation = get_field('cancellation');
			$last_booking = get_field('last_booking');
		    ?>

		    <div class="course-price">
				<div class="sale-price">
					<h4><?php esc_html_e('Price','thebrilliance'); ?></h4>
					<span class="price"><?php echo wp_kses_post($regular_price); ?></span>
				</div>
				<div class="origin-price">
		        	<span class="price"><?php echo wp_kses_post($sale_price); ?></span>
				</div>
			</div>

			<ul class="lp-info-course">
				
					<li>
						<span class="jws-label"><?php esc_html_e('Start Date','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo wp_kses_post($EM_Event->output('#j #M #Y')); ?></span>
					</li>

					<li>
						<span class="jws-label"><?php esc_html_e('End Date','thebrilliance'); ?> </span>
						<span class="jws-value">
							<?php echo wp_kses_post($EM_Event->output('#@_{j M Y}')); ?> </span>
					</li> 

					<li>
						<span class="jws-label"><?php esc_html_e('Time','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo wp_kses_post($EM_Event->output('#_12HSTARTTIME - #_12HENDTIME')); ?> </span>
					</li>

				<?php if ($speaker) : ?> 
					<li>
						<span class="jws-label"><?php esc_html_e('Speaker','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo wp_kses_post($speaker); ?> </span>
					</li>
				<?php endif; ?>

				<?php if ($seat) : ?> 
					<li>
						<span class="jws-label"><?php esc_html_e('Seats','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo wp_kses_post($EM_Event->event_spaces); ?> </span>
					</li>
				<?php endif; ?>

					<li>
						<span class="jws-label"><?php esc_html_e('Location','thebrilliance'); ?></span>
						<span class="jws-value"><?php echo wp_kses_post($EM_Event->output('#_LOCATIONNAME')); ?></span>
					</li>

				<?php if ($cancellation) : ?> 	
					<li>
						<span class="jws-label"><?php esc_html_e('Free Cancellation','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo wp_kses_post($cancellation); ?> </span>
					</li>
				<?php endif; ?>

				<?php if ($last_booking) : ?> 
					<li>
						<span class="jws-label"><?php esc_html_e('Last Day Booking','thebrilliance'); ?> </span>
						<span class="jws-value"><?php echo date_i18n('j M Y', strtotime($last_booking)); ?> </span>
					</li>
				<?php endif; ?>








			</ul>
			<?php //learn_press_course_buttons(); ?>
		</div>
		







	</div>

	<div class="clearfix"></div>




	<div class="entry-content">

		<?php the_content(); ?>

	    <div class="clearfix"></div>

	</div>








	<div class="clearfix"></div>
	<div class="col-md-12">
		<?php //jws_theme_event_nav(); ?>
	</div>
</article>