<?php
global $post_setting;

if(isset($post_setting['posts_layout'])) {
   if($post_setting['posts_layout'] == 'column-1')  {
       $post_layout = 'col-md-12'; 
       $post_layout_thumb = 'full';
   }elseif($post_setting['posts_layout'] == 'columns-2'){
       $post_layout = 'col-md-6';
       $post_layout_thumb = 'jws-archive-post-2col';  
   }elseif($post_setting['posts_layout'] == 'columns-3') {
       $post_layout = 'col-md-4';
       $post_layout_thumb = 'jws-archive-post-3col';  
   }elseif($post_setting['posts_layout'] == 'columns-4') {
       $post_layout = 'col-md-3';
       $post_layout_thumb = 'full';  
   }else {
        $post_layout = 'col-md-12';
        $post_layout_thumb = 'full'; 
   }
}else {
   $post_layout = 'col-md-12'; 
   $post_layout_thumb = 'full'; 
}


$featured_image = isset($post_setting['featured_image']) ? $post_setting['featured_image'] : 'no';
$enabled_readmore = isset($post_setting['enabled_readmore']) ? $post_setting['enabled_readmore'] : 'no';
$post_meta = isset($post_setting['post_meta']) ? $post_setting['post_meta'] : 'no';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class($post_layout); ?>>

	<div class="blog-image">
		<?php 
		if ($featured_image == 'yes'):
			the_post_thumbnail($post_layout_thumb);
		endif;
		?>

		<?php 
		    switch (get_post_format()) {
	    	case 'video':
	    		$icon = '<i class="icon-video-camera"></i>';
	    		break;

	    	case 'gallery':
	    		$icon = '<i class="icon-images"></i>';
	    		break;

	    	case 'image':
	    		$icon = '<i class="icon-photo-camera2"></i>';
	    		break;

	    	case 'quote':
	    		$icon = '<i class="icon-quotes-left"></i>';
	    		break;
	    	
	    	default:
	    		$icon = '<i class="icon-file-text2"></i>';
	    		break;
	    }
	    ?>
	    
	    <?php if (has_post_thumbnail()) : ?>
		    <div class="thumb-format"><?php echo wp_kses_post($icon); ?></div>
		<?php endif; ?>

	    <?php if ($enabled_readmore == 'yes'): ?>
			<div class="readmore">
				<a href="<?php the_permalink(); ?> "><?php if(isset($post_setting['readmore_text'])) { echo esc_html($post_setting['readmore_text']); } ?><span class="lnr lnr-arrow-right"></span></a>
			</div>
		<?php endif; ?>
	</div>
	
	<div class="wrap-content">

		<?php 
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
		endif; 
		?>

		<?php if ($post_meta == 'yes'): ?>
			<div class="meta-post">
                <div class="author"><span class="icon-user"></span>
                    <?php 
                        $author = get_the_author_meta('ID'); 
                        echo '<a href="'.get_author_posts_url($author).'">'.get_the_author().'</a>';
                    ?> 
                </div>
                <div class="date-post"><span class="icon-calendar2"></span><?php echo get_the_date(); ?></div>
            </div>
		<?php endif; ?>
		
		<div class="entry-content">
			<?php the_excerpt(); ?>
		</div><!-- .entry-content -->
	</div>

</article><!-- #post-## -->
