<?php if (!defined('FW')) {
    die('Forbidden');
}

// replace default walker
{
    /** @internal */
    function _filter_theme_ext_mega_menu_wp_nav_menu_args($args)
    {
        $args['walker'] = new FW_Ext_Mega_Menu_Custom_Walker();

        return $args;
    }

    add_filter('wp_nav_menu_args', '_filter_theme_ext_mega_menu_wp_nav_menu_args');
}

// Jws hook
{
    if (!function_exists('_filter_fw_ext_mega_menu_walker_nav_menu_start_el_custom')) :
        /**
         * nav-menu-template.php L174
         * Walker_Nav_Menu::start_el
         *
         * @param $item_output
         * @param $item
         * @param $depth
         * @param $args
         * @return string
         * @internal
         */
        function _filter_fw_ext_mega_menu_walker_nav_menu_start_el_custom($item_output, $item, $depth, $args)
        {
            if (!fw_ext_mega_menu_is_mm_item($item)) {
                return $item_output;
            }

            // Note that raw description is stored in post_content field.
            $trim_post_content = trim($item->post_content);
            if ($depth > 0 && $trim_post_content) {
                $item_output .= '<div>' . do_shortcode($item->post_content) . '</div>';
            }

            return $item_output;
        }
    endif;
    add_filter('walker_nav_menu_start_el_custom', '_filter_fw_ext_mega_menu_walker_nav_menu_start_el_custom', 10, 4);

    if (!function_exists('_thebrilliance_menuitem_filter_content_type_html')) :
        /**
         * _thebrilliance_menuitem_filter_content_type_html
         */
        function _thebrilliance_menuitem_filter_content_type_html($content = '', $options)
        {
            /* check menu item type (default) */
            if ($options['menu_item_type'] != 'default') return $content;

            // echo '<pre>'; print_r($options); echo '</pre>';
            $content .= isset($options['menu_type']['html']['html_content']) ? $options['menu_type']['html']['html_content'] : '';
            return do_shortcode($content);
        }
    endif;
    add_filter('thebrilliance:menuitem:filter:type:html', '_thebrilliance_menuitem_filter_content_type_html', 10, 2);

    if (!function_exists('_thebrilliance_menuitem_filter_content_type_sidebar')) :
        /**
         * _thebrilliance_menuitem_filter_content_type_sidebar
         */
        function _thebrilliance_menuitem_filter_content_type_sidebar($content = '', $options)
        {
            /* check menu item type (default) */
            if ($options['menu_item_type'] != 'default') return $content;

            ob_start();
            dynamic_sidebar($options['menu_type']['sidebar']['sidebar_id']);
            $sidebar_content = ob_get_clean();

            $content .= '<div class="menu-item-custom-wrap sidebar-container">' . $sidebar_content . '</div>';

            return $content;
        }
    endif;
    add_filter('thebrilliance:menuitem:filter:type:sidebar', '_thebrilliance_menuitem_filter_content_type_sidebar', 10, 2);

    if (!function_exists('_thebrilliance_megamenuitem_filter_content_type_sidebar')) :
        /**
         * _thebrilliance_megamenuitem_filter_content_type_sidebar
         *
         */
        function _thebrilliance_megamenuitem_filter_content_type_sidebar($content = '', $options)
        {
            /* check menu item type (default) */
            if ($options['menu_item_type'] != 'item') return $content;

            ob_start();
            dynamic_sidebar($options['mega_menu_type']['sidebar']['sidebar_id']);
            $sidebar_content = ob_get_clean();
            $content .= '<div class="menu-item-custom-wrap sidebar-container">' . $sidebar_content . '</div>';
            return $content;
        }
    endif;
    add_filter('thebrilliance:megamenuitem:filter:type:sidebar', '_thebrilliance_megamenuitem_filter_content_type_sidebar', 10, 2);
}
