<?php
/**
 * Render Css Inline
 *
 * @since 1.0.0
 */
if ( ! function_exists( 'jws_theme_custom_css' ) ) {
    function jws_theme_custom_css( $css = array() ) {
        $css = array();

        // menu color
        if (function_exists('fw_get_db_post_option')) {
            
            // general
            $website_background = jws_get_option_properly('','enable_general_meta','website_background');
            $css[] = 'body{';
            if (isset($website_background['website_bg']['predefined'])):
                if ($website_background['website_bg']['predefined'] != 'none' || $website_background['website_bg']['type'] == 'custom'):
                    $css[] = 'background-image: url('.$website_background['website_bg']['data']['icon'].');';
                endif;
            endif;
            $css[] = '}';

            // footer
            $footer_bg_img = jws_get_option_properly('footer_settings','enable_footer_meta','footer_bg_image');
            if( isset($footer_bg_img['url'])){
                $css[] = '#footer-default{';
                $css[] = 'background-image: url('.$footer_bg_img['url'].');background-size: cover;background-position: center;background-repeat: no-repeat;';
                $css[] = '}';
            }

            // footer bg color
            $footer_bg_color = jws_get_option_properly('footer_settings','enable_footer_meta','footer_bg_color');
            if( isset($footer_bg_color)){
                $css[] = '#footer-default{';
                $css[] = 'background-color: '.$footer_bg_color;
                $css[] = '}';
            }
            // footer text color
            $footer_text_color = jws_get_option_properly('footer_settings','enable_footer_meta','footer_text_color');
            if( isset($footer_text_color)){
                $css[] = '#footer-default,#footer-default ul li a, #footer-default ul.info li{';
                $css[] = 'color: '.$footer_text_color;
                $css[] = '}';
            }

            // header
            $header_menu = jws_get_option_properly('typography_settings','enable_header_meta','header_menu');
            
            if($header_menu):
                $menu_style = jws_get_typo_style($header_menu,'menu');
                $css[] = '.header-v4 .menu ul#menu-main-menu > li a, 
                .header-v1 .menu ul#menu-main-menu > li a, 
                .header-v2 .menu ul#menu-main-menu > li a, 
                .header-v3 .menu ul#menu-main-menu > li a{';
                $css[] = '  font-family: '.$menu_style['menu_font_family'].';
                            font-weight: '.$menu_style['menu_font_weight'].';
                            font-size: '.$menu_style['menu_font_size'].';
                            color: '.$menu_style['menu_text_color'].';
                            text-decoration: none;
                ';
                $css[] = '}';
            endif;

            // logo_text_color
            $logo_text_color = fw_get_db_post_option(get_the_ID(),'page_settings');
            if(isset($logo_text_color['enable_header_meta']['yes']['logo_text_color'])){
                $css[] = '.header-v2 .jws-wrap-logo a strong, 
                .header-v3 .jws-wrap-logo a strong,
                .header-default .main-menu .jws-wrap-logo a strong,
                .header-v4 .jws-wrap-logo a strong,
                .header-v1 .jws-wrap-logo a strong{';
                $css[] = 'color: '.$logo_text_color['enable_header_meta']['yes']['logo_text_color'];
                $css[] = '}';
            }

            // color
            $primary_color = jws_get_option_properly('color_settings','enable_color_meta','primary_color');
            $secondary_color = jws_get_option_properly('color_settings','enable_color_meta','secondary_color');
            if($secondary_color){
                $css[] = '.box-time,
                .list-menu-cat ul li:before,
                .section-products-slider .wrap-products-slider span.slick-arrow:hover, 
                .section-products-slider .wrap-products-slider .product-item .product-thumb .order-btn:hover, 
                .wpcf7-form.home-2 .wpcf7-submit,
                .wrap-gallery-grid.overlay-secondary .gallery-grid .img-item:before,
                .section-menu-food.style-5 .list-menu-cat ul li.active:after, 
                a.btn.btn-photos,
                #back-to-top:hover,
                .wrap-gallery-grid .gallery-grid .img-item:before,
                .jws-block-quote.style-2 .jws-quote-text:before,
                .section-gallery-slider.style-2 span.lnr:hover,
                .header-v4 .menu:after,
                .bg-secondary{';
                $css[] = 'background:'.$secondary_color.'!important';
                $css[] = '}';

                $css[] = '.icon-box span.lnr, 
                .jws-quote-sign:before, 
                .section-testimonials.style-4 .jws-quote-sign:before, 
                .gallery-grid.masonry-3 .square-small.view-all .img-item .wrap-content .title, 
                .gallery-grid.masonry-3 .square-small.view-all .img-item .wrap-content .lnr, 
                ul.controls-filter li.active a, 
                ul.controls-filter li a:hover, 
                .section-specific-post article .wrap-content .entry-title a:hover,
                .section-specific-post.style-3:hover .wrap-specific-post .inner-specific-post .specific-post-readmore a, 
                .color-secondary,
                .extra-sidebar .hotline,
                #back-to-top h2,
                .header-default .main-menu .menu #menu-container > ul > li.current-menu-item > a,
                .header-default .main-menu .menu #menu-container > ul > li.current_page_parent > a,
                .header-default .main-menu .menu #menu-container > ul > li:hover > a,
                .header-v3 .jws-wrap-logo a strong span,
                .section-testimonials.style-3 .testimonials .testimonial-item .jws-quote-sign:before,
                .section-post-grid.layout-3 article:hover .wrap-content .entry-title a{';
                $css[] = 'color:'.$secondary_color.'!important';
                $css[] = '}';

                $css[] = 'a.btn.btn-photos,
                #back-to-top.show,
                .jws-block-quote.style-2 .jws-quote-text:after,
                .jws-quote-info .jws-quote-name{';
                $css[] = 'border-color:'.$secondary_color.'!important';
                $css[] = '}';
            }
        }

        // Custom css
        if (function_exists('fw_get_db_post_option')) {
            if ( fw_get_db_settings_option( 'quick_css' ) ) {
                $css[] = fw_get_db_settings_option( 'quick_css' );
            }

            $style_inline = fw_get_db_post_option(get_the_ID(),'page_settings');
            if ( isset($style_inline['css_inline'] )) {
                $css[] = $style_inline['css_inline'];
            }

        }

        return preg_replace( '/\n|\t/i', '', implode( '', $css ) );
    }
}