<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Filters and Actions
 */

/**
 * Enqueue Google fonts style to admin screen for custom header display.
 * @internal
 */
function jws_action_theme_admin_fonts() {
	wp_enqueue_style( 'fw-theme-font', jws_theme_font_url(), array(), '1.0' );
}

add_action( 'admin_print_scripts-appearance_page_custom-header', 'jws_action_theme_admin_fonts' );

if ( ! function_exists( 'jws_action_theme_setup' ) ) : /**
 * Theme setup.
 *
 * Set up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support post thumbnails.
 * @internal
 */ 
	function jws_action_theme_setup() {

		/*
		 * Make Theme available for translation.
		 */
		load_theme_textdomain( 'thebrilliance', get_template_directory() . '/languages' );

		// Add RSS feed links to <head> for posts and comments.
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( "title-tag" );
		add_theme_support('custom-header');
		add_theme_support( 'custom-background', apply_filters( 'jwstheme_custom_background_args', array(
            'default-color' => '#f5f5f5',
        ) ) );

		// Enable support for Post Thumbnails, and declare two sizes.
		add_theme_support( 'post-thumbnails' );
		
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );

		set_post_thumbnail_size( 811, 372, true );
		add_image_size( 'jws-theme-full-width', 1038, 576, true );

		add_image_size( 'jws-related-post-2col', 600, 600, true );
		add_image_size( 'jws-related-post-3col', 400, 400, true );
		add_image_size( 'jws-related-post-4col', 300, 300, true );

		add_image_size( 'jws-archive-post-2col', 600, 600, true );
		add_image_size( 'jws-archive-post-3col', 400, 400, true );
		add_image_size( 'jws-archive-post-4col', 300, 300, true );

		// This theme uses wp_nav_menu() in locations.
        register_nav_menus( array(
            'main_navigation'   =>esc_html__( 'Main Navigation','thebrilliance' ),
        ) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption'
		) );

		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'audio',
			'quote',
			'link',
			'gallery',
		) ); 

		add_theme_support(
			'editor-color-palette',
			array(
				array(
					'name'  =>esc_html__( 'Primary', 'thebrilliance' ),
					'slug'  => 'primary',
					'color' => '#978970',
				),
				array(
					'name'  =>esc_html__( 'Secondary', 'thebrilliance' ),
					'slug'  => 'secondary',
					'color' => '#000235',
				),
				array(
					'name'  =>esc_html__( 'Dark Gray', 'thebrilliance' ),
					'slug'  => 'dark-gray',
					'color' => '#111',
				),
				array(
					'name'  =>esc_html__( 'Light Gray', 'thebrilliance' ),
					'slug'  => 'light-gray',
					'color' => '#767676',
				),
				array(
					'name'  =>esc_html__( 'White', 'thebrilliance' ),
					'slug'  => 'white',
					'color' => '#FFF',
				),
			)
		);

		// Add support for featured content.
		add_theme_support( 'featured-content', array(
			'featured_content_filter' => 'jws_theme_get_featured_posts',
			'max_posts'               => 6,
		) );
        add_editor_style('css/editor-style.css');
		add_theme_support( 'gutenberg' );
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-styles' );
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );

		add_filter( 'use_default_gallery_style', '__return_false' );
	}

endif;
add_action( 'init', 'jws_action_theme_setup', 0 );


// Add backend styles for Gutenberg.
add_action( 'enqueue_block_editor_assets', 'jws_add_gutenberg_assets' );

/**
 * Load Gutenberg stylesheet.
 */
function jws_add_gutenberg_assets() {
	// Load the theme styles within Gutenberg.

	wp_enqueue_style( 'jws-gutenberg', JWS_URI_PATH .'/assets/css/gutenberg-editor-style.css', false );
}

/**
 * Adjust content_width value for image attachment template.
 * @internal
 */
function jws_action_theme_content_width() {
	if ( is_attachment() && wp_attachment_is_image() ) {
		$GLOBALS['content_width'] = 810;
	}
}

add_action( 'template_redirect', 'jws_action_theme_content_width' );

/**
 * Extend the default WordPress body classes.
 *
 * Adds body classes to denote:
 * 1. Single or multiple authors.
 * 2. Presence of header image.
 * 3. Index views.
 * 4. Full-width content layout.
 * 5. Presence of footer widgets.
 * 6. Single views.
 * 7. Featured content layout.
 *
 * @param array $classes A list of existing body class values.
 *
 * @return array The filtered body class list.
 * @internal
 */
function jws_filter_theme_body_classes( $classes ) {
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	if ( get_header_image() ) {
		$classes[] = 'header-image';
	} else {
		$classes[] = 'masthead-fixed';
	}

	if ( is_archive() || is_search() || is_home() ) {
		$classes[] = 'list-view';
	}

	if ( function_exists('fw_ext_sidebars_get_current_position') ) {
		$current_position = fw_ext_sidebars_get_current_position();
		if ( in_array( $current_position, array( 'full', 'left' ) )
		     || empty($current_position)
		     || is_page_template( 'page-templates/full-width.php' )
		     || is_page_template( 'page-templates/contributors.php' )
		     || is_attachment()
		) {
			$classes[] = 'full-width';
		}
	} else {
		$classes[] = 'full-width';
	}

	if ( is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'footer-widgets';
	}

	if ( is_singular() && ! is_front_page() ) {
		$classes[] = 'singular';
	}

	if ( is_front_page() && 'slider' == get_theme_mod( 'featured_content_layout' ) ) {
		$classes[] = 'slider';
	} elseif ( is_front_page() ) {
		$classes[] = 'grid';
	}

	return $classes;
}

add_filter( 'body_class', 'jws_filter_theme_body_classes' );

/**
 * Extend the default WordPress post classes.
 *
 * Adds a post class to denote:
 * Non-password protected page with a post thumbnail.
 *
 * @param array $classes A list of existing post class values.
 *
 * @return array The filtered post class list.
 * @internal
 */
function jws_filter_theme_post_classes( $classes ) {
	if ( ! post_password_required() && ! is_attachment() && has_post_thumbnail() ) {
		$classes[] = 'has-post-thumbnail';
	}

	return $classes;
}

add_filter( 'post_class', 'jws_filter_theme_post_classes' );

/**
 * Create a nicely formatted and more specific title element text for output
 * in head of document, based on current view.
 *
 * @param string $title Default title text for current view.
 * @param string $sep Optional separator.
 *
 * @return string The filtered title.
 * @internal
 */
if ( ! function_exists( 'jws_filter_theme_wp_title' ) ):
	
	function jws_filter_theme_wp_title( $title, $sep ) {
		global $paged, $page;

		if ( is_feed() ) {
			return $title;
		}

		// Add the site name.
		$title .= get_bloginfo( 'name', 'display' );

		// Add the site description for the home/front page.
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_home() || is_front_page() ) ) {
			$title = "$title $sep $site_description";
		}

		// Add a page number if necessary.
		if ( $paged >= 2 || $page >= 2 ) {
			$title = "$title $sep " . sprintf(esc_html__( 'Page %s', 'thebrilliance' ), max( $paged, $page ) );
		}

		return $title;
	}

endif;

add_filter( 'wp_title', 'jws_filter_theme_wp_title', 10, 2 );


/**
 * Flush out the transients used in jws_theme_categorized_blog.
 * @internal
 */
if ( ! function_exists( 'jws_action_theme_category_transient_flusher' ) ):

	function jws_action_theme_category_transient_flusher() {
		// Like, beat it. Dig?
		delete_transient( 'jws_theme_category_count' );
	}

	add_action( 'edit_category', 'jws_action_theme_category_transient_flusher' );

	add_action( 'save_post', 'jws_action_theme_category_transient_flusher' );

endif;



/**
 * Theme Customizer support
 */
{
	/**
	 * Implement Theme Customizer additions and adjustments.
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 *
	 * @internal
	 */
	if ( ! function_exists( 'jws_action_theme_customize_register' ) ):
	
		function jws_action_theme_customize_register( $wp_customize ) {
			// Add custom description to Colors and Background sections.
			$wp_customize->get_section( 'colors' )->description           =esc_html__( 'Background may only be visible on wide screens.',
				'thebrilliance' );
			$wp_customize->get_section( 'background_image' )->description =esc_html__( 'Background may only be visible on wide screens.',
				'thebrilliance' );

			// Add postMessage support for site title and description.
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

			// Rename the label to "Site Title Color" because this only affects the site title in this theme.
			$wp_customize->get_control( 'header_textcolor' )->label =esc_html__( 'Site Title Color', 'thebrilliance' );

			// Rename the label to "Display Site Title & Tagline" in order to make this option extra clear.
			$wp_customize->get_control( 'display_header_text' )->label =esc_html__( 'Display Site Title &amp; Tagline', 'thebrilliance' );

			// Add the featured content section in case it's not already there.
			$wp_customize->add_section( 'featured_content', array(
				'title'       =>esc_html__( 'Featured Content', 'thebrilliance' ),
				'description' => sprintf(esc_html__( 'Use a <a href="%1$s">tag</a> to feature your posts. If no posts match the tag, <a href="%2$s">sticky posts</a> will be displayed instead.',
						'thebrilliance' ),
					esc_url( add_query_arg( 'tag', _x( 'featured', 'featured content default tag slug', 'thebrilliance' ),
							admin_url( 'edit.php' ) ) ),
					admin_url( 'edit.php?show_sticky=1' )
				),
				'priority'    => 130,
			) );

			// Add the featured content layout setting and control.
			$wp_customize->add_setting( 'featured_content_layout', array(
				'default'           => 'grid',
				'sanitize_callback' => 'jws_jws_theme_sanitize_layout',
			) );

			$wp_customize->add_control( 'featured_content_layout', array(
				'label'   =>esc_html__( 'Layout', 'thebrilliance' ),
				'section' => 'featured_content',
				'type'    => 'select',
				'choices' => array(
					'grid'   =>esc_html__( 'Grid', 'thebrilliance' ),
					'slider' =>esc_html__( 'Slider', 'thebrilliance' ),
				),
			) );
		}


	add_action( 'customize_register', 'jws_action_theme_customize_register' );

	endif;


	/**
	 * Sanitize the Featured Content layout value.
	 *
	 * @param string $layout Layout type.
	 *
	 * @return string Filtered layout type (grid|slider).
	 * @internal
	 */
	if ( ! function_exists( 'jws_action_theme_customize_preview_js' ) ):

		function jws_jws_theme_sanitize_layout( $layout ) {
			if ( ! in_array( $layout, array( 'grid', 'slider' ) ) ) {
				$layout = 'grid';
			}

			return $layout;
		}

	endif;

	if ( ! function_exists( 'jws_action_theme_customize_preview_js' ) ):
		/**
		 * Bind JS handlers to make Theme Customizer preview reload changes asynchronously.
		 * @internal
		 */
		function jws_action_theme_customize_preview_js() {
			wp_enqueue_script(
				'fw-theme-customizer',
				get_template_directory_uri() . '/js/customizer.js',
				array( 'customize-preview' ),
				'1.0',
				true
			);
		}

		add_action( 'customize_preview_init', 'jws_action_theme_customize_preview_js' );

	endif;

}

if ( ! function_exists( 'jws_action_theme_widgets_init' ) ):
	/**
	 * Register widget areas.
	 * @internal
	 */
	function jws_action_theme_widgets_init() {
		register_sidebar( array(
			'name'          =>esc_html__( 'Default Widget Area', 'thebrilliance' ),
			'id'            => 'default-widget',
			'description'   =>esc_html__( 'Appears in the default section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h1 class="widget-title">',
			'after_title'   => '</h1>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Mini Button', 'thebrilliance' ),
			'id'            => 'mini-btn',
			'description'   =>esc_html__( 'Appears in the mini button section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Blog Widget', 'thebrilliance' ),
			'id'            => 'blog-widget',
			'description'   =>esc_html__( 'Appears in the blog section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Page Widget', 'thebrilliance' ),
			'id'            => 'page-widget',
			'description'   =>esc_html__( 'Appears in the page section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		

		register_sidebar( array(
			'name'          =>esc_html__( 'Course Widget', 'thebrilliance' ),
			'id'            => 'course-widget',
			'description'   =>esc_html__( 'Appears in the course section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Event Widget', 'thebrilliance' ),
			'id'            => 'event-widget',
			'description'   =>esc_html__( 'Appears in the event section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Shop Widget', 'thebrilliance' ),
			'id'            => 'shop-widget',
			'description'   =>esc_html__( 'Appears in the shop section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Shortcode ft Widget', 'thebrilliance' ),
			'id'            => 'footer-widget',
			'description'   =>esc_html__( 'Appears in the shop section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Header Widget', 'thebrilliance' ),
			'id'            => 'header-widget',
			'description'   =>esc_html__( 'Appears in the extra section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          =>esc_html__( 'Languages Widget', 'thebrilliance' ),
			'id'            => 'languages-widget',
			'description'   =>esc_html__( 'Appears in the extra section of the site.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
        register_sidebar( array(
			'name'          =>esc_html__( 'Mega Widget', 'thebrilliance' ),
			'id'            => 'mega-widget',
			'description'   =>esc_html__( 'Widget for mega menu.', 'thebrilliance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	add_action( 'widgets_init', 'jws_action_theme_widgets_init' );

endif;



if ( defined( 'FW' ) ):
	/**
	 * Display current submitted FW_Form errors
	 * @return array
	 */
	if ( ! function_exists( 'jws_action_theme_display_form_errors' ) ):
		function jws_action_theme_display_form_errors() {
			$form = FW_Form::get_submitted();

			if ( ! $form || $form->is_valid() ) {
				return;
			}

			wp_enqueue_script(
				'fw-theme-show-form-errors',
				get_template_directory_uri() . '/js/form-errors.js',
				array( 'jquery' ),
				'1.0',
				true
			);

			wp_localize_script( 'fw-theme-show-form-errors', '_localized_form_errors', array(
				'errors'  => $form->get_errors(),
				'form_id' => $form->get_id()
			) );
		}
	endif;

	add_action('wp_enqueue_scripts', 'jws_action_theme_display_form_errors');

endif;


if( ! function_exists( 'jws_filter_fw_settings_form_header_buttons' ) ) :
	/**
	 * Add an extra options for post event
	 */
	function jws_filter_fw_settings_form_header_buttons( $arr ){
		$arr2[] = '<a class="fw-theme-docs-link" target="_blank" href="http://docs.themefuse.com/the-core">'.esc_html__('Go to Docs', 'thebrilliance').'</a>';
		$arr = array_merge( $arr2, $arr );

		return $arr;
	}

	add_filter('fw_settings_form_header_buttons', 'jws_filter_fw_settings_form_header_buttons');

endif;



if ( ! function_exists( 'jws_action_theme_includes_additional_option_types' ) ) :
	/**
	 * Include addition option types
	 */
	function jws_action_theme_includes_additional_option_types() {
		$the_core_template_directory = get_template_directory();

		load_template( $the_core_template_directory . '/framework-theme/includes/option-types/color-palette/class-fw-color-palette-new.php' );
		load_template( $the_core_template_directory . '/framework-theme/includes/option-types/tf-animation/class-fw-option-type-tf-animation.php' ); 
		load_template( $the_core_template_directory . '/framework-theme/includes/option-types/tf-typography/class-fw-option-type-tf-typography.php' );
	}

	add_action( 'fw_option_types_init', 'jws_action_theme_includes_additional_option_types' );

endif;

if ( ! function_exists( 'jws_action_set_global_colors' ) ) :
	/**
	 * Set global colors
	 */
	function jws_action_set_global_colors() {

		global $the_core_color_settings;
		$the_core_colors         = array(
			'color_1' => '#d12a5c',
			'color_2' => '#49ca9f',
			'color_3' => '#1f1f1f',
			'color_4' => '#808080',
			'color_5' => '#ebebeb'
		);
		$the_core_color_settings = function_exists('fw_get_db_settings_option') ? fw_get_db_settings_option( 'color_settings', $the_core_colors ) : $the_core_colors;

	}

	add_action( 'init', 'jws_action_set_global_colors' );

endif;



if ( ! function_exists( 'jwstheme_init' ) ) :

	/* Init Functions */
	function jwstheme_init() {
		if (function_exists('fw_get_db_settings_option')) {
			$less = fw_get_db_settings_option( 'enable_less' );
			if(isset($less) && $less == 'yes') {
			    require_once JWS_ABS_PATH_FR.'/presets.php';
			}
		}
	}

	add_action( 'init', 'jwstheme_init' );

endif;

if ( ! function_exists( 'jws_move_comment_field' ) ) :

	function jws_move_comment_field( $fields ) {
	    $comment_field = $fields['comment'];
	    unset( $fields['comment'] );
	    $fields['comment'] = $comment_field;
	    return $fields;
	}

	// change positon form field
	add_filter( 'comment_form_fields', 'jws_move_comment_field' );

endif;

if ( ! function_exists( 'jws_excerpt_length' ) ) :

	function jws_excerpt_length( $length ) {
		$post_length = 35;
		
		if (function_exists('fw_get_db_settings_option')) {
			$post_setting = fw_get_db_settings_option( 'posts_settings' );
			if($post_setting['posts_excerpt_length']){
				$post_length = $post_setting['posts_excerpt_length'];
			}
		}
		if(isset($_GET['posts_excerpt_length'])){
			$post_length = $_GET['posts_excerpt_length'];
		}
	    return $post_length;
	}

	add_filter( 'excerpt_length', 'jws_excerpt_length', 999 );

	function wpdocs_excerpt_more( $more ) {
	    return '';
	}

	add_filter( 'excerpt_more', 'wpdocs_excerpt_more' );

endif;



add_filter( 'woocommerce_output_related_products_args', 'jws_related_products_args' );

if ( ! function_exists( 'jws_related_products_args' ) ) :

	function jws_related_products_args( $args ) {
	    $args['posts_per_page'] = 3; 
	    return $args;
	}

endif;


add_action('pre_get_posts', 'change_posts_per_page_archive_size',99, 3 );

function change_posts_per_page_archive_size($query) {
     if ( isset($_GET['posts_per_page']) ) {
        $query->set( 'posts_per_page', $_GET['posts_per_page'] );
        return;
    }
}

if ( ! function_exists( 'jws_action_coming_soon_page' ) ) :
	/**
	 * Coming soon page
	 */
	function jws_action_coming_soon_page() {
		global $coming_soon;
		$coming_soon = false;
		$enable_coming_soon = function_exists( 'fw_get_db_settings_option' ) ? fw_get_db_settings_option('enable_coming_soon') : array();

		if( isset($enable_coming_soon['selected']) && $enable_coming_soon['selected'] == 'yes' ){
			// if is enabled coming soon
			if( !is_user_logged_in() && $enable_coming_soon['yes']['coming_soon_page'] != '0' ){
				// if user is not logged in and coming soon page is selected

				if( function_exists('jws_is_page_url_excluded') ){
					if( jws_is_page_url_excluded() ){
						return;
					}
				} 

				$coming_soon = true;
				global $wp_query;
				$wp_query = new WP_Query();
				$wp_query->query( 'page_id=' . $enable_coming_soon['yes']['coming_soon_page'] );
				$wp_query->the_post();
				rewind_posts();
				nocache_headers();
				include_once get_template_directory() . '/coming-soon-template.php';
				exit();
			}
		}
	}
endif;

add_action( 'send_headers', 'jws_action_coming_soon_page', 12 );

if ( ! function_exists( 'jws_admin_add_google_fonts' ) ) :

	function jws_admin_add_google_fonts() {
	 
		wp_enqueue_style( 'admin-google-fonts', 'https://fonts.googleapis.com/css?family=Poppins:300,300i,400,400i,500,500i,600,600i,700,700i', false ); 
	}

endif;
 
add_action( 'admin_enqueue_scripts', 'jws_admin_add_google_fonts' );

if(function_exists('insert_balance_tags')){ 
function jws_remove_empty_p( $content ) {
    $content = insert_balance_tags( $content );
    $content = preg_replace( '#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content );
    $content = preg_replace( '~\s?<p>(\s| )+</p>\s?~', '', $content );
    return $content;
}

add_filter('the_content', 'jws_remove_empty_p', 20, 1);  
}



function set_posts_per_page_for_course( $query ) {

	global $course_settings;
	if(isset($course_settings['archive_course_limit_posts'])){
		$archive_course_limit_posts = $course_settings['archive_course_limit_posts'];
	}else{
		$archive_course_limit_posts = 6;
	}

	if ( !is_admin() && $query->is_main_query() && is_post_type_archive( 'lp_course' ) ) {
		$query->set( 'posts_per_page', $archive_course_limit_posts );
	}
}
add_action( 'pre_get_posts', 'set_posts_per_page_for_course' );