<?php if ( ! function_exists( 'jwstheme_login_popup' ) ) {
    function jwstheme_login_popup() { 
    $registration_enabled = get_option( 'users_can_register' );

    if ( ! is_user_logged_in() ): ?>
	<div id="jws-popup-login">
		<div class="jws-login-container">
            <div class="jws-animation">
			<?php

			$current_page_id = get_queried_object_id();
			?>

			<div class="jws-login active">
				<?php
		

				// Set link via priority
				if ( ! empty( $_REQUEST['redirect_to'] ) ) {
					$login_redirect = $_REQUEST['redirect_to'];
				}  else {
					$login_redirect = get_permalink( $current_page_id );
				}

				if ( is_singular( 'lp_course' ) ) {

						$login_redirect = add_query_arg( array( 'enroll-course' => $current_page_id ), $login_redirect );

				}
				?>

				<h4 class="title"><?php esc_html_e( 'Login', 'thebrilliance' ); ?></h4>
				<form name="loginpopopform" id="loginform" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">
                
					<p class="login-username">
						<input type="text" name="log" placeholder="<?php esc_html_e( 'Username or email', 'thebrilliance' ); ?>" class="input required" value="" size="20" />
					</p>
					<p class="login-password">
						<input type="password" name="pwd" placeholder="<?php esc_html_e( 'Password', 'thebrilliance' ); ?>" class="input required" value="" size="20" />
					</p>
				

					<?php echo '<a class="lost-pass-link" href="' . jws_get_lost_password_url() . '" title="' . esc_attr__( 'Lost Password', 'thebrilliance' ) . '">' . esc_html__( 'Lost your password?', 'thebrilliance' ) . '</a>'; ?>
					<p class="forgetmenot login-remember">
						<label for="popupRememberme"><input name="rememberme" type="checkbox" value="forever" id="popupRememberme" /> <?php esc_html_e( 'Remember Me', 'thebrilliance' ); ?>
						</label></p>
					<p class="submit login-submit">
						<input type="submit" name="wp-submit" class="button button-primary button-large" value="<?php esc_attr_e( 'Login', 'thebrilliance' ); ?>" />
						<input type="hidden" name="redirect_to" value="<?php echo esc_url( $login_redirect ); ?>" />
						<input type="hidden" name="testcookie" value="1" />
					</p>


				</form>
				<?php

				if ( $registration_enabled ) {
					echo '<p class="link-bottom">' . esc_html__( 'Not a member yet? ', 'thebrilliance' ) . '<a class="register" href="' . esc_url( jws_get_register_url() ) . '">' . esc_html__( 'Register now', 'thebrilliance' ) . '</a></p>';
				}
				?>
			</div>

			<?php if ( $registration_enabled ): ?>
				<div class="jws-register">
					<?php


					// Set link via priority
					if ( ! empty( $_REQUEST['redirect_to'] ) ) {
						$register_redirect = $_REQUEST['redirect_to'];
					} else {
						$register_redirect = get_permalink( $current_page_id );
					}

					if ( is_singular( 'lp_course' ) ) {

							$register_redirect = add_query_arg( array( 'enroll-course' => $current_page_id ), $register_redirect );
					
					}
					?>

					<h4 class="title"><?php echo esc_html_x( 'Register', 'Login popup form', 'thebrilliance' ); ?></h4>

					<form class="auto_login" name="registerformpopup" action="<?php echo esc_url( site_url( 'wp-login.php?action=register', 'login_post' ) ); ?>" method="post" novalidate="novalidate">

						<?php wp_nonce_field( 'ajax_register_nonce', 'register_security' ); ?>

						<p>
							<input placeholder="<?php esc_attr_e( 'Username', 'thebrilliance' ); ?>" type="text" name="user_login" class="input required" />
						</p>

						<p>
							<input placeholder="<?php esc_attr_e( 'Email', 'thebrilliance' ); ?>" type="email" name="user_email" class="input required" />
						</p>

				
							<p>
								<input placeholder="<?php esc_attr_e( 'Password', 'thebrilliance' ); ?>" type="password" name="password" class="input required" />
							</p>
							<p>
								<input placeholder="<?php esc_attr_e( 'Repeat Password', 'thebrilliance' ); ?>" type="password" name="repeat_password" class="input required" />
							</p>

		
						<p>
							<input type="hidden" name="redirect_to" value="<?php echo esc_url( $register_redirect ); ?>" />
							<input type="hidden" name="modify_user_notification" value="1">
						</p>

						<?php do_action( 'signup_hidden_fields', 'create-another-site' ); ?>

						<p class="submit">
							<input type="submit" name="wp-submit" class="button button-primary button-large" value="<?php echo esc_attr_x( 'Sign up', 'Login popup form', 'thebrilliance' ); ?>" />
						</p>
					</form>
					<?php echo '<p class="link-bottom">' . esc_html_x( 'Are you a member? ', 'Login popup form', 'thebrilliance' ) . '<a class="login" href="' . esc_url( jws_get_login_page_url() ) . '">' . esc_html_x( 'Login now', 'Login popup form', 'thebrilliance' ) . '</a></p>'; ?>

					<div class="popup-message"></div>
				</div>
			<?php endif; ?>
            <?php 
             if (defined('FW')) {
                $social_shortcode = fw_get_db_settings_option('header_settings');
                if(!empty($social_shortcode['login_social_popup'])) {
                     echo do_shortcode($social_shortcode['login_social_popup']); 
                } 
             }
                
            ?>
            <span class="close-popup"><i class="fa fa-times" aria-hidden="true"></i></span>
            </div>
		</div>
	</div>
<?php endif; ?>
        
    <?php }
    add_action('wp_footer','jwstheme_login_popup');
}

/**
 * Filter lost password link
 *
 * @param $url
 *
 * @return string
 */
if ( ! function_exists( 'jws_get_lost_password_url' ) ) {
	function jws_get_lost_password_url() {
		$url = add_query_arg( 'action', 'lostpassword', jws_get_login_page_url() );

		return $url;
	}
}

/**
 * Get login page url
 *
 * @return false|string
 */
if ( ! function_exists( 'jws_get_login_page_url' ) ) {
	function jws_get_login_page_url() {

		if ( function_exists('jws_plugin_active') && !jws_plugin_active( 'js_composer/js_composer.php' ) ) {
			return wp_login_url();  
		}

	
		global $wpdb;
		$page = $wpdb->get_col(
		$wpdb->prepare(
					"SELECT p.ID FROM $wpdb->posts AS p INNER JOIN $wpdb->postmeta AS pm ON p.ID = pm.post_id
			WHERE 	pm.meta_key = %s
			AND 	pm.meta_value = %s
			AND		p.post_type = %s
			AND		p.post_status = %s",
					'jws_login_page',
					'1',
					'page',
					'publish'
				)
			);
			if ( ! empty( $page[0] ) ) {
				return get_permalink( $page[0] );
			}
	

		return wp_login_url();

	}
}


/**
 * Filter register link
 *
 * @param $register_url
 *
 * @return string|void
 */
if ( ! function_exists( 'jws_get_register_url' ) ) {
	function jws_get_register_url() {
		$url = add_query_arg( 'action', 'register', jws_get_login_page_url() );

		return $url;
	}
}
if ( ! is_multisite() ) {
	add_filter( 'register_url', 'jws_get_register_url' );
}

/*
 * Process ajax register popup
 * */
if ( ! function_exists( 'jws_register_ajax_callback' ) ) {
	function jws_register_ajax_callback() {

		// First check the nonce, if it fails the function will break
		$secure = check_ajax_referer( 'ajax_register_nonce', 'register_security', false );

		if ( ! $secure ) {
			$response_data = array(
				'message' => '<p class="message message-error">' . esc_html__( 'Something wrong. Please try again.', 'thebrilliance' ) . '</p>'
			);

			wp_send_json_error( $response_data );
		}

		parse_str( $_POST['data'], $data );

		foreach ( $data as $k => $v ) {
			$_POST[ $k ] = $v;
		}

		$_POST['is_popup_register'] = 1;

		if ( ! empty( $data['modify_user_notification'] ) ) {
			$_REQUEST['modify_user_notification'] = 1;
		}

		$info = array();

		$info['user_login'] = sanitize_user( $data['user_login'] );
		$info['user_email'] = sanitize_email( $data['user_email'] );
		$info['user_pass']  = sanitize_text_field( $data['password'] );


			$confirm_password = sanitize_text_field( $data['repeat_password'] );

			if ( $info['user_pass'] !== $confirm_password ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'Those passwords didn\'t match. Try again.', 'thebrilliance' ) . '</p>'
				);

				wp_send_json_error( $response_data );
			}
	

		// Register the user
		$user_register = register_new_user( $info['user_login'], $info['user_email'] );

		if ( is_wp_error( $user_register ) ) {
			$error = $user_register->get_error_codes();
      
			if ( in_array( 'gglcptch_error', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'You have entered an incorrect reCAPTCHA value.', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'empty_username', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'Please enter a username!', 'thebrilliance' ) . '</p>'
				);
			}elseif ( in_array( 'empty_password', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'Please enter a password!', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'invalid_username', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'The username is invalid. Please try again!', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'username_exists', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'This username is already registered. Please choose another one!', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'empty_email', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'Please type your e-mail address!', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'invalid_email', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'The email address isn\'t correct. Please try again!', 'thebrilliance' ) . '</p>'
				);
			} elseif ( in_array( 'email_exists', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error">' . esc_html__( 'This email is already registered. Please choose another one!', 'thebrilliance' ) . '</p>'
				);
			}

			wp_send_json_error( $response_data );
		} else {
		
				wp_new_user_notification( $user_register, null, 'admin' );

				wp_set_current_user( $user_register );
				wp_set_auth_cookie( $user_register );

				$response_data = array(
					'message' => '<p class="message message-success">' . esc_html__( 'Registration successful, redirecting...', 'thebrilliance' ) . '</p>'
				);

				wp_send_json_success( $response_data );
		
		}
	}
}

if ( get_option( 'users_can_register' ) ) {
	add_action( 'wp_ajax_nopriv_jws_register_ajax', 'jws_register_ajax_callback' );
}


add_action( 'wp_ajax_nopriv_jws_login_ajax', 'jws_login_ajax_callback' );
add_action( 'wp_ajax_jws_login_ajax', 'jws_login_ajax_callback' );
if ( ! function_exists( 'jws_login_ajax_callback' ) ) {
	function jws_login_ajax_callback() {
		//ob_start();
		if ( empty( $_REQUEST['data'] ) ) {
			$response_data = array(
				'code'    => - 1,
				'message' => '<p class="message message-error">' . esc_html__( 'Something wrong. Please try again.', 'thebrilliance' ) . '</p>'
			);
		} else {

			parse_str( $_REQUEST['data'], $login_data );

			foreach ( $login_data as $k => $v ) {
				$_POST[ $k ] = $v;
			}

			//			$_POST['wp-submit'] = $login_data['wp-submit'];

			$user_verify = wp_signon( array(), is_ssl() );

			$code    = 1;
			$message = '';

			if ( is_wp_error( $user_verify ) ) {
				if ( ! empty( $user_verify->errors ) ) {
					$errors = $user_verify->errors;

					if ( ! empty( $errors['gglcptch_error'] ) ) {
						$message = '<p class="message message-error">' . esc_html__( 'You have entered an incorrect reCAPTCHA value.', 'thebrilliance' ) . '</p>';
					} elseif ( ! empty( $errors['invalid_username'] ) || ! empty( $errors['incorrect_password'] ) ) {
						$message = '<p class="message message-error">' . esc_html__( 'Invalid username or password. Please try again!', 'thebrilliance' ) . '</p>';
					} else if ( ! empty( $errors['cptch_error'] ) && is_array( $errors['cptch_error'] ) ) {
						foreach ( $errors['cptch_error'] as $key => $value ) {
							$message .= '<p class="message message-error">' . $value . '</p>';
						}
					} else {
						$message = '<p class="message message-error">' . esc_html__( 'Something wrong. Please try again.', 'thebrilliance' ) . '</p>';
					}
				} else {
					$message = '<p class="message message-error">' . esc_html__( 'Something wrong. Please try again.', 'thebrilliance' ) . '</p>';
				}
				$code = - 1;
			} else {
				$message = '<p class="message message-success">' . esc_html__( 'Login successful, redirecting...', 'thebrilliance' ) . '</p>';
			}

			$response_data = array(
				'code'    => $code,
				'message' => $message
			);

			if ( ! empty( $login_data['redirect_to'] ) ) {
				$response_data['redirect'] = $login_data['redirect_to'];
			}
		}
		echo json_encode( $response_data );
		die(); // this is required to return a proper result
	}
}