<?php


  if ( ! function_exists( 'jwstheme_autoCompileLess' ) ) :

	function jwstheme_autoCompileLess($inputFile, $outputFile) {
	    require_once( ABSPATH.'/wp-admin/includes/file.php' );	
		WP_Filesystem();
		require_once ( JWS_ABS_PATH_FR . '/inc/lessc.inc.php' );
		global $wp_filesystem;
	    $less = new lessc();
	    $less->setFormatter("classic");
        $less->setFormatter("compressed");
	    $less->setPreserveComments(true);
		/*Styling Options*/
		$preset_color = 'default';
		$jws_settings_option      	= fw_get_db_settings_option();
		$jws_color_settings       	= $jws_settings_option['color_settings'];
		$jws_typography_settings  	= $jws_settings_option['typography_settings'];
		$jws_logo_settings  	 	= $jws_settings_option['logo_settings'];
		$jws_website_background   = $jws_settings_option['website_background'];
		$jws_header_settings      = $jws_settings_option['header_settings'];
		$jws_footer_settings = $jws_settings_option['footer_settings'];
		$footer_bg_color = $jws_footer_settings['footer_bg_color'];
		$footer_text_color = $jws_footer_settings['footer_text_color'];

		
	    if( isset($jws_typography_settings['header_menu_hover']) && $jws_typography_settings['header_menu_hover'] != ''){
	    	$menu_hover_color = $jws_typography_settings['header_menu_hover'];
	    }else{
	    	$menu_hover_color = '#978970';
	    }
		$primary_color 				= $jws_color_settings['primary_color'];
		$secondary_color 			= $jws_color_settings['secondary_color'];
		$body_bg_color 				= $jws_website_background['website_bg_color'];
		$header_bg_color 			= isset($jws_header_settings['header_bg_color']) && $jws_header_settings['header_bg_color'] != '' ? $jws_header_settings['header_bg_color'] : '#ffffff';
		$dropdown_bg_color			= isset($jws_header_settings['dropdown_bg_color']) && $jws_header_settings['dropdown_bg_color'] != ''? $jws_header_settings['dropdown_bg_color'] : '#ffffff';
		$dropdown_links_color		= isset($jws_header_settings['dropdown_links_color']) && $jws_header_settings['dropdown_links_color'] != ''? $jws_header_settings['dropdown_links_color'] : '#606060'; 

		$typo_logo = jws_get_typo_style($jws_logo_settings['logo']["text"]["logo_title_font"],'logo');
		$typo_menu = jws_get_typo_style($jws_typography_settings['header_menu'],'menu');
		$typo_body = jws_get_typo_style($jws_typography_settings['body_text'],'body');
		$typo_h1 = jws_get_typo_style($jws_typography_settings['h1'],'h1');
		$typo_h2 = jws_get_typo_style($jws_typography_settings['h2'],'h2');
		$typo_h3 = jws_get_typo_style($jws_typography_settings['h3'],'h3');
		$typo_h4 = jws_get_typo_style($jws_typography_settings['h4'],'h4');
		$typo_h5 = jws_get_typo_style($jws_typography_settings['h5'],'h5');
		$typo_h6 = jws_get_typo_style($jws_typography_settings['h6'],'h6');
	    $variables_default = array(
			"primary_color" => $primary_color,
			"secondary_color" => $secondary_color,
			"body_bg_color" => $body_bg_color,
			"header_bg_color" => $header_bg_color,
			"dropdown_bg_color" => $dropdown_bg_color,
			"dropdown_links_color" => $dropdown_links_color,
			"footer_bg_color" => $footer_bg_color,
			"footer_text_color" => $footer_text_color,
			"menu_hover_color" => $menu_hover_color,
	    );

		$variables = array_merge($variables_default, $typo_h1, $typo_h2, $typo_h3, $typo_h4, $typo_h5, $typo_h6, $typo_menu, $typo_body, $typo_logo);

	    $less->setVariables($variables);
	    $cacheFile = $inputFile.".cache";
	    if (file_exists($cacheFile)) {
	            $cache = unserialize($wp_filesystem->get_contents($cacheFile));
	    } else {
	            $cache = $inputFile;
	    }

	    $newCache = $less->cachedCompile($inputFile);

	    if (!is_array($cache) || $newCache["updated"] > $cache["updated"]) {

	            $wp_filesystem->put_contents($cacheFile, serialize($newCache), '');
	            $wp_filesystem->put_contents($outputFile, $newCache['compiled'], '');
	    }
	}
	
endif;

if ( ! function_exists( 'jwstheme_addLessStyle' )):

	function jwstheme_addLessStyle() {
		$preset_color = 'default';
		try {
			$inputFile = JWS_ABS_PATH.'/assets/css/less/general.less';
			$outputFile = JWS_ABS_PATH.'/assets/css/default.css';
			jwstheme_autoCompileLess($inputFile, $outputFile);
	    } catch (Exception $e) {
	        echo 'Caught exception: ', $e->getMessage(), "\n";
	    }
	}

	add_action('wp_enqueue_scripts', 'jwstheme_addLessStyle');

endif;
