<?php
function jws_event_shortcode_render($params, $content = null) {
    extract(shortcode_atts(array(
		'layout' => 'list-slide',
		'items_per_page' => 5,
		'img_size' => '370x370',
		'show_countdown' => 'no',
		'taxonomies' => '',
		'include' => '',
		'el_class' => '',
    ), $params));
    wp_enqueue_script( 'slick');
    wp_enqueue_script( 'countdown');
    ob_start();

    if ($layout == 'single') {
    	$items_per_page = 1;
    }

    if ($layout == 'list-style') {
    	$img_size = '170x212';
    }

    if ($layout == 'grid') {
    	$items_per_page = 3;
    }

    $events = tribe_get_events( array(
		'posts_per_page' => $items_per_page,
	) );

	$arr_cols = array(
		'list-slide' => 'col-md-4',
		'list-style' => 'event-item',
		'grid' => 'col-md-4',
	);

	?>
		<div class="wrap-event_shortcode <?php echo esc_attr($layout); ?>">
			<?php 
			$event = tribe_events_get_event($include);
			$start_date = tribe_get_start_date( $event, true, 'j M Y' );
			$end_date = tribe_get_display_end_date( $event, false, 'j M Y');
			$timestamp = time();
		    if ((strtotime($start_date) < $timestamp) && ($timestamp < strtotime($end_date))) {
		        $count_time = date('Y-m-d', strtotime( $end_date));
		    }

			if ($layout == 'list-style' || $layout == 'list-slide' || $layout == 'grid'): ?>
					<?php
					foreach ( $events as $event ) { ?>
						<?php $post_thumbnail_id = get_post_thumbnail_id( $event->ID ); ?> 
						<div class="<?php echo esc_attr($arr_cols[$layout]); ?>">
						    <div <?php post_class(); ?>>
							
							<a href="<?php echo esc_url( tribe_get_event_link($event->ID) ); ?>">
						        <div class="thumb">
						            <!-- Event Image -->
						            <?php 
						            if (function_exists('wpb_getImageBySize')) {
						            	$img = wpb_getImageBySize( array( 'attach_id' => $post_thumbnail_id, 'thumb_size' => $img_size, 'class' => 'attachment-large wp-post-image' ) );
			                			$img = $img['thumbnail'];
							            echo wp_kses_post($img);
						            }
						            ?>

						            <?php if($layout == 'list-style'): ?>
							            <div class="readmore">
						            		<?php esc_html_e('JOIN NOW','thebrilliance'); ?>
							            </div>
							        <?php endif; ?>
						        </div>
						    </a>


						        <div class="content">
						            <!-- Event Title -->
						            <h3 class="tribe-events-list-event-title">
						                <a class="tribe-event-url" href="<?php echo esc_url( tribe_get_event_link($event->ID) ); ?>" title="<?php echo esc_html($event->post_title); ?>" rel="bookmark"> <?php echo esc_html($event->post_title); ?></a>
						            </h3>
						            <!-- Event Cost -->
						            <div class="tribe-events-event-cost">
						            	<span class="ticket-cost"><?php echo tribe_get_cost( $event->ID, true ); ?></span>
						            </div>
						            <div class="jws-review-totals">

						                <div class="lp-rating">

						                	<?php 
						                	$course_id       = $event->ID;
											$course_rate_res = learn_press_get_course_rate( $course_id, false );
											$course_rate     = $course_rate_res['rated'];
											learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
						                	echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
						                	?>
						                </div>
						            </div>
						            <div class="clearfix"></div>

						           <div class="lp-info">
										<ul>
											<li>
												<span class="jws-value">
													<span class="icon icon-calendar"></span>
													<?php 
													$start_date = tribe_get_start_date( $event, true, 'F d @ g:i a' );
													echo wp_kses_post($start_date); ?>
												</span>
											</li>

												<li>
													<span class="jws-value">
														<span class="icon icon-location"></span>
														<?php echo tribe_get_full_address($event->ID); ?>
													</span>
												</li>
										</ul>
									</div>
						        </div>
						        <div class="clearfix"></div>
						    </div>
						</div>
					<?php 
					}
					?>
					<?php if(!$layout == 'list-slide'): ?>
						<div class="clearfix"></div>
					<?php endif; ?>
			<?php
			elseif($layout == 'single'): 
				

				?>

				<div class="wrap-thumb-event">
				    <?php if ($count_time && $show_countdown =='yes') : ?>
						<div class="event-wrap-countdown">
					    	<div class="jws-countdown-js" data-countdown="<?php echo esc_attr($count_time); ?>">
					    		<?php _e('Countdown Element','thebrilliance'); ?>
				    		</div>
					    </div>
					<?php endif; ?>
						<?php echo tribe_event_featured_image( $event, 'full' ); ?>
				</div>

				<div class="wrap-content-event">
					<h1 class="tribe-events-single-event-title"><a href="<?php echo esc_url( tribe_get_event_link($event->ID) ); ?>"><?php echo get_the_title($event->ID); ?></a></h1>
					<div class="tribe-events-event-cost">
						<span class="ticket-cost"><?php echo tribe_get_cost( $event, true ); ?></span>
					</div>

					<?php echo ic_get_review_totals_html2( $event->ID ); ?>

					<div class="clearfix"></div>
					<div class="lp-info">
						<ul>
							<li>
								<span class="jws-value">
									<span class="icon icon-calendar"></span>
									<?php 
									$start_date = tribe_get_start_date( $event, true, 'F d @ g:i a' );
									echo wp_kses_post($start_date); ?>
								</span>
							</li>

								<li>
									<span class="jws-value">
										<span class="icon icon-location"></span>
										<?php echo tribe_get_full_address($event->ID); ?>
									</span>
								</li>
						</ul>
					</div>
				</div>
			<?php
			endif;
		    ?>
    	</div>
	
    <?php
    $output = ob_get_clean();
    return  $output;
}

if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_event_shortcode', 'jws_event_shortcode_render' );
}