<?php
if( ! function_exists( 'jws_shortcode_info_box' )) {
    function jws_shortcode_info_box($atts, $content) {
        if( ! function_exists( 'wpb_getImageBySize' ) ) return;
        $click = $output = '';
        extract(shortcode_atts( array(
            'thumb_type' => 'image',
            'icon' => '',
            'icon_size' => 50,
            'icon_color' => '#e62739',
            'image' => '',
            'g1' => '#27c7a0',
            'g2' => '#7ed93e',
            'img_size' => 'thumbnail',
            'link' => '#',
            'text_color' => '#000',
            'link_target' => '_self',
            'info_title' => 'More than an education',
            'alignment' => 'al-left',
            'thumb_position' => 'inline-left',
            'el_class' => '',
            'css' => ''
        ), $atts ));
        // class
        $class = array();
        $class[] = 'jws-info-box';
        $class[] = $alignment;
        $class[] = $thumb_position;
        $class[] = $el_class;
        if( function_exists( 'vc_shortcode_custom_css_class' ) ) {
            $class[] = vc_shortcode_custom_css_class( $css );
        }

        // css
        $atts = vc_map_get_attributes( 'jws_info_box', $atts );

        // img
        if ($image != ''): 

            $img = wpb_getImageBySize( array( 'attach_id' => $image, 'thumb_size' => $img_size ));
            $img_url = $img['p_img_large'][0];
        endif;

        // link
        $onclick = 'onclick="window.location.href=\''. esc_url( $link ).'\'" ';
        if( $link_target == '_blank' ):
            $onclick = 'onclick="window.open(\''. esc_url( $link ).'\',\'_blank\')" ';
        endif;

        ob_start(); ?>
        <a href="<?php echo esc_url($link); ?>" class="link-info-box">
            <div class="<?php echo esc_attr(implode(' ', $class)); ?>" <?php if( ! empty( $link ) ) echo wp_kses_post($onclick); ?> style="background-image: linear-gradient(to right,<?php echo esc_attr($g1); ?> 0%,<?php echo esc_attr($g2); ?> 51%,<?php echo esc_attr($g1); ?> 100%); " >
                <div class="info-thumbnail">
                    <?php 
                        if($thumb_type == 'icon'): ?>
                            <span class="icon icon-<?php echo esc_attr($icon); ?>" 
                                style="<?php echo esc_attr($style); ?>"></span>
                    <?php
                        elseif($thumb_type == 'image' && $img): 
                    ?>
                            <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr('image','thebrilliance'); ?>">
                    <?php
                        endif;
                    ?>
                </div>
                
                <div class="content" style="color: <?php echo esc_attr($text_color); ?>">
                    <h3 class="title" style="color: <?php echo esc_attr($text_color); ?>"><?php echo esc_html($info_title); ?></h3>
                    <?php echo do_shortcode( $content ); ?>
                </div>
            </div>
        </a>
        <?php
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }

     if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_info_box', 'jws_shortcode_info_box' );
    }
}
function jws_info_box_css($atts) {
    $style = sprintf('
        font-size: '.str_replace('px','','%1$s').'px;
        color: %2$s;',$atts["icon_size"],$atts["icon_color"]);

    return $style;
}