<?php
function jws_shortcode_instructors( $atts ) {
	$parsed_atts = shortcode_atts( array(
		'title'        => '',
		'item_limit'   => 3,
		'style'		   => 'grid',
		'orderby'      => 'ID',
		'order'        => 'ASC',
	), $atts );
	extract( $parsed_atts );
	$args = array(
		'role'         => 'lp_teacher',
		'role__in'     => array(),
		'role__not_in' => array(),
		'meta_key'     => '',
		'meta_value'   => '',
		'meta_compare' => '',
		'meta_query'   => array(),
		'date_query'   => array(),        
		'include'      => array(),
		'exclude'      => array(),
		'orderby'      => $orderby,
		'order'        => $order,
		'offset'       => '',
		'search'       => '',
		'number'       => $item_limit,
		'count_total'  => false,
		'fields'       => 'all',
		'who'          => '',
	); 
	wp_enqueue_script( 'slick');
	$users = get_users( $args ); 
	ob_start(); 

	?>
	<div class="wrap-instructors jws-<?php echo esc_attr($style); ?>">
		<div class="row">
			<ul class="col-md-offset-1 col-md-offset-right-1" >
			<?php
			foreach ($users as $user) {
				$link = learn_press_user_profile_link(  $user->ID );

				echo '<li class="col-md-4 instructor-item">';

					echo '<a href="'.$link.'">';
						echo '<div class="instructor-thumb">';
						echo get_avatar( $user->ID, 200);
						echo '</div>';
					echo '</a>';

					if(!empty(get_the_author_meta('short_name',$user->ID))) {
                    }
			            printf( '<a href="%2$s"><div class="short-name">%1$s</div></a>',get_the_author_meta('short_name',$user->ID), esc_url($link)); 

					echo '<a href="'.$link.'"><div class="display-name">'.$user->display_name.'</div></a>';

					if(!empty(get_the_author_meta('instructor_type',$user->ID)))
			            printf( '<div class="instructor-type">%1$s</div>',get_the_author_meta('instructor_type',$user->ID)); 


			        echo '<div class="wrap-socials">';
						if(!empty(get_the_author_meta('facebook',$user->ID)))
				            printf( '<a href="%1$s"><i class="fa fa-facebook"></i></a>',esc_url(get_the_author_meta('facebook',$user->ID))); 

				        if(!empty(get_the_author_meta('twitter',$user->ID)))
				            printf( '<a href="%1$s"><i class="fa fa-twitter"></i></a>',esc_url(get_the_author_meta('twitter',$user->ID)));

				         if(!empty(get_the_author_meta('instagram',$user->ID)))
				            printf( '<a href="%1$s"><i class="fa fa-instagram"></i></a>',esc_url(get_the_author_meta('instagram',$user->ID)));

				        if(!empty(get_the_author_meta('gplus',$user->ID)))
				            printf( '<a href="%1$s"><i class="fa fa-google-plus"></i></a>',esc_url(get_the_author_meta('gplus',$user->ID)));

				        if(!empty(get_the_author_meta('linkedin',$user->ID)))
				            printf( '<a href="%1$s"><i class="fa fa-linkedin"></i></a>',esc_url(get_the_author_meta('linkedin',$user->ID)));
			        echo '</div>';
				        

				echo '</li>';
			} 
			?>

			</ul>
		</div>
	</div>


	<?php
	$output = ob_get_contents();
    ob_end_clean();
    return $output; 
}


  if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_instructors', 'jws_shortcode_instructors' );
    }