<?php
function jws_curriculum($atts) {
    $atts=shortcode_atts(array(
        'include' => 149,
        'el_class' => ''
    ), $atts);
	extract($atts);
    ob_start();
    	$course = LP_Course::get_course($include);
    	?>

        <div id="lp-single-course" class="lp-single-course">
            <div class="course-curriculum" id="learn-press-course-curriculum">
                <?php
                do_action( 'learn_press_before_single_course_curriculum' );
                do_action( 'learn-press/before-single-course-curriculum' );
                ?>
                <?php if ( $curriculum = $course->get_curriculum() ) { ?>
                    <ul class="curriculum-sections">
                        <?php foreach ( $curriculum as $section ) { ?>
                            <li<?php $section->main_class(); ?> id="section-<?php echo esc_attr($section->get_slug()); ?>"
                                            data-id="<?php echo esc_attr($section->get_slug()); ?>"
                                            data-section-id="<?php echo esc_attr($section->get_id()); ?>">
                                <?php 
                                do_action( 'learn_press_curriculum_section_summary', $section );
                                $user        = learn_press_get_current_user();
                                $course      = learn_press_get_the_course();
                                $user_course = $user->get_course_data( get_the_ID() );
                                if ( ! isset( $section ) ) {
                                    return;
                                }
                                $title = $section->get_title();
                                ?>
                                <div class="section-header">
                                    <div class="section-left">
                                        <i class="fa fa-angle-down" aria-hidden="true"></i>
                                        <?php if ( $title ) { ?>
                                            <h5 class="section-title"><?php echo wp_kses_post($title); ?></h5>
                                        <?php } ?>

                                        <div class="lp-lecutre">
                                            <?php echo wp_kses_post($section->count_items().__(' Lecutre','thebrilliance')); ?>
                                        </div>

                                        <?php if ( $description = $section->get_description() ) { ?>
                                            <p class="section-desc"><?php echo wp_kses_post($description); ?></p>
                                        <?php } ?>
                                    </div>
                                    <?php if ( $user->has_enrolled_course( $section->get_course_id() ) ) { ?>
                                        <?php $percent = $user_course->get_percent_completed_items( '', $section->get_id() ); ?>
                                        <div class="section-meta">
                                            <div class="learn-press-progress section-progress" title="<?php echo intval( $percent ); ?>%">
                                                <div class="progress-bg">
                                                    <div class="progress-active primary-background-color" style="left: <?php echo esc_attr($percent); ?>%;"></div>
                                                </div>
                                            </div>
                                            <span class="step"><?php printf(esc_html__( '%d/%d', 'thebrilliance' ), $user_course->get_completed_items( '', false, $section->get_id() ), $section->count_items( '', false ) ); ?></span>
                                            <span class="collapse"></span>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php
                            if ( ! isset( $section ) ) {
                                return;
                            }
                            $user = LP_Global::user();
                            
                            if ( $items = $section->get_items() ) {
                            ?>
                                <ul class="section-content">
                                    <?php foreach ( $items as $item ) { 

                                        


                                    if ( empty( $GLOBALS['get_class'] ) ) {
                                        $GLOBALS['get_class'] = 0;
                                    }

                                    $user_id = $user_id || get_current_user_id();

                                    $t = microtime( true );

                                    if ( false === ( $classes = LP_Object_Cache::get( 'item-' . $user_id . '-' . $item->get_id(), 'learn-press/post-classes' ) ) ) {

                                        $curd      = new LP_User_Item_CURD();
                                        $all_items = $curd->parse_items_classes( $include, $user_id, $more );
                                        $classes = ! empty( $all_items[ $item->get_id() ] ) ? $all_items[ $item->get_id() ] : $defaults = array(
                                            'course-item',
                                            'course-item-lp_lesson',
                                            'course-item-' . $item->get_id()
                                        );
                                    }
                                    $GLOBALS['get_class'] += microtime( true ) - $t;


                                    $class =  apply_filters( 'learn-press/course-item-class-cached', $classes, 'lp_lesson', $item->get_id(), $include );
                                    ?>


                                        <li class="<?php echo join( ' ', $class ); ?>">
                                            <?php
                                            if ( $item->is_visible() ) {
                                                do_action( 'learn-press/begin-section-loop-item', $item );
                                                if ( $user->can_view_item( $item->get_id(), $include ) ) {
                                                    ?>
                                                    <a class="section-item-link" href="<?php echo esc_url($item->get_permalink()); ?>">

                                                        <?php  
                                                        switch (get_post_format($item->get_id())) {
                                                            case 'video':
                                                                $icon = '<i class="fa fa-play-circle" aria-hidden="true"></i>';
                                                                break;
                                                            
                                                            default:
                                                                $icon = '<i class="fa fa-file" aria-hidden="true"></i>';
                                                                break;
                                                        }
                                                        echo wp_kses_post($icon);

                                                        learn_press_get_template( 'single-course/section/content-item.php', array(
                                                            'item'    => $item,
                                                            'section' => $section
                                                        ) ); 

                                                        ?>
                                                    </a>
                                                <?php } else { ?>
                                                    <div class="section-item-link">
                                                        <?php learn_press_get_template( 'single-course/section/content-item.php', array(
                                                            'item'    => $item,
                                                            'section' => $section
                                                        ) ); ?>
                                                    </div>
                                                <?php } ?>
                                                <?php
                                                do_action( 'learn-press/end-section-loop-item', $item );
                                            }
                                            ?>
                                        </li>
                                    <?php } ?>
                                </ul>
                            <?php 
                            } else { 
                                learn_press_display_message(esc_html__( 'No items in this section', 'thebrilliance' ) ); 
                            } 
                            ?>
                            </li>
                        <?php
                        } 
                        ?>
                    </ul>
                <?php }
                do_action( 'learn-press/after-single-course-curriculum' );
                do_action( 'learn_press_after_single_course_curriculum' );
                ?>
            </div>
        </div>

        <?php
    return ob_get_clean();
}

 if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_curriculum', 'jws_curriculum' );
    }
