<?php
function jws_page_title_bar_func($atts) {
    extract(shortcode_atts(array(
        'before'        => '',
		'title'         => '',
        'after'         => '',
        'image_sign'    => '',
        'alignment'     => 'al-center',
        'el_class'      => ''
    ), $atts));

    $class = array();
	$class[] = 'jws-page-title';
    $class[] = $alignment;
	$class[] = $el_class;
    ob_start();
    ?>
		<div class="<?php echo esc_attr(implode(' ', $class)); ?>">
            
            <?php if ($before) : ?>
                <div class="before-title">
                    <?php echo wp_kses_post($before); ?>
                </div>
            <?php endif; ?>

			<h2 class="title"><?php if( $title ) { echo esc_html( $title ); } else { echo jws_theme_page_title(); } ?></h2>

            <?php if ($after) : ?>
                <div class="after-title">
                    <?php 
                    echo '<span>'.wp_kses_post($after).'</span>';
                    echo wp_get_attachment_image( $image_sign, 'full' ); 
                    ?>
                </div>
            <?php endif; ?>

		</div>
		
    <?php
    return ob_get_clean();
}


 if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_page_title', 'jws_page_title_bar_func' );
    }