<?php
if( ! function_exists( 'jws_shortcode_service_box' )) {
    function jws_shortcode_service_box($atts, $content) {
        if( ! function_exists( 'wpb_getImageBySize' ) ) return;
        $click = $output = '';
        extract(shortcode_atts( array(
            'thumb' => '',
            'title' => '',
            'background' => '',
            'text_link' => '',
            'link' => '#',
            'el_class' => '',
            'css' => ''
        ), $atts ));
        $class = array();
        $class[] = 'jws-service-box';
        $class[] = $el_class;
        if( function_exists( 'vc_shortcode_custom_css_class' ) ) {
            $class[] = vc_shortcode_custom_css_class( $css );
        }
        // css
        $atts = vc_map_get_attributes( 'jws_service_box', $atts );
        // img

        if ($background != ''): 
            $img_url = wp_get_attachment_image_url($background, 'full');
        endif;
        ob_start(); 
        ?>
            <div class="<?php echo esc_attr(implode(' ', $class)); ?>" >

                <div class="thumb" style="background-image: url( <?php echo esc_url($img_url); ?> );">
                    <div class="wrap-img">
                        <?php echo wp_get_attachment_image( $thumb, 'full' );  ?>
                    </div>
                    
                    <a class="readmore" href="<?php echo esc_url($link); ?>"><?php echo esc_html($text_link); ?></a>
                </div>

                <h3 class="title"><?php echo esc_html($title); ?></h3>
                <div class="content">
                    <?php echo wp_kses_post( $content ); ?>
                </div>
            </div>

        <?php
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }

       if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_service_box', 'jws_shortcode_service_box' );
    }
}
