<?php
if( ! function_exists( 'jws_shortcode_testimonials' ) ) {
    function jws_shortcode_testimonials($atts = array(), $content = null) {
        $posts_query = $el_class = $args = $my_query = $speed = '';
        $slides_per_view = $wrap = $scroll_per_page = $title_out = '';
        $autoplay = $hide_dots = $hide_prev_next_buttons = $output = '';
        $parsed_atts = shortcode_atts( array(
            'layout' => 'slider', // grid slider
            'style' => 'standard', // standard boxed
            'slides_per_view' => 3,
            'hide_prev_next_buttons' => 'no',
            'hide_dots' => 'yes',
            'nav_position' => 'lar',
            'name' => '',
            'bg_img' => '',
            'text_color' => '#000',
            'el_class' => ''
        ) , $atts );

        extract( $parsed_atts );
        wp_enqueue_script( 'slick');
        $class = array(); 
        $class[] = 'testimonials';

        $class[] = $el_class;
        $class[] = ' testimonials-' . $layout;
        $class[] = ' testimon-style-' . $style;
        $class[] = ( $layout == 'slider' ) ? ' has-slider' : ' testimon-columns-' . $slides_per_view;
        $carousel_id = 'carousel-' . rand( 1000, 10000);

        ob_start(); ?>
            <div id="<?php echo esc_attr($carousel_id); ?>" class="testimonials-wrapper nav-<?php echo esc_attr($nav_position); ?>" style="background-image: url(<?php echo wp_get_attachment_url($bg_img,'full'); ?>);background-size: contain;background-repeat: no-repeat;" data-cols="<?php echo esc_attr($slides_per_view); ?>" data-dots="<?php echo esc_attr($hide_dots); ?>" data-nav="<?php echo esc_attr($hide_prev_next_buttons); ?>">
                <div class="<?php echo esc_attr(implode(' ', $class)); ?>" style="color: <?php echo esc_attr($text_color); ?>">
                    <?php echo do_shortcode( $content ); ?>
                </div>
            </div>
            <?php 
                if( $layout == 'slider' ) {
                    $parsed_atts['carousel_id'] = $carousel_id;
                }
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }

      if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jwstestimonials', 'jws_shortcode_testimonials' );
    }
}

if( ! function_exists( 'jws_shortcode_testimonial' ) ) {
    function jws_shortcode_testimonial($atts, $content) {
        if( ! function_exists( 'wpb_getImageBySize' ) ) return;
        $output = $class = '';
        extract(shortcode_atts( array(
            'item_style' => 'default',
            'quote_image' => '',
            'image' => '',
            'img_size' => 'thumbnail',
            'name' => 'Helene K',
            'title' => 'Manage, New York',
            'el_class' => ''
        ), $atts ));

        $img_id = preg_replace( '/[^\d]/', '', $image );
        $img = wpb_getImageBySize( array( 'attach_id' => $img_id, 'thumb_size' => $img_size, 'class' => 'testimonial-avatar-image' ) );

        $class .= ' '.$el_class.' '.$item_style;

        ob_start(); ?>
            <?php if($item_style == 'default'): ?>
            <div class="testimonial<?php echo esc_attr( $class ); ?>" >
                <div class="testimonial-inner">
                    <?php if ( $img['thumbnail'] != ''): ?>
                        <div class="testimonial-avatar">
                            <?php echo wp_kses_post($img['thumbnail']); ?>
                        </div>
                    <?php endif ?>
                    <div class="testimonial-content">
                        <?php echo do_shortcode( $content ); ?>
                    </div>
                </div>

                <div class="test-info">
                    <span class="quote-sign"></span>

                    <div class="wrap-name">
                        <div class="name"><?php echo esc_html( $name ); ?></div>
                        <span class="subtitle"><?php echo esc_html( $title ); ?></span>
                    </div>
                    

                </div>
            </div>
            <?php elseif($item_style == 'style-1'): ?>
                <div class="testimonial<?php echo esc_attr( $class ); ?> col-md-4" >
                    <div class="testimonial-inner">
                        <?php if ( $img['thumbnail'] != ''): ?>
                            <div class="testimonial-avatar">
                                <?php echo wp_kses_post($img['thumbnail']); ?>
                            </div>
                        <?php endif; ?>

                        <div class="test-info">
                            <h3 class="name"><?php echo esc_html( $name ); ?></h3>
                            <span class="subtitle"><?php echo esc_html( $title ); ?></span>
                            
                        </div>
                        <div class="testimonial-content"><?php echo do_shortcode( $content ); ?></div>

                        <?php if ($quote_image != '') : ?>
                        
                            <div class="quote_image">
                                <img src="<?php echo wp_get_attachment_image_url( $quote_image, 'full' ); ?>" alt="<?php echo esc_attr('image','thebrilliance'); ?>">
                            </div>

                        <?php endif; ?>
                    </div>

                </div>
            <?php elseif($item_style == 'style-2'): ?>


                <div class="testimonial<?php echo esc_attr( $class ); ?>" >
                    
                    <div class="testimonial-inner">
                        <span class="quote-sign"></span>
                        <div class="testimonial-content">
                            <?php echo do_shortcode( $content ); ?>
                        </div>
                    </div>

                    <div class="test-info">
                        <?php if ( $img['thumbnail'] != ''): ?>
                            <div class="testimonial-avatar">
                                <?php echo wp_kses_post($img['thumbnail']); ?>
                            </div>
                        <?php endif; ?>
                        <div class="wrap-name">
                            <h3 class="name"><?php echo esc_html( $name ); ?></h3>
                            <span class="subtitle"><?php echo esc_html( $title ); ?></span>
                        </div>
                    </div>

                </div>

            <?php endif; ?>
        <?php
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }
  
     if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jwstestimonial', 'jws_shortcode_testimonial' );
    }
}