<?php
// Images gallery
vc_map(array(
    'name' =>esc_html__( 'Images gallery', 'thebrilliance' ),
    'base' => 'jws_gallery',
    'class' => '',
    'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
    'description' =>esc_html__( 'Images grid/carousel', 'thebrilliance' ),
    'params' => array(

        array(
            'type' => 'attach_images',
            'heading' =>esc_html__( 'Images', 'thebrilliance' ),
            'param_name' => 'images',
            'value' => '',
            'description' =>esc_html__( 'Select images from media library.', 'thebrilliance' )
        ),
        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Image per Page', 'thebrilliance' ),
            'param_name' => 'img_per_page',
            'description' =>esc_html__( 'Input number of image per page', 'thebrilliance' ),
            'value' => 6,
        ),
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'View', 'thebrilliance' ),
            'param_name' => 'view',
            'save_always' => true,
            'value' => array(
                'Default grid' => 'grid',
            )
        ),
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Grid Columns', 'thebrilliance' ),
            'param_name' => 'columns',
            'save_always' => true,
            'description' =>esc_html__( 'How much columns grid', 'thebrilliance' ),
            'value' => array(
                '2 column' => 2,
                '3 columns' => 3,
                '4 columns' => 4,
            ),
            'dependency' => array(
                'element' => 'view',
                'value' => 'grid',
            ),
            'std' => 6,
        ),
        array(
            'type' => 'dropdown',
            'heading' =>esc_html__( 'Layout Masonry', 'thebrilliance' ),
            'param_name' => 'layout_msr',
            'save_always' => true,
            'description' =>esc_html__( '', 'thebrilliance' ),
            'value' => array(
                'Layout 1' => '2 1 1 1 1 2 1 2 1',
                'Layout 2' => '3 1 1 1 1 1 1 2',
                'Custom Layout' => 'custom-layout',
            ),
            'dependency' => array(
                'element' => 'view',
                'value' => 'masonry',
            ),
            'std' => 'layout-1',
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Custom Layout Masonry', 'thebrilliance' ),
            'param_name' => 'custom_layout_msr',
            'description' =>esc_html__( 'Input custom masonry (1 = Square small, 2 = Rectangle, 3 = Square large)', 'thebrilliance' ),
            'value' => '3 1 1 1 1 1 1 2 1 1',
            'dependency' => array(
                'element' => 'layout_msr',
                'value' => 'custom-layout',
            ),
        ),
        array(
            'type' => 'checkbox',
            'heading' =>esc_html__( 'Enable No-padding', 'thebrilliance' ),
            'save_always' => true,
            'param_name' => 'no_padding',
            'value' => array(esc_html__( 'Yes, please', 'thebrilliance' ) => 'yes' ),
            'default' => ''
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Image size', 'thebrilliance' ),
            'param_name' => 'img_size',
            'description' =>esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
            'value' => '',
            'dependency' => array(
                'element' => 'view',
                'value' => 'grid',
            ),
        ),

        array(
            'type' => 'textfield',
            'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
            'param_name' => 'el_class',
            'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
        )
    )
));
