<?php
$order_by_values = array(
	'',
	__( 'Date', 'thebrilliance' ) => 'date',
	__( 'ID', 'thebrilliance' ) => 'ID',
	__( 'Title', 'thebrilliance' ) => 'title',
	__( 'Modified', 'thebrilliance' ) => 'modified',
);
$order_way_values = array(
	'',
	__( 'Descending', 'thebrilliance' ) => 'DESC',
	__( 'Ascending', 'thebrilliance' ) => 'ASC',
);

vc_map( array(
	'name' =>esc_html__( 'Portfolio', 'thebrilliance' ),
	'base' => 'jws_portfolio',
	'category' =>esc_html__( 'thebrilliance', 'thebrilliance' ),
	'description' =>esc_html__( 'Showcase your projects or gallery', 'thebrilliance' ),
	'params' => array(
        array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Layout', 'thebrilliance' ),
			'param_name' => 'layout',
			'value' => array(
                'Grid' => 'grid',
			)
		),

		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Columns', 'thebrilliance' ),
			'param_name' => 'columns',
			'value' => array(
                 2,
                 3,
                 4,
			),
            'dependency' => array(
				'element' => 'layout',
				'value' => array( 'grid' ),
			),
		),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Number of posts per page', 'thebrilliance' ),
			'default' => 6,
			'param_name' => 'posts_per_page'
		),
		array(
			'type' => 'checkbox',
			'heading' =>esc_html__( 'Show categories filters', 'thebrilliance' ),
			'param_name' => 'filters',
			'value' => array(esc_html__( 'Yes, please', 'thebrilliance' ) => 1 )
		),
        
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Order by', 'thebrilliance' ),
			'param_name' => 'orderby',
			'value' => $order_by_values,
			'save_always' => true,
			'description' => sprintf(esc_html__( 'Select how to sort retrieved projects. More at %s.', 'thebrilliance' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
		),
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Sort order', 'thebrilliance' ),
			'param_name' => 'order',
			'value' => $order_way_values,
			'save_always' => true,
			'description' => sprintf(esc_html__( 'Designates the ascending or descending order. More at %s.', 'thebrilliance' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
		),
		array(
			'type' => 'dropdown',
			'heading' =>esc_html__( 'Pagination', 'thebrilliance' ),
			'param_name' => 'pagination',
			'value' => array(
                '' => '',
                '"Load more" button' => 'more-btn',
			),
		),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Image Size', 'thebrilliance' ),
			'param_name' => 'img_size',
		),
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Extra class name', 'thebrilliance' ),
			'param_name' => 'el_class',
			'description' =>esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'thebrilliance' )
		),
	),
));