<?php
function jwsthemes_video_box_func($atts, $content = "") {

    extract(shortcode_atts(array(
        'background' => '',
        'button_image' => '',
        'text_color' => '#000',
        'link_video' => '',
        'title' => 'WATCH VIDEO',
        'el_class' => '',
    ), $atts));
	$class = 'jws-about-video';
    $class .= ' '.$el_class;

    ob_start();
    wp_enqueue_script( 'magnific-popup');; 
    ?>
    <div class="<?php echo esc_attr($class); ?>">
        <div class="video-wrap">
            <h3 class="title" style="color: <?php echo esc_attr($text_color); ?>"><?php echo wp_kses_post($title); ?></h3>
            <?php echo wp_get_attachment_image( $background, 'full' ); ?>
            <?php if ($link_video != ''): ?>
                <a class="btn-play" href="<?php echo esc_url($link_video); ?>" >
                    <div class="wrap-image-btn"><span class="icon-play3"></span></div>
                    
                </a>
            <?php endif; ?>

            <div class="content" style="color: <?php echo esc_attr($text_color); ?>">
                <?php echo wp_kses_post($content); ?>
            </div>
        </div>
    </div>

    <?php

    return ob_get_clean();
}

   if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'video_box', 'jwsthemes_video_box_func' );
    }