<?php
	class Jws_Widget_Mini_Cart extends WC_Widget {
		/**
			* Constructor
		*/
		function __construct() {
			$this->widget_cssclass    = 'woocommerce widget_mini_btn';
			$this->widget_description =esc_html__( "Display the user's Cart in the sidebar.", 'thebrilliance' );
			$this->widget_id          = 'widget_mini_btn';
			$this->widget_name        =esc_html__( 'Mini Cart', 'thebrilliance' );
			$this->settings           = array(
		
			'hide_if_empty' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' =>esc_html__( 'Hide Search', 'thebrilliance' )
			),
            'hide_if_empty2' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' =>esc_html__( 'Hide Cart', 'thebrilliance' )
			),
			'hide_if_empty3' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' =>esc_html__( 'Hide Account', 'thebrilliance' )
			),
			'hide_if_empty4' => array(
				'type'  => 'checkbox',
				'std'   => 0,
				'label' =>esc_html__( 'Hide Wishlist', 'thebrilliance' )
			)
			);
			parent::__construct();
		}
		/**
			* widget function.
			*
			* @see WP_Widget
			*
			* @param array $args
			* @param array $instance
		*/
		function widget( $args, $instance ) {
			$hide_if_empty = empty( $instance['hide_if_empty'] ) ? 0 : 1;
            $hide_if_empty2 = empty( $instance['hide_if_empty2'] ) ? 0 : 1;
            $hide_if_empty3 = empty( $instance['hide_if_empty3'] ) ? 0 : 1;
            $hide_if_empty4 = empty( $instance['hide_if_empty4'] ) ? 0 : 1;
			$this->widget_start( $args, $instance );
            ?> 
			
			<?php if ( class_exists( 'WooCommerce' ) ) : ?>
	            <div class="mini-btn cart-btn <?php  if($hide_if_empty2) {echo esc_attr('hidden');} ?>">
	                <div class="wrap-cart-btn">
	                    <div class="cart-btn"><span class="icon-commerce"><span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span></span></div>
	                </div>
	            </div>

	            <?php 
	            if (class_exists('LP_Profile')):
		            $profile = LP_Profile::instance(); 
		            $link_dashboard  = $profile->get_tab_link( 'dashboard', true );
	            ?>

					<div class="mini-btn wishlist-btn <?php  if($hide_if_empty4) { echo esc_attr('hidden');} ?>">
		                <div class="wrap-wishlist-btn">
		                	<a href="<?php  echo get_permalink(get_option('yith_wcwl_wishlist_page_id')); ?>">
		                    	<span class="icon-heart2"></span>
		                    </a>
		                </div>
		            </div>
			 
		            <div class="mini-btn account-btn <?php  if($hide_if_empty3) { echo esc_attr('hidden');} ?>">
		                <div class="wrap-account-btn">
		                	<a class="<?php if ( is_user_logged_in() ) { echo esc_attr("jws_logged");}else {echo esc_attr("jws_login");} ?>" href="<?php echo esc_url(home_url('/lp-profile')); ?>">
		                		<span class="icon-user-1"></span>
		                	</a>
		                    
		                </div>
                        <?php 
                            if ( is_user_logged_in() ) { 
                                global $current_user;
                                ?>
                                <div class="jws_user_info_wap">
                                <div class="jws_user_info">
                                    <?php  echo get_avatar( get_the_author_meta( get_the_ID() ), 96 ); ?>
                                    <h1 class="jws_user_name">
                                        <a href="<?php echo esc_url(home_url('/lp-profile')); ?>"><?php echo esc_html($current_user->user_login); ?></a>
                                    </h1>
                                    <a class="learn_out" href="<?php echo wp_logout_url(get_permalink()); ?>"><?php echo esc_html__('Logout','thebrilliance'); ?></a>
                                </div>
                                </div>
                                
                            <?php }
                        ?>
		            </div>
	            <?php endif; ?>

	        <?php endif; ?>

            <div class="mini-btn search-btn <?php  if($hide_if_empty) { echo esc_attr('hidden');} ?>">
                <div class="wrap-search-btn">
                    <span class="icon-search32"></span>
                </div>
            </div>
            
            <div class="clearfix"></div>

            <?php 
			$this->widget_end( $args );
		}
	}
add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_icon_add_to_cart_fragment');
	if(!function_exists('woocommerce_icon_add_to_cart_fragment')){
		function woocommerce_icon_add_to_cart_fragment( $fragments ) {
			global $woocommerce;
			ob_start();
		?>
		<span class="cart_total"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span>
		<?php
			$fragments['span.cart_total'] = ob_get_clean();
			return $fragments;
		}
	}
	/**
		* Class Jws_Widget_Mini_Cart
	*/
	function register_bt_widget_mini_cart() {
        if(function_exists('insert_widgets')){ 
       	    insert_widgets('Jws_Widget_Mini_Cart'); 
        }
	}
add_action('widgets_init', 'register_bt_widget_mini_cart');