<?php 
if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

/* Define THEME */
if (!defined('JWS_URI_PATH')) define('JWS_URI_PATH', get_template_directory_uri());
if (!defined('JWS_ABS_PATH')) define('JWS_ABS_PATH', get_template_directory());
if (!defined('JWS_URI_PATH_FR')) define('JWS_URI_PATH_FR', JWS_URI_PATH.'/framework-theme');
if (!defined('JWS_ABS_PATH_FR')) define('JWS_ABS_PATH_FR', JWS_ABS_PATH.'/framework-theme');

/**
 * Theme Includes
 */
require_once JWS_ABS_PATH_FR.'/init.php';
require_once JWS_ABS_PATH_FR.'/css_inline.php';

/* Add Stylesheet And Script */
if (!function_exists('jws_theme_enqueue_style')) {
    function jws_theme_enqueue_style() {
        // Google font
        wp_enqueue_style( 'jws-font-google', jws_theme_font_url() );
        /* Start Css jws */  
        wp_enqueue_style( 'fr-google-fonts', 'http://fonts.googleapis.com/css?family=Poppins:300,300i,400,400i,500,500i,600,600i,700,700i', false ); 
        wp_enqueue_style( 'bootstrap', JWS_URI_PATH .'/assets/css/bootstrap.min.css' );
        wp_enqueue_style( 'font-awesome', JWS_URI_PATH .'/assets/css/font-awesome.min.css' );
        wp_enqueue_style( 'jws-preset', JWS_URI_PATH.'/assets/css/default.css', false );
        wp_enqueue_style( 'icomoon', JWS_URI_PATH .'/assets/css/icomoon.css' );
        wp_enqueue_style( 'magnific-popup', JWS_URI_PATH .'/assets/css/magnific-popup.css' );
        wp_enqueue_style( 'jws-webslidemenu', JWS_URI_PATH .'/assets/css/webslidemenu.css' );
        wp_enqueue_style( 'photoswipe', JWS_URI_PATH .'/assets/css/photoswipe.css' );
        wp_enqueue_style( 'jws-default-skin', JWS_URI_PATH .'/assets/css/default-skin.min.css' );
        wp_enqueue_style( 'fullpage', JWS_URI_PATH .'/assets/css/fullpage.min.css' );
        wp_enqueue_style( 'animation', JWS_URI_PATH .'/assets/css/animate.css' );
        wp_enqueue_style( 'slick', JWS_URI_PATH .'/assets/css/slick.css' );
        wp_enqueue_style( 'jws-inline-style', JWS_URI_PATH .'/assets/css/jws-inline-style.css');
        wp_add_inline_style( 'jws-inline-style', jws_theme_custom_css() );
       
        wp_register_script( 'maps-apiv3', JWS_URI_PATH.'/assets/js/maps.js', array('jquery'), '', true  );
        wp_register_script( 'countdown', JWS_URI_PATH.'/assets/js/jquery.countdown.js', array('jquery'), '', true  );
        wp_register_script( 'waypoints', JWS_URI_PATH.'/assets/js/waypoints.min.js', array('jquery'), '', true  );
        wp_register_script( 'magnific-popup', JWS_URI_PATH.'/assets/js/jquery.magnific-popup.min.js', array('jquery'), '', true  );
        wp_register_script( 'photoswipe-ui', JWS_URI_PATH.'/assets/js/photoswipe-ui-default.js', array('jquery'), '', true  );
        wp_register_script( 'photoswipe', JWS_URI_PATH.'/assets/js/photoswipe.min.js', array('jquery'), '', true  );
        wp_enqueue_script( 'imagesloaded');
        wp_enqueue_script( 'matchHeight', JWS_URI_PATH.'/assets/js/jquery.matchHeight-min.js', array('jquery'), '', true  );
        wp_enqueue_script( 'autocomplete', JWS_URI_PATH.'/assets/js/jquery.autocomplete.js', array('jquery'), '', true  );
        wp_enqueue_script( 'jws-webslidemenu', JWS_URI_PATH.'/assets/js/webslidemenu.js', array('jquery'), '', true  );
        wp_register_script( 'isotope', JWS_URI_PATH.'/assets/js/isotope.js', array('jquery'), '', true  );
        wp_register_script( 'slick', JWS_URI_PATH.'/assets/js/slick.min.js', array('jquery'), '', true  );
        wp_enqueue_script( 'header-sticky', JWS_URI_PATH. '/assets/js/header_sticky.js', array(), '3.3.7', true );
        wp_enqueue_script( 'sticky-sidebar', JWS_URI_PATH. '/assets/js/stick_content.js', array(), '3.3.7', true );
        wp_enqueue_script( 'jws-main-script', JWS_URI_PATH.'/assets/js/jws_main_script.js', array('jquery'), '', true  );
        
        /*Woocomerce*/
        wp_enqueue_script( 'jws-cartparent', JWS_URI_PATH.'/assets/js/ajax_mn_parent.js', array('jquery'), '', true  );

        wp_localize_script( 'jquery', 'MS_Ajax', array(
            'ajaxurl'       => admin_url( 'admin-ajax.php' ),
            'nextNonce'     => wp_create_nonce( 'myajax-next-nonce' ))
        );
        if( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1) ) {
            wp_enqueue_script( 'comment-reply', 'wp-includes/js/comment-reply', array(), false, true );
        }
    }
    add_action( 'wp_enqueue_scripts', 'jws_theme_enqueue_style' );
}
if ( ! function_exists( 'jws_theme_admin_css' ) ) :
	function jws_theme_admin_css() {
        wp_enqueue_style( 'admin-google-fonts', 'http://fonts.googleapis.com/css?family=Poppins:300,300i,400,400i,500,500i,600,600i,700,700i', false ); ;
	}
add_action( 'admin_enqueue_scripts', 'jws_theme_admin_css' );
endif;
if ( ! function_exists( 'jws_theme_set_posts_per_page_for_event_cpt' ) ) {

    function jws_theme_set_posts_per_page_for_event_cpt( $query ) {
        if ( !is_admin() && $query->is_main_query() && is_post_type_archive( 'event' ) ) {
        $query->set( 'posts_per_page', '6' );
        }
    }
}

add_action( 'pre_get_posts', 'jws_theme_set_posts_per_page_for_event_cpt' );

if ( ! function_exists( 'jws_theme_add_categories_to_attachments' ) ) {

    function jws_theme_add_categories_to_attachments() {
        register_taxonomy_for_object_type( 'category', 'attachment' );
    }

}

add_action( 'init' , 'jws_theme_add_categories_to_attachments' );

/* Widgets */
require_once JWS_ABS_PATH_FR.'/widgets/abstract-widget.php';
require_once JWS_ABS_PATH_FR.'/widgets/widgets.php';

/* Woo commerce function */
if (class_exists('Woocommerce')) {
    require_once JWS_ABS_PATH . '/woocommerce/wc-template-function.php';
    require_once JWS_ABS_PATH . '/woocommerce/wc-template-hooks.php';
}

/* Vc extra shorcodes */
if (function_exists("vc_map")){
    foreach (glob(JWS_ABS_PATH_FR."/shortcodes/vc_element_shortcodes/*.php") as $filepath)
    {
        require_once $filepath;
    }
}
require_once  JWS_ABS_PATH . '/acf_init/init.php';
require_once JWS_ABS_PATH_FR . '/shortcodes/shortcodes.php';
require_once get_template_directory() . '/TGM-Plugin-Activation/class-tgm-plugin-activation.php';
function _brilliance_filter_fw_ext_backups_demos($demos)
	{
		$demos_array = array(
			'brilliance' => array(
				'title' => esc_html__('The Brilliance Demo', 'thebrilliance'),
				'screenshot' => 'http://jwsuperthemes.com/import_demo/brilliance/screenshot.png',
				'preview_link' => 'http://brilliance.jwsthemeswp.com',
			),
		);
        $download_url = 'http://jwsuperthemes.com/import_demo/brilliance/download-script/';
		foreach ($demos_array as $id => $data) {
			$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
				'url' => $download_url,
				'file_id' => $id,
			));
			$demo->set_title($data['title']);
			$demo->set_screenshot($data['screenshot']);
			$demo->set_preview_link($data['preview_link']);
			$demos[$demo->get_id()] = $demo;
			unset($demo);
		}
		return $demos;
	}
	add_filter('fw:ext:backups-demo:demos', '_brilliance_filter_fw_ext_backups_demos');
add_action( 'tgmpa_register', 'jws_theme_action_theme_register_required_plugins' );
if ( ! function_exists( 'jws_theme_action_theme_register_required_plugins' ) ) {
    /** @internal */
    function jws_theme_action_theme_register_required_plugins() {
        $root = 'http://jwsuperthemes.com/plugins/thebrilliance/';
        tgmpa( array(
            array(
                'name'      => 'Unyson',
                'slug'      => 'unyson',
                'required'  => true,
            ),
            array(
                'name'       => 'WPBakery Page Builder',
                'slug'       => 'js_composer',
                'source'     => $root .'js_composer.zip',
                'required'   => true,
            ),   
            array(
                'name'       => 'Go Pricing',
                'slug'       => 'go_pricing',
                'source'     => $root .'go_pricing.zip',
                'required'   => true,
            ), 
            array(
                'name'      => 'The Brilliance Core',
                'slug'      => 'thebrilliance_core',
                'source'    => $root .'thebrilliance_core.zip',
                'required'  => true,
            ),
            array(
                'name'      => 'LearnPress Woocommerce',
                'slug'      => 'learnpress-woo-payment',
                'source'    => $root .'learnpress-woo-payment.zip',
                'required'  => true,
            ),
            array(
                'name'      => 'Reviews Plus',
                'slug'      => 'reviews-plus',
                'source'    => $root .'reviews-plus.zip',
                'required'  => true,
            ),
            array(
                'name'               => 'Revolution Slider',
                'slug'               => 'revslider',
                'source'             => $root .'revslider.zip',
                'required'           => true,
            ),
            array(
                'name'               => 'Contact Form 7',
                'slug'               => 'contact-form-7',
                'required'           => false,
            ),
            array(
                'name'               => 'MailChimp for WordPress',
                'slug'               => 'mailchimp-for-wp',
                'required'           => false,
            ),
            array(
                'name'               => 'Woocommerce',
                'slug'               => 'woocommerce',
                'required'           => true,
            ),
            array(
                'name'               => 'WP User Avatar',
                'slug'               => 'wp-user-avatar',
                'required'           => false,
            ),
            array(
                'name'               => 'Tweets Slider',
                'slug'               => 'tweets-slider',
                'required'           => false,
            ),
            array(
                'name'               => 'LearnPress – WordPress LMS Plugin',
                'slug'               => 'learnpress',
                'required'           => false,
            ),
            array(
                'name'               => 'Learnpress Course Review',
                'slug'               => 'learnpress-course-review',
                'required'           => false,
            ),
            array(
                'name'               => 'LearnPress – Course Wishlist',
                'slug'               => 'learnpress-wishlist',
                'required'           => false,
            ),
            array(
                'name'               => 'LearnPress – Offline Payment',
                'slug'               => 'learnpress-offline-payment',
                'required'           => false,
            ),
            array(
                'name'               => 'Custom Post Type Widgets',
                'slug'               => 'custom-post-type-widgets',
                'required'           => false,
            ),
            array(
                'name'               => 'Social Login, Social Sharing by miniOrange',
                'slug'               => 'miniorange-login-openid',
                'required'           => false,
            ),
            array(
                'name'               => 'YITH WooCommerce Quick View',
                'slug'               => 'yith-woocommerce-quick-view',
                'required'           => false,
            ),
            array(
                'name'               => 'YITH WooCommerce Wishlist',
                'slug'               => 'yith-woocommerce-wishlist',
                'required'           => false,
            ),            
            array(
                'name'               => 'Custom Post Type Widgets',
                'slug'               => 'custom-post-type-widgets',
                'required'           => false,
            ),
            array(
                'name'               => 'Advanced Custom Fields',
                'slug'               => 'advanced-custom-fields',
                'required'           => false,
            ),
            array(
                'name'               => 'Event Tickets',
                'slug'               => 'event-tickets',
                'required'           => false,
            ),

            array(
                'name'               => 'The Events Calendar',
                'slug'               => 'the-events-calendar',
                'required'           => false,
            ),
        ) );

    }
}
if ( class_exists( 'LearnPress' ) ) {
    require_once JWS_ABS_PATH . '/learnpress/lp-template-functions.php';
    require_once JWS_ABS_PATH . '/learnpress/lp-template-hooks.php';
}
if ( defined("TRIBE_EVENTS_FILE") ) {
    require_once JWS_ABS_PATH . '/tribe-events/event-hook.php';
}
add_action('wp_loaded', 'jws_theme_prefix_output_buffer_start');

function jws_theme_prefix_output_buffer_start() { 
    ob_start("jws_theme_prefix_output_callback"); 
}

function jws_theme_prefix_output_callback($buffer) {
    return preg_replace( "%[ ]type=[\'\"]text\/(javascript|css)[\'\"]%", '', $buffer );
};