<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 */
global $sidebar, $post_setting;
$sidebar = 'default-widget';
$class = 'col-md-12';
$sidebar_open = true;
if (isset($_GET['sidebar']) && $_GET['sidebar'] == 'none') {
	$sidebar_open = false;
}
if (is_active_sidebar( $sidebar ) && $sidebar_open) {
	$class = 'col-lg-9 col-md-8';
}

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

if ( function_exists( 'fw_get_db_settings_option' ) ){
	$post_setting = fw_get_db_settings_option('posts_settings');
}else{
	$post_setting = array(
		'featured_image' => 'yes',
		'posts_layout' => 'column-1',
		'post_meta' => 'yes',
		'posts_excerpt_length' => 0,
		'posts_per_page'	=> 9,
		'enabled_readmore' => 'yes',
		'readmore_text' => esc_html__('Read More','thebrilliance'),
	);
}
if(isset($_GET['posts_per_page'])){
	$post_setting['posts_per_page'] = $_GET['posts_per_page'];
}
if(isset($_GET['posts_excerpt_length'])){
	$post_setting['posts_excerpt_length'] = $_GET['posts_excerpt_length'];
}
if(isset($_GET['posts_layout'])){
	$post_setting['posts_layout'] = $_GET['posts_layout'];
}


$encoded_atts = json_encode( $post_setting );
get_header();

?>
<div class="main-content blog-archive">
    <div class="container">
        <div class="row">
        	
			<div id="primary" class="<?php echo esc_attr($class); ?>" data-atts="<?php echo esc_attr( $encoded_atts ); ?>" data-paged="<?php echo esc_attr( $paged ); ?>" >
					
				
	        	<?php
					if ( have_posts() ) :
						// Start the Loop.
						echo '<div class="row">';
						while ( have_posts() ) : the_post();

							/*
							 * Include the post format-specific template for the content. If you want to
							 * use this in a child theme, then include a file called called content-___.php
							 * (where ___ is the post format) and that will be used instead.
							 */
							get_template_part( 'content', get_post_format() );

						endwhile;
						echo '</div>';
						// Previous/next post navigation.
						echo  jws_paginate_links2();

					else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' );

					endif;
					
				?>

			</div>

			<?php 
			$sidebar_open = true;
			if (isset($_GET['sidebar']) && $_GET['sidebar'] == 'none') {
				$sidebar_open = false;
			}

			if (is_active_sidebar( $sidebar ) && $sidebar_open) { ?>
    			<div id="secondary" class="col-lg-3 col-md-4 sticky_sidebar">
                	<?php 
                 
                        dynamic_sidebar( 'default-widget' );
                   
                    ?>
                </div>
			<?php }
			?>
        </div>
    </div>
</div>

<?php get_footer(); ?>