<?php
/**
 * Template for displaying course rate.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/addons/course-review/course-rate.php.
 *
 * @author ThimPress
 * @package LearnPress/Course-Review/Templates
 * version  3.0.1
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

$course_id       = get_the_ID();
$course_rate_res = learn_press_get_course_rate( $course_id, false );
$course_rate     = $course_rate_res['rated'];
$total           = $course_rate_res['total'];
?>

<div class="course-rate">
	<div class="left-block">
	    <div class="review-number">
			<?php do_action( 'learn_press_before_total_review_number' ); ?>
			<?php 
				printf(__( '<span class="number-ave-rate"> %1.1f </span>', 'thebrilliance' ), $course_rate );

				learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );

				printf( _n( '<span class="number-total-rating"> %d rating </span>', '<span class="number-total-rating"> %d ratings </span>', $total, 'thebrilliance' ), $total ); ?>
			<?php do_action( 'learn_press_after_total_review_number' ); ?>
	    </div>
    </div>

    <div class="right-block">
		<?php
		if ( isset( $course_rate_res['items'] ) && ! empty( $course_rate_res['items'] ) ):
			foreach ( $course_rate_res['items'] as $item ):
				?>
                <div class="course-rate">
                    <span class="rated">
                    	<?php 
                    	for ( $i = 1; $i <= (int)$item['rated']; $i++ ) {
							echo wp_kses_post('<i class="fa fa-star" aria-hidden="true"></i>');
						}
                        ?>

                    	</span>
                    <div class="review-bar">
                        <div class="rating" style="width:<?php echo esc_attr($item['percent']); ?>% "></div>
                    </div>
                    <span class="percent"><?php echo esc_html( $item['percent'] ); ?>%</span>
                </div>
			<?php
			endforeach;
		endif;
		?>
    </div>
</div>
