<?php

/**
 * Template for displaying the list of course content is in wishlist.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/addons/wishlist/wishlist-content.php.
 *
 * @author ThimPress
 * @package LearnPress/Wishlist/Templates
 * @version 3.0.1
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

global $post;
?>

<li id="learn-press-tab-wishlist-course-<?php echo esc_attr($post->ID); ?>" class="col-md-4" data-context="tab-wishlist">
<?php
	$course = LP_Global::course();
	if (function_exists('fw_get_db_settings_option')) {
	    $course_settings = fw_get_db_settings_option( 'course_settings', '' );

	}else{
	    $course_settings = array(
	        'archive_course_image_size' => 'full',
	    );  
	}
	?>
	<div class="inner-wishlist-course">
		<div class="wrap-lp-thumbnail">
			<?php if (has_post_thumbnail()): ?> 
				<div class="lp-thumbnail">
					<?php echo jws_get_post_thumbnail($course_settings['archive_course_image_size']); ?>
					<div class="list-action">
						<!-- <div class="add-to-cart lp-btn"> -->
							<?php 
							// learn_press_course_purchase_button();
							// esc_html_e('Add to cart','thebrilliance');
							?>
						<!-- </div> -->
						<div class="wrap-list-btn">

							<?php
							$video_intro = get_post_meta( get_the_ID(), 'jws_course_video_intro', true );
							if ( $video_intro ) :
							?>
								<div class="button-play">
									
									<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail"><i class="fa fa-eye" aria-hidden="true"></i><?php esc_html_e('Watch Video','thebrilliance'); ?></a>

								</div>
							<?php 
							endif;
							?>
							
							<!-- <div class="wrap-wishlist-btn"> -->
							<?php 
							// if (class_exists('LP_Addon_Wishlist')) {
							//     LP_Addon_Wishlist::instance()->wishlist_button();
							//     esc_html_e('Add to wishlist','thebrilliance');
							// }
							?>
							<!-- </div> -->


						</div>
					</div>



					
				</div>
			<?php endif; ?>
		</div>

		<div class="wrap-lp-content">

			<h2 class="lp-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			<div class="lp-meta">

				<div class="meta-post">
	                <div class="author">
	                    <?php 
	                    	// $link = learn_press_user_profile_link(  $user->ID );
	                        $author = get_the_author_meta('ID'); 
	                        echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author).'">'.get_the_author().'</a>';
	                    ?> 
	                </div>
	                <?php $arr_cat = wp_get_post_terms(get_the_ID(), 'course_category', array("fields" => "all")); ?>
	                <?php if(!empty($arr_cat)): ?>
		                <div class="categories">
		                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
		                </div>
		            <?php endif; ?>
	            </div>
			</div>
			<div class="lp-content"><?php the_excerpt(); ?></div>
			<?php 
		    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
		    $schedule = get_post_meta( get_the_ID(), 'jws_course_schedule', true );
		    $difficulty = get_post_meta( get_the_ID(), 'jws_course_difficulty', true );
		    $branch = get_post_meta( get_the_ID(), 'jws_course_branch', true );
		    $typology = get_post_meta( get_the_ID(), 'jws_course_typology', true );
		    $language = get_post_meta( get_the_ID(), 'jws_course_language', true ); 
		    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
		    ?>
			<div class="lp-info">
				<ul>
					<li>
						<span class="jws-value">
							<i class="fa fa-play-circle" aria-hidden="true"></i>
							<?php echo wp_kses_post($course->count_items()); ?>
							<?php esc_html_e('Lecture','thebrilliance'); ?>
						</span>
					</li>

					<?php if ($duration): ?>
						<li>
							<span class="jws-value">
								<i class="fa fa-clock-o" aria-hidden="true"></i> 
								<?php echo wp_kses_post($duration); ?>
							</span>
						</li>
					<?php endif; ?>
					
					<?php if ($difficulty): ?>
						<li>
							<span class="jws-value">
								<i class="fa fa-sliders" aria-hidden="true"></i>
								<?php echo wp_kses_post($difficulty); ?>
							</span>
						</li>
					<?php endif; ?>

				</ul>
			</div>
			<div class="course-meta">
				<?php 
				if ( $price_html = $course->get_price_html() ) { ?>
			        <span class="price"><?php echo wp_kses_post($price_html); ?></span>
				<?php
				}
				?>

				<div class="archive-lp-rating">
	            	<?php 
	            	$course_id       = $course->get_id();
					$course_rate_res = learn_press_get_course_rate( $course_id, false );
					echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
					$course_rate     = $course_rate_res['rated'];
					learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
	            	?>
	            </div>

	            <div class="clearfix"></div>
			</div>
		</div>
	</div>

</li>