<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$user = LP_Global::user();

$arr_col = array(
    1 => 'col-md-12',
    2 => 'col-md-6 col-sm-6',
    3 => 'col-md-4',
    4 => 'col-md-3',
    5 => 'col-md-5_12',
    6 => 'col-md-2',
);
wp_enqueue_script( 'isotope');
if (function_exists('fw_get_db_settings_option')) {
    $course_settings = fw_get_db_settings_option( 'course_settings', '' );

}else{
    $course_settings = array(
        'archive_course_layout' => 3,
    );  
}

if (isset($_GET['layout'])) {
    $course_settings['archive_course_layout'] = $_GET['layout'];
}
global $profile_block;
if($profile_block == 'profile_block'){
    $course_settings['archive_course_layout'] = 3;
}

?>

<li id="post-<?php the_ID(); ?>" class="<?php echo esc_attr($arr_col[(int)$course_settings['archive_course_layout']]);?>">

	<?php
    // @deprecated
    do_action( 'learn_press_before_courses_loop_item' );

    // @since 3.0.0
    do_action( 'learn-press/before-courses-loop-item' );
    ?>


		<?php
        // @deprecated
        do_action( 'learn_press_courses_loop_item_title' );

        // @since 3.0.0
        do_action( 'learn-press/courses-loop-item-title' );
        ?>

	<?php

    // @since 3.0.0
	do_action( 'learn-press/after-courses-loop-item' );

	// @deprecated
    do_action( 'learn_press_after_courses_loop_item' );
    ?>

</li>