<?php
/**
 * Template for displaying before main content.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/global/before-main-content.php.
 *
 * @author  ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

if (function_exists('fw_get_db_settings_option')) {
    $course_settings = fw_get_db_settings_option( 'course_settings', '' );

}else{
    $course_settings = array(
        'archive_course_layout' => 3,
    );  
}
?>

<?php $user = learn_press_get_current_user(); ?>

<?php if ( learn_press_is_course() ){ ?>

<div id="lp-single-course" class="lp-single-course">

	<?php if ( ! learn_press_get_page_link( 'checkout' ) && ( $user->is_admin() || $user->is_instructor() ) ) { ?>

		<?php $message =esc_html__( 'LearnPress <strong>Checkout</strong> page is not set up. ', 'thebrilliance' );

		if ( $user->is_instructor() ) {
			$message .=esc_html__( 'Please contact administrator for setting up this page.', 'thebrilliance' );
		} else {
			$message .= sprintf(esc_html__( 'Please <a href=\"%s\" target=\"_blank\">setup</a> it so users can purchase courses.', 'thebrilliance' ), admin_url( 'admin.php?page=learn-press-settings&tab=checkout' ) );
		} ?>

		<?php learn_press_display_message( $message, 'error' ); ?>

	<?php } ?>

	<?php } else{ ?>

    <div id="lp-archive-courses" class="lp-archive-courses jws-columns-<?php echo esc_attr($course_settings['archive_course_layout']); ?>">

		<?php } ?>
