<?php
/**
 * Add some meta data for a course
 *
 * @param $meta_box
 */
if ( !function_exists( 'jws_add_course_meta' ) ) {
	function jws_add_course_meta( $meta_box ) {
		$fields             = $meta_box['fields'];

		$fields[]           = array(
			'name' => esc_html__( 'Sale Promote', 'thebrilliance' ),
			'id'   => 'jws_course_sale_promote',
			'type' => 'text',
			'desc' => esc_html__( 'Sale Promote for studying', 'thebrilliance' ),
			'std'  => ''
		);

		$fields[]           = array(
			'name' => esc_html__( 'Schedule', 'thebrilliance' ),
			'id'   => 'jws_course_schedule',
			'type' => 'text',
			'desc' => esc_html__( 'Schedule for studying', 'thebrilliance' ),
			'std'  => esc_html__( '2.00 pm-4.00 pm ', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Duration', 'thebrilliance' ),
			'id'   => 'jws_course_duration',
			'type' => 'text',
			'desc' => esc_html__( 'Duration for studying', 'thebrilliance' ),
			'std'  => esc_html__( '14 Hours', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Difficulty Level', 'thebrilliance' ),
			'id'   => 'jws_course_difficulty',
			'type' => 'text',
			'desc' => esc_html__( 'Difficulty for studying', 'thebrilliance' ),
			'std'  => esc_html__( 'Intermediate ', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Branch', 'thebrilliance' ),
			'id'   => 'jws_course_branch',
			'type' => 'text',
			'desc' => esc_html__( 'Branch for studying', 'thebrilliance' ),
			'std'  => esc_html__( 'Head Branch', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Typology', 'thebrilliance' ),
			'id'   => 'jws_course_typology',
			'type' => 'text',
			'desc' => esc_html__( 'Typology for studying', 'thebrilliance' ),
			'std'  => esc_html__( 'Premium', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Languages', 'thebrilliance' ),
			'id'   => 'jws_course_language',
			'type' => 'text',
			'desc' => esc_html__( 'Language\'s used for studying', 'thebrilliance' ),
			'std'  => esc_html__( 'English', 'thebrilliance' )
		);

		$fields[]           = array(
			'name' => esc_html__( 'Media', 'thebrilliance' ),
			'id'   => 'jws_course_video_intro',
			'type' => 'textarea',
			'desc' => esc_html__( 'Add an embed link like video, PDF, slider...', 'thebrilliance' ),
		);


		$meta_box['fields'] = $fields;

		return $meta_box;
	}

}

add_filter( 'learn_press_course_settings_meta_box_args', 'jws_add_course_meta' );

if ( ! function_exists( 'jws_related_courses' ) ) {
	function jws_related_courses() {
		if (function_exists('fw_get_db_settings_option')) {
			$course_setting = fw_get_db_settings_option( 'course_settings' );
		}else{
			$course_setting = array(
				'course_related_columns' => 3,
				'course_related_style' => 'grid',
			);
		}

		$arr_col = array(
			4 => 'col-md-3',
			3 => 'col-md-4',
			2 => 'col-md-6',
		);

		$related_courses    = jws_get_related_courses($course_setting['course_related_columns'] );
	

		if ( $related_courses ) {
			?>
			<div class="jws-ralated-course  course-<?php echo esc_attr($course_setting['course_related_style']); ?>">
				<div class="container">
					<div class="row"><div class="col-md-12">
						
							<h3 class="related-title">
								<?php esc_html_e( 'Related Courses', 'thebrilliance' ); ?>
							</h3>
							<div class="sub-title"><span><?php esc_html_e( 'Skills', 'thebrilliance' ); ?></span></div>

						<div class="jws-course-grid">
							<div class="jws-carousel-wrapper">
						     	<div class="row">
								<?php foreach ( $related_courses as $course_item ) : ?>
									<?php
									$course      = learn_press_get_course( $course_item->ID );
									$is_required = $course->is_required_enroll();
									?>
									
										<article class="lpr_course <?php echo esc_attr($arr_col[$course_setting['course_related_columns']]); ?>">
											<div class="course-item">

												<div class="course-thumbnail">
													<a class="thumb" href="<?php echo get_the_permalink( $course_item->ID ); ?>">
														<?php  
														if (function_exists('fw_get_db_settings_option')) {
														    $course_settings = fw_get_db_settings_option( 'course_settings', '' );
														}else{
														    $course_settings = array(
														        'archive_course_image_size' => 'full',
														    );  
														}
														echo jws_get_post_thumbnail($course_settings['archive_course_image_size'],get_post_thumbnail_id($course_item->ID)); ?>
													</a>

													<div class="list-action">
														<div class="wrap-list-btn">
									
															<?php
															$video_intro = get_post_meta( $course_item->ID, 'jws_course_video_intro', true );
															if ( $video_intro ) :
															?>
																<div class="button-play">
																	
																	<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail"><i class="fa fa-eye" aria-hidden="true"></i><?php esc_html_e('Watch Video','thebrilliance'); ?></a>

																</div>
															<?php 
															endif;
															?>

														</div>
													</div>
												</div> 

												<div class="jws-course-content">

													<h2 class="course-title">
														<a rel="bookmark"
														   href="<?php echo get_the_permalink( $course_item->ID ); ?>"><?php echo esc_html( $course_item->post_title ); ?></a>
													</h2> 

													<div class="lp-meta">
														<div class="meta-post">
											                <div class="author">

											                    <?php 
											                    
											                    $author = get_user_by('ID', $course_item->post_author); 
											                    echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author->ID).'">'.esc_html($author->display_name).'</a>'; ?> 

											                </div>
											                <?php $arr_cat = wp_get_post_terms(get_the_ID(), 'course_category', array("fields" => "all")); ?>
											                <?php if(!empty($arr_cat)): ?>
												                <div class="categories">
												                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
												                </div>
												            <?php endif; ?>
											            </div>
													</div>

													<div class="lp-excerpt">
														<?php the_excerpt($course_item->ID); ?>
													</div>

													<?php 
												    $max_students = get_post_meta( $course_item->ID, '_lp_max_students', true );
												    $schedule = get_post_meta( $course_item->ID, 'jws_course_schedule', true );
												    $difficulty = get_post_meta( $course_item->ID, 'jws_course_difficulty', true );
												    $branch = get_post_meta( $course_item->ID, 'jws_course_branch', true );
												    $typology = get_post_meta( $course_item->ID, 'jws_course_typology', true );
												    $language = get_post_meta( $course_item->ID, 'jws_course_language', true ); 
												    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
												    ?>

													<div class="lp-info">
														<ul>
															<li>
																<span class="jws-value">
																	<i class="fa fa-play-circle" aria-hidden="true"></i>
																	<?php echo wp_kses_post($course->count_items()); ?>
																	<?php esc_html_e('Lecture','thebrilliance'); ?>
																</span>
															</li>

															<?php if ($duration): ?>
																<li>
																	<span class="jws-value">
																		<i class="fa fa-clock-o" aria-hidden="true"></i> 
																		<?php echo wp_kses_post($duration); ?>
																	</span>
																</li>
															<?php endif; ?>

															<?php if ($difficulty): ?>
																<li>
																	<span class="jws-value">
																		<i class="fa fa-sliders" aria-hidden="true"></i>
																		<?php echo wp_kses_post($difficulty); ?>
																	</span>
																</li>
															<?php endif; ?>
															
														</ul>
													</div>

													<div class="course-meta">
														<?php 
														if ( $price_html = $course->get_price_html() ) { ?>
													        <span class="price"><?php echo wp_kses_post($price_html);  ?></span>
														<?php
														}
														?>

														<div class="archive-lp-rating">
										                	<?php 
										                	$course_id       = $course->get_id();
															$course_rate_res = learn_press_get_course_rate( $course_id, false );
															echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
															$course_rate     = $course_rate_res['rated'];
															learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
										                	?>
										                </div>

										                <div class="clearfix"></div>
													</div>
												</div>
											</div>
										</article>
									
								<?php endforeach; ?>
								</div>
							</div>
						</div>


					</div></div>
				</div>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'jws_related_events' ) ) {
	function jws_related_events() {

		

		if (function_exists('fw_get_db_settings_option')) {
			$event_settings = fw_get_db_settings_option( 'event_settings' );
		}else{
			$event_settings = array(
				'event_related_columns' => 3,
				'event_related_style' => 'grid',
			);
		}

		$arr_col = array(
			4 => 'col-md-3',
			3 => 'col-md-4',
			2 => 'col-md-6',
		);

		$related_events = jws_get_related_events($event_settings['event_related_columns']);
		if ( $related_events ) {
		?>
			<div class="jws-ralated-course  event-<?php echo esc_attr($event_settings['event_related_style']); ?>">
				<div class="container">
					<div class="row"><div class="col-md-12">
						
							<h3 class="related-title">
								<?php esc_html_e( 'Related Events', 'thebrilliance' ); ?>
							</h3>
							<div class="sub-title"><span><?php esc_html_e( 'Journal', 'thebrilliance' ); ?></span></div>

						<div class="jws-course-grid">
							<div class="jws-carousel-wrapper">
						     	<div class="row">
								<?php foreach ( $related_events as $event_item ) : ?>
										<article class="lpr_course <?php echo esc_attr($arr_col[$event_settings['event_related_columns']]); ?>">
											<div class="course-item">

												<div class="course-thumbnail">
													<a class="thumb" href="<?php echo get_the_permalink( $event_item->ID ); ?>">
														<?php  
														if (function_exists('fw_get_db_settings_option')) {
														    $event_settings = fw_get_db_settings_option( 'event_settings', '' );
														}else{
														    $event_settings = array(
														        'archive_event_image_size' => 'full',
														    );  
														}
														echo jws_get_post_thumbnail($event_settings['archive_event_image_size'], get_post_thumbnail_id($event_item->ID)); ?>
													</a>
												</div> 

												<div class="jws-course-content">

													<h2 class="course-title">
														<a rel="bookmark"
														   href="<?php echo get_the_permalink( $event_item->ID ); ?>"><?php echo esc_html( $event_item->post_title ); ?></a>
													</h2> 

													<?php 
													$regular_price    = tribe_get_cost( $event_item->ID );

													if ($regular_price) {
														echo wp_kses_post('<span class="price">'.$regular_price.'$</span>');
													}else{
														echo wp_kses_post('<span class="price">'.esc_html__('Free','thebrilliance').'</span>');
													}
													echo ic_get_review_totals_html2( $event_item->ID );
													?>
												
													<?php 
												    $max_students = get_post_meta( $event_item->ID, '_lp_max_students', true );
												    $schedule = get_post_meta( $event_item->ID, 'jws_course_schedule', true );
												    $difficulty = get_post_meta( $event_item->ID, 'jws_course_difficulty', true );
												    $branch = get_post_meta( $event_item->ID, 'jws_course_branch', true );
												    $typology = get_post_meta( $event_item->ID, 'jws_course_typology', true );
												    $language = get_post_meta( $event_item->ID, 'jws_course_language', true ); 
												    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
												    ?>
                                                    <div class="tribe-events-list-event-description tribe-events-content description entry-summary">
                                                        <?php $excerpt = tribe_events_get_the_excerpt( null, wp_kses_allowed_html( 'post' ) );
			                                                  echo wp_trim_words( $excerpt, 20, '' ); ?>
                                                    </div>
													<div class="lp-info">
														<ul>
															<li>
																<span class="jws-value">
																	<i class="icon-calendar2" aria-hidden="true"></i>
																	<?php 
																	$start_date = tribe_get_start_date( null, true, 'F d @ g:i a' );
																	echo wp_kses_post($start_date); ?>
																</span>
															</li>

															<li>
																<span class="jws-value">
																	<i class="icon-location32" aria-hidden="true"></i>
																	<?php echo tribe_get_full_address(); ?>
																</span>
															</li>
															
														</ul>
													</div>
												</div>
											</div>
										</article>
									
								<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div></div>
				</div>
			</div>
		<?php
		}
		
	}
}

if ( ! function_exists( 'jws_get_related_events' ) ) {
	function jws_get_related_events($limit) {
		if ( ! $limit ) {
			$limit = 3;
		}

		$event_id = get_the_ID();

		// $cat_ids = array();
		// $cats    = get_the_terms( $event_id, 'tribe_events_cat' );

		// if ( $cats ) {
		// 	foreach ( $cats as $individual_cat ) {
		// 		$cat_ids[] = $individual_cat->term_id;
		// 	}
		// }

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'orderby'			  => 'rand',
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $event_id ),
			'post_type'           => 'tribe_events'
		);

		// if ( $cat_ids ) {
		// 	$args['tax_query'] = array(
		// 		array(
		// 			'taxonomy' => 'tribe_events_cat',
		// 			'field'    => 'term_id',
		// 			'terms'    => $cat_ids
		// 		)
		// 	);
		// }
		$related = array();
		if ( $posts = new WP_Query( $args ) ) {
			global $post;
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$related[] = $post;
			}
		}
		wp_reset_postdata();

		return $related;
	}
}




if ( ! function_exists( 'jws_get_related_courses' ) ) {
	function jws_get_related_courses( $limit ) {
		if ( ! $limit ) {
			$limit = 3;
		}
		$course_id = get_the_ID();

		$tag_ids = array();
		$tags    = get_the_terms( $course_id, 'course_tag' );

		if ( $tags ) {
			foreach ( $tags as $individual_tag ) {
				$tag_ids[] = $individual_tag->term_id;
			}
		}

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $course_id ),
			'post_type'           => 'lp_course'
		);

		if ( $tag_ids ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_tag',
					'field'    => 'term_id',
					'terms'    => $tag_ids
				)
			);
		}
		$related = array();
		if ( $posts = new WP_Query( $args ) ) {
			global $post;
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$related[] = $post;
			}
		}
		wp_reset_postdata();

		return $related;
	}
}


if ( ! function_exists( 'jws_get_feature_image' ) ) {
	function jws_get_feature_image( $attachment_id, $size_type = null, $width = null, $height = null, $alt = null, $title = null ) {

		if ( ! $size_type ) {
			$size_type = 'full';
		}
		$src   = wp_get_attachment_image_src( $attachment_id, $size_type );
		$style = '';
		if ( ! $src ) {
			// Get demo image
			global $wpdb;
			$attachment_id = $wpdb->get_col(
				$wpdb->prepare(
					"SELECT p.ID FROM $wpdb->posts AS p INNER JOIN $wpdb->postmeta AS pm ON p.ID = pm.post_id
				WHERE 	pm.meta_key = %s
				AND 	pm.meta_value LIKE %s",
					'_wp_attached_file',
					'%demo_image.jpg'
				)
			);

			if ( empty( $attachment_id[0] ) ) {
				return;
			}

			$attachment_id = $attachment_id[0];
			$src           = wp_get_attachment_image_src( $attachment_id, 'full' );

		}

		if ( $width && $height ) {

			if ( $src[1] >= $width || $src[2] >= $height ) {

				$crop = ( $src[1] >= $width && $src[2] >= $height ) ? true : false;

				if ( $new_link = aq_resize( $src[0], $width, $height, $crop ) ) {

					$src[0] = $new_link;

				}

			}
			$style = ' width="' . $width . '" height="' . $height . '"';
		} else {
			if ( ! empty( $src[1] ) && ! empty( $src[2] ) ) {
				$style = ' width="' . $src[1] . '" height="' . $src[2] . '"';
			}
		}

		if ( ! $alt ) {
			$alt = get_the_title( $attachment_id );
		}

		if ( ! $title ) {
			$title = get_the_title( $attachment_id );
		}

		return '<img src="' . esc_url( $src[0] ) . '" alt="' . esc_attr( $alt ) . '" title="' . esc_attr( $title ) . '" ' . $style . '>';

	}
}

function jws_is_version_addons_review( $version ) {
	if ( defined( 'LP_ADDON_COURSE_REVIEW_VER' ) ) {
		return ( version_compare( LP_ADDON_COURSE_REVIEW_VER, $version, '>=' ) && version_compare( LP_ADDON_COURSE_REVIEW_VER, (int) $version + 1, '<' ) );
	}

	return false;
}

/**
 * Social sharing
 */
if ( ! function_exists( 'jws_social_share' ) ) {
	function jws_social_share() {
		ob_start();
		?>
                <ul class="lp-share-link">
                    <?php 

                    echo '<li><div class="facebook-social"><a target="_blank" class="facebook"  href="https://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '" title="' . esc_attr__( 'Facebook', 'thebrilliance' ) . '"><i class="fa fa-facebook"></i></a></div></li>';
                    echo '<li><div class="googleplus-social"><a target="_blank" class="googleplus" href="https://plus.google.com/share?url=' . urlencode( get_permalink() ) . '&amp;title=' . rawurlencode( esc_attr( get_the_title() ) ) . '" title="' . esc_attr__( 'Google Plus', 'thebrilliance' ) . '" onclick=\'javascript:window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;\'><i class="fa fa-google"></i></a></div></li>';
                    echo '<li><div class="twitter-social"><a target="_blank" class="twitter" href="https://twitter.com/share?url=' . urlencode( get_permalink() ) . '&amp;text=' . rawurlencode( esc_attr( get_the_title() ) ) . '" title="' . esc_attr__( 'Twitter', 'thebrilliance' ) . '"><i class="fa fa-twitter"></i></a></div></li>';
                    echo '<li><div class="linkedin-social"><a target="_blank" class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=' . urlencode( get_permalink() ) . '&title=' . rawurlencode( esc_attr( get_the_title() ) ) . '&summary=&source=' . rawurlencode( esc_attr( get_the_excerpt() ) ) . '"><i class="fa fa-linkedin-square"></i></a></div></li>';
                    // echo '<li><div class="pinterest-social"><a target="_blank" class="pinterest"  href="http://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;description=' . rawurlencode( esc_attr( get_the_excerpt() ) ) . '&amp;media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ) . '" onclick="window.open(this.href); return false;" title="' . esc_attr__( 'Pinterest', 'thebrilliance' ) . '"><i class="fa fa-pinterest-p"></i></a></div></li>';
                    
                    ?>
                </ul>
		<?php
		return  ob_get_clean();
	}
}