<?php
remove_action( 'learn-press/before-main-content', 'learn_press_breadcrumb', 10 );
remove_action( 'learn-press/content-learning-summary', 'learn_press_course_students', 15 );
remove_action( 'learn-press/content-learning-summary', 'learn_press_course_progress', 25 );
remove_action( 'learn-press/content-learning-summary', 'learn_press_course_remaining_time', 30 );
remove_action( 'learn-press/content-learning-summary', 'learn_press_course_tabs', 35 );
remove_action( 'learn-press/content-learning-summary', 'learn_press_course_buttons', 40 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_meta_start_wrapper', 5 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_students', 10 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_tabs', 20 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_meta_end_wrapper', 15 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_price', 25 );
remove_action( 'learn-press/content-landing-summary', 'learn_press_course_buttons', 30 );
add_action( 'learn_press_content_landing_summary', 'jws_learn_press_primary_content_single', 10 );
add_action( 'learn-press/content-learning-summary', 'jws_learn_press_primary_content_single', 10 );
add_action( 'learn-press/after-courses-loop-item', 'jws_learn_press_primary_content_archive', 10 );
remove_action( 'learn-press/after-courses-loop-item', 'learn_press_courses_loop_item_price', 20 );
remove_action( 'learn-press/after-courses-loop-item', 'learn_press_course_loop_item_buttons', 35 );
remove_action( 'learn-press/before-user-profile', 'learn_press_user_profile_header', 5 );
remove_action( 'learn-press/courses-loop-item-title', 'learn_press_courses_loop_item_thumbnail', 10 );
remove_action( 'learn-press/courses-loop-item-title', 'learn_press_courses_loop_item_title', 15 );
remove_action( 'learn-press/before-main-content', 'learn_press_search_form', 15 );

if ( ! function_exists( 'jws_learn_press_primary_content_single' ) ) {
	function jws_learn_press_primary_content_single( $args = array() ) { 

		if (function_exists('fw_get_db_settings_option')) {
		    $course_settings = fw_get_db_settings_option( 'course_settings', '' );

		}else{
		    $course_settings = array(
		        'course_single_thumb' => 'yes',
		        'single_course_meta' => 'yes',
		        'course_desc' => 'yes',
		    );  
		}
		?>
			
		


			<?php if ($course_settings['single_course_meta'] == 'yes') : ?>
				<div class="lp-meta">
					<div class="meta-post">
		                <div class="author">

		                    <?php 
		                        $author = get_the_author_meta('ID'); 
		                        echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author).'">'.get_the_author().'</a>';
		                    ?> 
		                </div>
		                <div class="categories">
		                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
		                </div>
		                <div class="lp-rating">
		                	<?php 
		                	$course_id       = get_the_ID();
							$course_rate_res = learn_press_get_course_rate( $course_id, false );
							$course_rate     = $course_rate_res['rated'];
							learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
		                	

		                	echo "<span class='count-rate'>(".$course_rate_res['total'].")</span>";
		                	?>
		                </div>
		            </div>
				</div>
			<?php endif; ?>

			<?php if ($course_settings['course_single_thumb'] == 'yes') :

            ?>
				<div class="lp-thumbnail">
					<?php echo jws_get_post_thumbnail($course_settings['single_course_image_size']); ?>
					<div class="button-play">
						<?php $video_intro = get_post_meta( get_the_ID(), 'jws_course_video_intro', true ); ?>
						<?php if ( $video_intro ) : ?>
							<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail">
								<div class="video-thumbnail">
                                    <span class="icon-play3"></span>
                                </div>
								<span class="preview-text"><?php esc_html_e('PREVIEW THIS COURSE','thebrilliance'); ?></span>
							</a>
						<?php endif; ?>
						
					</div>
					<div class="list-action">
						<div class="share lp-btn">
							<div class="share-btn">
								<i class="fa fa-share-alt" aria-hidden="true"></i>
								<?php echo jws_social_share(); ?>
							</div>
						</div>
					</div>
				</div>
			<?php endif; ?>

		<?php
	}
}

if ( ! function_exists( 'jws_learn_press_primary_content_archive' ) ) {
	function jws_learn_press_primary_content_archive( $args = array() ) { 
		$course = LP_Global::course();
		if (function_exists('fw_get_db_settings_option')) {
		    $course_settings = fw_get_db_settings_option( 'course_settings', '' );

		}else{
		    $course_settings = array(
		        'archive_course_image_size' => 'full',
		        'archive_course_meta' => 'yes',
				'archive_course_desc' => 'yes',
				'archive_course_thumb' => 'yes',
		    );  
		}
		?>


			<div class="wrap-lp-thumbnail">
				<?php if (has_post_thumbnail() &&  $course_settings['archive_course_thumb'] == 'yes'): ?> 
					<div class="lp-thumbnail">
						<?php echo jws_get_post_thumbnail($course_settings['archive_course_image_size']); ?>
						<div class="list-action">
							<!-- <div class="add-to-cart lp-btn"> -->
								<?php 
								// learn_press_course_purchase_button();
								// esc_html_e('Add to cart','thebrilliance');
								?>
							<!-- </div> -->
							<div class="wrap-list-btn">
		
								<?php
								$video_intro = get_post_meta( get_the_ID(), 'jws_course_video_intro', true );
								if ( $video_intro ) :
								?>
									<div class="button-play">
										
										<a href="<?php echo esc_url( $video_intro ); ?>" class="play-button video-thumbnail"><i class="fa fa-eye" aria-hidden="true"></i><?php esc_html_e('Watch Video','thebrilliance'); ?></a>

									</div>
								<?php 
								endif;
								?>
								
								<!-- <div class="wrap-wishlist-btn"> -->
								<?php 
								// if (class_exists('LP_Addon_Wishlist')) {
								//     LP_Addon_Wishlist::instance()->wishlist_button();
								//     esc_html_e('Add to wishlist','thebrilliance');
								// }
								?>
								<!-- </div> -->


							</div>
						</div>



						
					</div>
				<?php endif; ?>

			</div>

			<div class="wrap-lp-content">

				<h2 class="lp-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
				<div class="lp-meta">
					<?php if ($course_settings['single_course_meta'] == 'yes') : ?>
						<div class="meta-post">
			                <div class="author">
			                    <?php 
			                    	// $link = learn_press_user_profile_link(  $user->ID );
			                        $author = get_the_author_meta('ID'); 
			                        echo esc_html__('by ','thebrilliance').'<a href="'.learn_press_user_profile_link($author).'">'.get_the_author().'</a>';
			                    ?> 
			                </div>
			                <?php $arr_cat = wp_get_post_terms(get_the_ID(), 'course_category', array("fields" => "all")); ?>
			                <?php if(!empty($arr_cat)): ?>
				                <div class="categories">
				                	<?php echo esc_html__('In ','thebrilliance').get_the_term_list(get_the_ID(), 'course_category', '', ', ', ''); ?>
				                </div>
				            <?php endif; ?>
			            </div>
			        <?php endif; ?>
				</div>
				
				<?php if ($course_settings['archive_course_desc'] == 'yes') : ?>
					<div class="lp-content"><?php the_excerpt(); ?></div>
				<?php endif; ?>

				<?php 
			    $max_students = get_post_meta( get_the_ID(), '_lp_max_students', true );
			    $schedule = get_post_meta( get_the_ID(), 'jws_course_schedule', true );
			    $difficulty = get_post_meta( get_the_ID(), 'jws_course_difficulty', true );
			    $branch = get_post_meta( get_the_ID(), 'jws_course_branch', true );
			    $typology = get_post_meta( get_the_ID(), 'jws_course_typology', true );
			    $language = get_post_meta( get_the_ID(), 'jws_course_language', true ); 
			    $duration = get_post_meta( get_the_ID(), 'jws_course_duration', true ); 
			    ?>
			    <?php if ($course_settings['single_course_meta'] == 'yes') : ?>
					<div class="lp-info">
						<ul>
							<li>
								<span class="jws-value">
									<i class="fa fa-play-circle" aria-hidden="true"></i>
									<?php echo wp_kses_post($course->count_items()); ?>
									<?php esc_html_e('Lecture','thebrilliance'); ?>
								</span>
							</li>

							<?php if ($duration): ?>
								<li>
									<span class="jws-value">
										<i class="fa fa-clock-o" aria-hidden="true"></i> 
										<?php echo wp_kses_post($duration); ?>
									</span>
								</li>
							<?php endif; ?>
							
							<?php if ($difficulty): ?>
								<li>
									<span class="jws-value">
										<i class="fa fa-sliders" aria-hidden="true"></i>
										<?php echo wp_kses_post($difficulty); ?>
									</span>
								</li>
							<?php endif; ?>

						</ul>
					</div>
					<div class="course-meta">
						<?php 
						if ( $price_html = $course->get_price_html() ) { ?>
					        <span class="price"><?php echo wp_kses_post($price_html); ?></span>
						<?php
						}
						?>

						<div class="archive-lp-rating">
		                	<?php 
		                	$course_id       = $course->get_id();
							$course_rate_res = learn_press_get_course_rate( $course_id, false );
							echo "<span class='ave-rate'>".$course_rate_res['rated']."</span><span class='count-rate'>(".$course_rate_res['total'].")</span>";
							$course_rate     = $course_rate_res['rated'];
							learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate ) );
		                	?>
		                </div>

		                <div class="clearfix"></div>
					</div>
				<?php endif; ?>

			</div>

		<?php
	}
}

add_action( 'learn-press/jws-after-single-course-summary', 'learn_press_course_tabs', 35 );
add_action( 'learn-press/jws-after-single-course-summary2', 'learn_press_course_tabs2', 35 );

if ( ! function_exists( 'learn_press_course_tabs2' ) ) {
	function learn_press_course_tabs2() {
		learn_press_get_template( 'single-course/tabs/tabs.php' );
	}
}