<?php
/**
 * Template for displaying rating stars.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/addons/course-review/rating-stars.php.
 *
 * @author ThimPress
 * @package LearnPress/Course-Review/Templates
 * version  3.0.1
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

$percent = ( ! $rated ) ? 0 : min( 100, ( round( $rated * 2 ) / 2 ) * 20 );
$title   = sprintf(esc_html__( '%s out of 5 stars', 'thebrilliance' ), $rated );
?>
<div class="review-stars-rated" title="<?php echo esc_attr( $title ); ?>">
    <div class="review-stars empty"></div>
    <div class="review-stars filled" style="width:<?php echo wp_kses_post($percent); ?>%;"></div>
</div>