<?php
/**
 * Template for displaying instructor of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/instructor.php.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course = LP_Global::course();
$twitter = get_the_author_meta('twitter',$course->get_author()->get_id());
$facebook = get_the_author_meta('facebook',$course->get_author()->get_id());
$instagram = get_the_author_meta('instagram',$course->get_author()->get_id());
$google = get_the_author_meta('gplus',$course->get_author()->get_id());
$instructor_type = get_the_author_meta('instructor_type',$course->get_author()->get_id());
?>

<div class="course-author">


	<?php do_action( 'learn-press/before-single-course-instructor' ); ?>

    <div class="author-avatar">
		<?php echo get_avatar($course->get_author()->get_id() , 120 ); ?>
		
    </div>
    <div class="in_info">
        <h4 class="in_name">
            <?php echo wp_kses_post($course->get_instructor_html());?>
        </h4>
        <p class="in_job">
            <?php echo wp_kses_post($instructor_type);   ?>
        </p> 
       <ul class="social_author_list">
       <?php if(!empty($facebook)) : ?>
        <li><a href="<?php echo esc_url($facebook); ?>" class="in_facebook" href=""><span class="icon-facebook"></span></a></li>
       <?php endif; ?>
       <?php if(!empty($twitter)) : ?>
        <li><a href="<?php echo esc_url($twitter); ?>" class="in_twitter" href=""><span class="icon-twitter"></span></a></li>
       <?php endif; ?>
       <?php if(!empty($instagram)) : ?>
        <li><a href="<?php echo esc_url($instagram); ?>" class="in_instagram" href=""><span class="icon-instagram"></span></a></li>
       <?php endif; ?>
       <?php if(!empty($google)) : ?>
        <li><a href="<?php echo esc_url($google); ?>" class="in_google" href=""><span class="icon-google-plus"></span></a></li>
       <?php endif; ?>
    </ul>
    </div>

    <div class="author-bio">
		<?php echo wp_kses_post($course->get_author()->get_description()); ?>
    </div>
    
  

	<?php do_action( 'learn-press/after-single-course-instructor' ); ?>

</div>