<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other 'pages' on your WordPress site will use a different template.
 */
global $sidebar,$post;
$sidebar = 'page-widget';
$class = 'col-md-12';
if (is_active_sidebar( $sidebar )) {
	$class = 'col-lg-9 col-md-8';
}
if (isset($_GET['sidebar']) && $_GET['sidebar'] == 'none') {
	$class = 'col-lg-12 col-md-12';
}

if (function_exists('learn_press_get_page_id')) {
	if ( $post->ID == learn_press_get_page_id( 'profile' ) ) {
	 	$class = 'col-lg-12 col-md-12';
	}
} 
if (function_exists('learn_press_is_checkout')) {
	if(is_singular('lp_course') || is_front_page() || (learn_press_is_checkout() == true)){
		$class = 'col-lg-12 col-md-12';
	}
}


$page_sidebar = '';
if (function_exists('fw_get_db_settings_option')) {
	$page_setting = fw_get_db_settings_option( 'general_page', '' );
	$page_sidebar = $page_setting['page_sidebar'];
}
get_header(); 
?>

<div id="main-content" class="main-content <?php if(is_front_page()) echo esc_attr('front-page'); ?> <?php echo esc_attr($page_sidebar); ?>">

<?php
	if ( is_front_page() && jws_theme_has_featured_posts() ) {
		// Include the featured content template.
		get_template_part( 'featured-content' );
	}
?>
	<div class="content-area">
		<div id="content" class="site-content" role="main">
			<div class="container">
				<div class="row">
					
					<div id="primary" class="<?php echo esc_attr($class); ?>">
						<?php
							// Start the Loop.
							while ( have_posts() ) : the_post();

								// Include the page content template.
								get_template_part( 'content', 'page' );

								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) {
                        			comments_template();
                        		}
							endwhile;
						?>
					</div>
					
					<?php get_sidebar(); ?>

				</div>
			</div>
		</div><!-- #content -->
	</div><!-- #primary -->
</div><!-- #main-content -->

<?php
get_footer();
