<?php
/**
 * The template for displaying Search Results pages
 */
global $sidebar, $post_setting;
$sidebar = 'default-widget';
if ( function_exists( 'fw_get_db_settings_option' ) ){
	$post_setting = fw_get_db_settings_option('posts_settings');
}else{
	$post_setting = array(
		'featured_image' => 'yes',
		'posts_layout' => 'column-1',
		'post_meta' => 'yes',
		'posts_excerpt_length' => 0,
		'posts_per_page'	=> 9,
		'enabled_readmore' => 'yes',
		'readmore_text' => esc_html__('Read More','thebrilliance'),
	);
}
$class = 'col-md-12';
if (is_active_sidebar( $sidebar )) {
	$class = 'col-lg-9 col-md-8';
}
get_header(); ?>
<div class="main-content blog-archive search-page">
	<div class="container">
		<div class="row">
			<div id="primary" class="<?php echo esc_attr($class); ?>">

				<?php if ( have_posts() ) : ?>

					<?php
						// Start the Loop.
						while ( have_posts() ) : the_post();

							/*
							 * Include the post format-specific template for the content. If you want to
							 * use this in a child theme, then include a file called called content-___.php
							 * (where ___ is the post format) and that will be used instead.
							 */
							get_template_part( 'content', get_post_format() );

						endwhile;
						// Previous/next post navigation.
						jws_theme_paging_nav();

					else :
						// If no content, include the "No posts found" template.
						get_template_part( 'content', 'none' );

					endif;
				?>

			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>
</div>

<?php get_footer(); ?>