<?php
/**
 * Default Events Template
 * This file is the basic wrapper template for all the views if 'Default Events Template'
 * is selected in Events -> Settings -> Display -> Events Template.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/default-template.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.23
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

get_header();

if ( function_exists( 'fw_get_db_settings_option' ) ){
	$event_settings = fw_get_db_settings_option('event_settings');
}else{
	$event_settings = array(
		'single_event_meta' => 'yes',
		'event_info' => 'yes',
		'event_single_thumb' => 'yes',
		'events_sidebar' => 'full-width',
		'archive_event_filter' => 'yes',
		'archive_event_layout' => 3,
	);
}

?>
<div class="main-content <?php echo esc_attr($event_settings['events_sidebar']); ?>">
	<div class="container" >
		<div class="row">
			
			<?php if (is_singular('tribe_events')): 
				$start_date = tribe_get_start_date( null, true, 'j M Y' );
				$end_date = tribe_get_display_end_date( null, false, 'j M Y');
				$timestamp = time();
			    if ((strtotime($start_date) < $timestamp) && ($timestamp < strtotime($end_date))) {
			        $count_time = date('Y-m-d', strtotime( $end_date));
			    }

				tribe_the_notices(); 
				?>
				<div class="col-md-9">


					<?php if ($event_settings['single_event_meta'] == 'yes') : ?>
						<div class="meta-post">
							<div class="author"><?php esc_html_e('Orgnaizer by ','thebrilliance'); ?> <a href="#"><?php echo tribe_get_organizer_link(); ?></a></div>
							<?php 
								$product_id = get_the_ID();
								echo ic_get_review_totals_html2( $product_id );
							?>
						</div>
					<?php endif; ?>

					<?php if ($event_settings['event_single_thumb'] == 'yes') : ?>

						<div class="wrap-thumb-event">
							<?php if (isset($count_time)) : ?>
								<div class="event-wrap-countdown">
							    	<div class="jws-countdown-js" data-countdown="<?php echo esc_attr($count_time); ?>">
							    		<?php _e('Countdown Element','thebrilliance'); ?>
						    		</div>
							    </div>
							<?php endif; ?>
							<?php echo tribe_event_featured_image( null, 'full' ); ?>
						</div>

					<?php endif; ?>
                    				<div id="learn-press-course-tabs" class="course-tabs">
				    <ul class="learn-press-nav-tabs">
				        <li class="course-nav active">
				            <a href="#" data-tab="#tab-about">
				            <span class="title"><?php esc_html_e('About','thebrilliance'); ?></span>
				            </a>
				        </li>
				        <li class="course-nav">
				            <a href="#" data-tab="#tab-reviews">
				            <span class="title"><?php esc_html_e('Reviews','thebrilliance'); ?></span>
				            </a>
				        </li>

					        <li class="course-nav">
					            <a href="#" data-tab="#tab-speakers">
					            <span class="title"><?php esc_html_e('Speakers','thebrilliance'); ?></span>
					            </a>
					        </li>


				        <li class="course-nav">
				            <a href="#" data-tab="#tab-map">
				            <span class="title"><?php esc_html_e('Map','thebrilliance'); ?></span>
				            </a>
				        </li>

				        <li class="course-nav">
				            <a href="#" data-tab="#tab-ticket">
				            <span class="title"><?php esc_html_e('Ticket','thebrilliance'); ?></span>
				            </a>
				        </li>

				    </ul>

				    <div class="course-tab-panel active" id="tab-about">
						<?php tribe_get_view(); ?>
				    </div>


				    <div class="course-tab-panel" id="tab-reviews">
				        <?php 
				        echo do_shortcode('[reviews]');
				        ?>
				    </div>


					    <div class="course-tab-panel" id="tab-speakers">
					   
                          <?php $ID = tribe_get_organizer_ids();
                                foreach($ID as $loc) { ?>
                                    <div class="organize_item">
                                        <div class="avatar">
                                            <?php echo get_the_post_thumbnail($loc, 'jws-archive-post-4col'); ?>
                                        </div>
                                        <div class="info_spe">
                                        <h4><?php echo get_the_title($loc); ?></h4>
                                       <?php echo get_post_field('post_content',$loc); ?>
                                       </div>
                                    </div>

                         <?php }?>
					    </div>
		

				    <div class="course-tab-panel" id="tab-map">

				    	<?php 
				    	$set_venue_apart = apply_filters( 'tribe_events_single_event_the_meta_group_venue', false, get_the_ID() );
				    	if ( tribe_get_venue_id() ) {
							// If we have no map to embed and no need to keep the venue separate...
							if ( ! $set_venue_apart && ! tribe_embed_google_map() ) {
								tribe_get_template_part( 'modules/meta/venue' );
							} elseif ( ! $set_venue_apart && ! tribe_has_organizer() && tribe_embed_google_map() ) {
								// If we have no organizer, no need to separate the venue but we have a map to embed...
								tribe_get_template_part( 'modules/meta/venue' );
								echo '<div class="tribe-events-meta-group tribe-events-meta-group-gmap">';
								tribe_get_template_part( 'modules/meta/map' );
								echo '</div>';
							} else {
								// If the venue meta has not already been displayed then it will be printed separately by default
								$set_venue_apart = true;
							}
						}

						if ( $set_venue_apart ) : 

				    	do_action( 'tribe_events_single_event_meta_secondary_section_start' ); ?>
                        <div class="row">
    						<div class="col-md-4">
    							<?php
    							tribe_get_template_part( 'modules/meta/venue' );
    							?>
    						</div>
    
    						<div class="col-md-8">
    						<?php
    						tribe_get_template_part( 'modules/meta/map' );
    						?>
    						</div>
                        </div>
						<?php
						do_action( 'tribe_events_single_event_meta_secondary_section_end' );

						endif;
						?>
				    </div>

				    <div class="course-tab-panel" id="tab-ticket">
						<div class="row">
					    	<div class="col-md-6">
					    		<?php include JWS_Tribe__Tickets__Tickets::instance()->getTemplateHierarchy( 'tickets/rsvp_custom' ); ?>
					    	</div>

					    	<div class="col-md-6">
					    		<?php include JWS_Tribe__Tickets__Tickets::instance()->getTemplateHierarchy( 'tickets/tpp_custom' ); ?>
					    	</div>
				    	</div>
				    </div>


				    <div class="clearfix"></div>
				</div>
                	
				</div>
				
				<?php if ($event_settings['event_info'] == 'yes') : ?>
					<div class="col-md-3 sticky_sidebar">
						<div class="lp-tab-info">
							<?php 
							if (function_exists('get_field')) {
								$regular_price    = tribe_get_formatted_cost();
								$sale_promote = get_field('sale_promote');
								$duration = get_field('duration');
								$location = tribe_get_venue();
								$cancellation = get_field('cancellation');
                                $speaker = get_field('speaker');
							}
						    ?>

						    <div class="course-price">
								<div class="sale-price">
									<h4><?php esc_html_e('Price','thebrilliance'); ?></h4> 
									<span class="price">
										<?php echo wp_kses_post($regular_price); ?>
									</span>
								</div> 


								<div class="origin-price">
						        	<?php echo wp_kses_post($sale_promote); ?>
								</div> 
							</div>

							<ul class="lp-info-course">
								<?php if ($start_date) : ?> 
									<li>
										<span class="jws-label"><?php esc_html_e('Start Date','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($start_date); ?> </span>
									</li>
								<?php endif; ?>

								<?php if ($end_date) : ?> 
									<li>
										<span class="jws-label"><?php esc_html_e('End Date','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($end_date); ?> </span>
									</li>
								<?php endif; ?>

								<?php if ($duration) : ?> 
									<li>
										<span class="jws-label"><?php esc_html_e('Time','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($duration); ?> </span>
									</li>
								<?php endif; ?>


									<li>
										<span class="jws-label"><?php esc_html_e('Speaker','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($speaker); ?> </span>
									</li>
				

								<?php if ($location) : ?> 
									<li>
										<span class="jws-label"><?php esc_html_e('Location','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($location); ?> </span>
									</li>
								<?php endif; ?>

								<?php if ($cancellation) : ?> 
									<li>
										<span class="jws-label"><?php esc_html_e('Free Cancellation','thebrilliance'); ?> </span>
										<span class="jws-value"><?php echo wp_kses_post($cancellation); ?> </span>
									</li>
								<?php endif; ?>

							</ul>
						</div>
						<button id="btn-buy-ticket" data-mfp-src="#rsvp-now"><?php esc_html_e('BUY TICKET','thebrilliance'); ?></button>
					</div>
				<?php endif; ?>
	

		

			<?php else: ?>


				<div class="col-md-12">
					<?php 
					if($event_settings['archive_event_filter'] == 'yes'){
						tribe_get_template_part( 'modules/bar' );
					}
					?>

				</div>

				<?php if ($event_settings['events_sidebar'] == 'full-width' || (isset($_GET['sidebar']) && $_GET['sidebar'] == 'none')) : ?>
					<div id="primary" class="col-lg-12 col-md-12 list-col-<?php echo esc_attr($event_settings['archive_event_layout']); ?>">
				<?php else: ?>
					<div id="primary" class="col-lg-9 col-md-8 list-col-<?php echo esc_attr($event_settings['archive_event_layout']); ?>">
				<?php endif; ?>
					<main id="tribe-events-pg-template" class="tribe-events-pg-template">
						<?php tribe_events_before_html(); ?>
						<?php tribe_get_view(); ?>
						<?php tribe_events_after_html(); ?>
					</main>
				</div>

				
				<?php 
				$no_sidebar = true;
				if(isset($_GET['sidebar']) && $_GET['sidebar'] == 'none'){
					$no_sidebar = false;
				}

				if ($event_settings['events_sidebar'] != 'full-width' &&  $no_sidebar == true ) : 
					global $sidebar;
					$sidebar = 'event-widget';
					get_sidebar(); 
				endif;

			endif;
			?>

		</div>
	</div>
<?php if(is_singular( 'tribe_events' )) jws_related_events(); ?>
</div>

<?php
get_footer();
