<?php
function jws_filter_return_empty() {
    return;
}

add_filter( 'tribe_events_ical_single_event_links', 'jws_filter_return_empty');

class JWS_Tribe__Tickets__Tickets extends Tribe__Tickets__Tickets{
	
	protected static $instance;

	public static function instance() {
		if ( empty( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
	
}
if ( tribe_is_event() ) {
	function jws_return_excerpt_length_event($length) {
		$length = 10;
		return $length ;
	}
	add_filter('excerpt_length','jws_return_excerpt_length_event',999);
}



function tribe_get_events_title2( $depth = true ) {

	if ( ! $wp_query = tribe_get_global_query_object() ) {
		return;
	}

	$events_label_plural = tribe_get_event_label_plural();

	if ( $wp_query->get( 'featured' ) ) {
		$events_label_plural = sprintf( _x( 'Featured %s', 'featured events title', 'thebrilliance'), $events_label_plural );
	}

	$tribe_ecp = Tribe__Events__Main::instance();

	if ( is_single() && tribe_is_event() ) {
		// For single events, the event title itself is required
		$title = get_the_title();
	} else {
		// For all other cases, start with 'upcoming events'
		$title = sprintf( esc_html__( 'Upcoming %s', 'thebrilliance' ), $events_label_plural );
	}

	// If there's a date selected in the tribe bar, show the date range of the currently showing events
	if ( isset( $_REQUEST['tribe-bar-date'] ) && $wp_query->have_posts() ) {
		$first_returned_date = tribe_get_start_date( $wp_query->posts[0], false, Tribe__Date_Utils::DBDATEFORMAT );
		$first_event_date    = tribe_get_start_date( $wp_query->posts[0], false );
		$last_event_date     = tribe_get_end_date( $wp_query->posts[ count( $wp_query->posts ) - 1 ], false );

		// If we are on page 1 then we may wish to use the *selected* start date in place of the
		// first returned event date
		if ( 1 == $wp_query->get( 'paged' ) && $_REQUEST['tribe-bar-date'] < $first_returned_date ) {
			$first_event_date = tribe_format_date( $_REQUEST['tribe-bar-date'], false );
		}

		$title = sprintf(esc_html__( '%2$s - %3$s', 'thebrilliance' ), $events_label_plural, $first_event_date, $last_event_date );
	} elseif ( tribe_is_past() ) {
		$title = sprintf( esc_html__( 'Past %s', 'thebrilliance' ), $events_label_plural );
	}

	if ( tribe_is_month() ) {
		$title = sprintf(
			esc_html_x( '%2$s', 'month view', 'thebrilliance' ),
			$events_label_plural,
			date_i18n( tribe_get_date_option( 'monthAndYearFormat', 'F Y' ), strtotime( tribe_get_month_view_date() ) )
		);
	}

	// day view title
	if ( tribe_is_day() ) {
		$title = sprintf(
			esc_html_x( '%2$s', 'day_view', 'thebrilliance' ),
			$events_label_plural,
			date_i18n( tribe_get_date_format( true ), strtotime( $wp_query->get( 'start_date' ) ) )
		);
	}

	if ( is_tax( $tribe_ecp->get_event_taxonomy() ) && $depth ) {
		$cat = get_queried_object();
		$title = '<a href="' . esc_url( tribe_get_events_link() ) . '">' . $title . '</a>';
		$title .= ' &#8250; ' . $cat->name;
	}

	/**
	 * Allows for customization of the "Events" page title.
	 *
	 * @param string $title The "Events" page title as it's been generated thus far.
	 * @param bool $depth Whether to include the linked title or not.
	 */
	return apply_filters( 'tribe_get_events_title2', $title, $depth );
}

// function jws_return_false() {
// 	return false;
// }
add_filter('tribe_events_list_the_date_headers','__return_false');

add_filter('tribe_events_the_next_month_link','__return_false');

function tribe_events_the_next_month_link2() {
	$html = '';
	$url  = tribe_get_next_month_link();
	$text = tribe_get_next_month_text();


	// Check if $url is populated (an empty string may indicate the date was out-of-bounds, ie on 32bit servers)
	if ( ! empty( $url ) ) {
		$date = Tribe__Events__Main::instance()->nextMonth( tribe_get_month_view_date() );
		if ( $date <= tribe_events_latest_date( Tribe__Date_Utils::DBYEARMONTHTIMEFORMAT ) ) {
			$html = '<a data-month="' . $date . '" href="' . esc_url( $url ) . '" rel="next"><i class="fa fa-chevron-right" aria-hidden="true"></i> </a>';
		}
	}

	echo apply_filters( 'tribe_events_the_next_month_link2', $html );
}

add_filter('tribe_events_the_previous_month_link','__return_false');

function tribe_events_the_previous_month_link2() {
	$html = '';
	$url  = tribe_get_previous_month_link();
	$date = Tribe__Events__Main::instance()->previousMonth( tribe_get_month_view_date() );
	$earliest_event_date = tribe_events_earliest_date( Tribe__Date_Utils::DBYEARMONTHTIMEFORMAT );

	// Only form the link if a) we have a known earliest event date and b) the previous month date is the same or later
	if ( $earliest_event_date && $date >= $earliest_event_date ) {
		$text = tribe_get_previous_month_text();
		$html = '<a data-month="' . $date . '" href="' . esc_url( $url ) . '" rel="prev"><i class="fa fa-chevron-left" aria-hidden="true"></i></a>';
	}

	echo apply_filters( 'tribe_events_the_previous_month_link2', $html );
}


function tribe_the_day_link2( $date = null, $text = null ) {
	$html = '';

	try {
		if ( is_null( $text ) ) {
			$text = tribe_get_the_day_link_label( $date );
		}

		$date = tribe_get_the_day_link_date( $date );
		$link = tribe_get_day_link( $date );

		$earliest = tribe_events_earliest_date( Tribe__Date_Utils::DBDATEFORMAT );
		$latest   = tribe_events_latest_date( Tribe__Date_Utils::DBDATEFORMAT );

		if ( $date >= $earliest && $date <= $latest ) {
			$html = '<a href="' . esc_url( $link ) . '" data-day="' . $date . '" rel="prev">' . $text . '</a>';
		}
	} catch ( OverflowException $e ) {
	}

	echo apply_filters( 'tribe_the_day_link2', $html );
}
