<?php
/**
 * List View Loop
 * This file sets up the structure for the list loop
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/loop.php
 *
 * @version 4.4
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
} ?>

<?php
global $post;
global $more;
$more = false;

if ( function_exists( 'fw_get_db_settings_option' ) ){
	$event_settings = fw_get_db_settings_option('event_settings');
}else{
	$event_settings = array(
		'archive_event_layout' => 3,
	);
}

if (isset($_GET['colums'])) {
	$event_settings['archive_event_layout'] = $_GET['colums'];
    $class_grid = 'lq_grid';
}else {
   $class_grid = ''; 
}	


$arr_col = array(
	1 		=> 'col-md-12',
	2 		=> 'col-md-6',
	3 		=> 'col-md-4',
	4 		=> 'col-md-3'
);
?>

<div class="tribe-events-loop">
	<div class="row">

		<?php while ( have_posts() ) : the_post(); ?>
			<?php do_action( 'tribe_events_inside_before_loop' ); ?>

			<!-- Month / Year Headers -->
			<?php tribe_events_list_the_date_headers(); ?>

			<!-- Event  -->
			<?php
			$post_parent = '';
			if ( $post->post_parent ) {
				$post_parent = ' data-parent-post-id="' . absint( $post->post_parent ) . '"';
			}
			?>
			<div class="<?php echo esc_attr($arr_col[$event_settings['archive_event_layout']]); ?> <?php echo esc_attr($class_grid); ?>">
				
				<div id="post-<?php the_ID() ?>" class="<?php tribe_events_event_classes(); ?>" <?php echo esc_attr($post_parent); ?>>
					<?php
					$event_type = tribe( 'tec.featured_events' )->is_featured( $post->ID ) ? 'featured' : 'event';

					/**
					 * Filters the event type used when selecting a template to render
					 *
					 * @param $event_type
					 */
					$event_type = apply_filters( 'tribe_events_list_view_event_type', $event_type );

					tribe_get_template_part( 'list/single', $event_type );
					?>
				</div>

			</div>


			<?php do_action( 'tribe_events_inside_after_loop' ); ?>
		<?php endwhile; ?>

	</div>

</div><!-- .tribe-events-loop -->
