<?php 
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( isset( $_GET['shop_load'] ) ) {
    wc_get_template_part( 'archive', 'product-ajax' );
    return false;
}

if (function_exists('fw_get_db_settings_option')) {
    $shop_settings = fw_get_db_settings_option( 'shop_settings' );
}else{
    $shop_settings = array(
        'show_title' => 'yes',
    );
}

$sidebar = 'shop-widget';
$class = 'col-md-12';
if (is_active_sidebar( $sidebar )) {
    $class = 'col-lg-9 col-md-8';
}

get_header( 'shop' );
/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>
<div class="main-content shop-archive">
    <div class="container">
        <div class="row">
            
            <div class="<?php echo esc_attr($class); ?> primary">

                	<?php 
                    

                    if ( apply_filters( 'woocommerce_show_page_title', true ) && $shop_settings['show_title'] == 'yes' ) : ?>
                        <header class="jws-products-header">
                    		<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                        </header>
                	<?php 
                    endif;
                    	/**
                    	 * Hook: woocommerce_archive_description.
                    	 *
                    	 * @hooked woocommerce_taxonomy_archive_description - 10
                    	 * @hooked woocommerce_product_archive_description - 10
                    	 */
                    	do_action( 'woocommerce_archive_description' );
                    if ( have_posts() ) {
                        echo '<div class="woo-order-block">';
                    	/**
                    	 * Hook: woocommerce_before_shop_loop.
                    	 *
                    	 * @hooked wc_print_notices - 10
                    	 * @hooked woocommerce_result_count - 20
                    	 * @hooked woocommerce_catalog_ordering - 30
                    	 */
                    	do_action( 'woocommerce_before_shop_loop' );
                        echo '</div>';
                        echo '<div class="clearfix"></div>';

                    	woocommerce_product_loop_start();

                    	if ( wc_get_loop_prop( 'total' ) ) {
                    		while ( have_posts() ) {
                    			the_post();

                    			/**
                    			 * Hook: woocommerce_shop_loop.
                    			 *
                    			 * @hooked WC_Structured_Data::generate_product_data() - 10
                    			 */
                    			do_action( 'woocommerce_shop_loop' );

                    			wc_get_template_part( 'content', 'product' );
                    		}
                    	}

                    	woocommerce_product_loop_end();

                    	/**
                    	 * Hook: woocommerce_after_shop_loop.
                    	 *
                    	 * @hooked woocommerce_pagination - 10
                    	 */
                    	do_action( 'woocommerce_after_shop_loop' );
                    } else {
                    	/**
                    	 * Hook: woocommerce_no_products_found.
                    	 *
                    	 * @hooked wc_no_products_found - 10
                    	 */
                    	do_action( 'woocommerce_no_products_found' );
                    }
                    ?>

            </div>
            
            <?php if(is_active_sidebar( $sidebar )): ?>
                <div id="secondary" class="col-lg-3 col-md-4 secondary">
                    <?php dynamic_sidebar( $sidebar ); ?>
                </div>
            <?php endif; ?>
            
        </div>
    </div>
</div>
<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' ); 

get_footer( 'shop' );