<?php
function woocommerce_template_loop_product_thumbnail() {
    echo '<div class="wrap-thumb">';
    echo woocommerce_get_product_thumbnail();
    echo jws_action_button();
    echo '</div>';
}

function jws_action_button(){ ?>
    <div class="jws-action">

        <?php
        // quickview button
        if( get_option( 'yith-wcqv-enable') == 'yes' && defined( 'YITH_WCQV' )):
  
        ?>
            <div class="jws-product-btn jws-btn-quickview">
                <?php echo '<a href="#" class="button yith-wcqv-button" data-product_id="' . get_the_ID() . '"><span class="icon-eye22"></span></a>'; ?>
            </div>
        <?php 
        endif;
        ?>

        <div class="jws-product-btn jws-btn-add-to-cart">
            <?php woocommerce_template_loop_add_to_cart(); ?>
        </div>

        <div class="jws-product-btn jws-btn-wishlist">
            <?php 
            if (defined('YITH_WCWL')) {
                echo '<div class="product-wishlist-button">' . do_shortcode('[yith_wcwl_add_to_wishlist]') . '</div>';
            } 
            ?>
        </div>


        

    </div>
<?php 

}

add_filter( 'woocommerce_add_to_cart_fragments', 'jws_cart_count_fragments', 10, 1 );

function jws_cart_count_fragments( $fragments ) {
    
    $fragments['span.cart-count'] = '<span class="cart-count">' . WC()->cart->get_cart_contents_count() . '</span>';
    
    return $fragments;
    
}

function jws_get_gallery_image_html( $attachment_id, $main_image = false ) {
    $flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', get_theme_support( 'wc-product-gallery-slider' ) );
    $gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
    $thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
    $image_size        = apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single': $thumbnail_size );
    $full_size         = apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
    $thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
    $full_src          = wp_get_attachment_image_src( $attachment_id, $full_size );
    $image             = wp_get_attachment_image( $attachment_id, 'full', false, array(
        'title'                   => get_post_field( 'post_title', $attachment_id ),
        'data-caption'            => get_post_field( 'post_excerpt', $attachment_id ),
        'data-src'                => $full_src[0],
        'data-large_image'        => $full_src[0],
        'data-large_image_width'  => $full_src[1],
        'data-large_image_height' => $full_src[2],
        'class'                   => $main_image ? 'wp-post-image' : '',
    ) );

    return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" class="woocommerce-product-gallery__image">' . $image . '</div>';
}
function woocommerce_breadcrumb(){
    return false;
}
