<?php 
/*
Plugin Name: JWS Core
Description: Register post types needed for JWS themes
Version: 1.0
Text Domain: jws_core
*/
class Jws_Core {

	public $domain = 'jws_core';

	protected static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function __construct() {
		add_action( 'init', array($this, 'register_cpt'));
	}
	

	// Register Custom Post Type 
	public function register_cpt() {

		$post_type = array(
			'footer' => array(
				'name' => esc_html__('Footer','jws_core'),
				'taxonomies' => '',
				'hierarchical' => true,
				'has_archive'  => true,
				'menu_icon'    => 'dashicons-editor-kitchensink',
				'menu_position'=> 5,
			),

			'portfolio' => array(
				'name' => esc_html__('Portfolio','jws_core'),
				'taxonomies' => array(
					'portfolio_cat' => esc_html__('Categories','jws_core'),
				),
				'hierarchical' => true,
				'has_archive'  => true,
				'menu_icon'    => 'dashicons-id-alt',
				'menu_position'=> 5,
			),
		
		);

		$this->do_register($post_type);
		$this->jws_register_tax_additional();

	}
	public function do_register($post_type) {

		foreach ($post_type as $key => $value):
			$labels = array(
				'name'                => $value['name'],
				'singular_name'       => $value['name'],
				'menu_name'           => $value['name'],
				'parent_item_colon'   => __( 'Parent Item:', 'jws_core' ),
				'all_items'           => __( 'All Items', 'jws_core' ),
				'view_item'           => __( 'View Item', 'jws_core' ),
				'add_new_item'        => __( 'Add New Item', 'jws_core' ),
				'add_new'             => __( 'Add New', 'jws_core' ),
				'edit_item'           => __( 'Edit Item', 'jws_core' ),
				'update_item'         => __( 'Update Item', 'jws_core' ),
				'search_items'        => __( 'Search Item', 'jws_core' ),
				'not_found'           => __( 'Not found', 'jws_core' ),
				'not_found_in_trash'  => __( 'Not found in Trash', 'jws_core' ),
			);

			$args = array(
				'label'               => $value['name'],
			    'labels'              => $labels,
	            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats', ),
	            
	            'hierarchical'        => true,
	            'public'              => true,
	            'show_in_rest' 		  => true,
	            'show_ui'             => true,
	            'show_in_menu'        => true,
	            'show_in_nav_menus'   => true,
	            'show_in_admin_bar'   => true,
	            'menu_position'       => $value['menu_position'],
	            'menu_icon'           => $value['menu_icon'],
	            'can_export'          => true,
	            'has_archive'         => $value['has_archive'],
	            'exclude_from_search' => false,
	            'publicly_queryable'  => true,
	            'capability_type'     => 'page',
			);
			if($value['taxonomies'] != '')
				$args['taxonomies'] = $value['taxonomies'];

			register_post_type( $key, $args );

			if($value['taxonomies'] != '')
				$this->jws_register_tax($value['taxonomies'], $key);

			flush_rewrite_rules();
		endforeach;
	}

	public function jws_register_tax($tax, $post_type) {
		
		foreach ($tax as $key => $value):
			$labels = array(
				'name'					=> $value,
				'singular_name'			=> $value,
				'search_items'			=> __( 'Search '.$value, 'jws_core' ),
				'popular_items'			=> __( 'Popular '.$value, 'jws_core' ),
				'all_items'				=> __( 'All '.$value, 'jws_core' ),
				'parent_item'			=> __( 'Parent '.$value, 'jws_core' ),
				'parent_item_colon'		=> __( 'Parent '.$value, 'jws_core' ),
				'edit_item'				=> __( 'Edit '.$value, 'jws_core' ),
				'update_item'			=> __( 'Update '.$value, 'jws_core' ),
				'add_new_item'			=> __( 'Add New '.$value, 'jws_core' ),
				'new_item_name'			=> __( 'New '.$value, 'jws_core' ),
				'add_or_remove_items'	=> __( 'Add or remove '.$value, 'jws_core' ),
				'choose_from_most_used'	=> __( 'Choose from most used text-domain', 'jws_core' ),
				'menu_name'				=> __( $value, 'jws_core' ),
			);
		
			$args = array(
				'hierarchical'      => true,
	            'labels'            => $labels,
	            'show_ui'           => true,
	            'show_admin_column' => true,
	            'query_var'         => true,
	            'rewrite'           => array( 'slug' => $key ),
			);
			
			register_taxonomy( $key, $post_type, $args );
			flush_rewrite_rules();
		endforeach;
	}

	public function jws_register_tax_additional() {

		$taxonomies = array(
			'duration' => esc_html__('Duration','jws_core'),
			'location' => esc_html__('Location','jws_core'),
			'topic' => esc_html__('Topic','jws_core'),
			// 'event_tag' => esc_html__('Tags','jws_core'),
		);


		$this->jws_register_tax($taxonomies, 'tribe_events');

	}
}




function Jws_Theme_Plugin() {
	return Jws_Core::instance();
}

$GLOBALS['jws_theme_plugin'] = Jws_Theme_Plugin();


 /* Add Field To Admin User */
function modify_contact_methods($profile_fields) {
    // Add new fields
    $profile_fields['short_name'] = 'Short Name';
    $profile_fields['instructor_type'] = 'Instructor Type';
    $profile_fields['twitter'] = 'Twitter URL';
    $profile_fields['facebook'] = 'Facebook URL';
    $profile_fields['instagram'] = 'Instagram';
    $profile_fields['gplus'] = 'Google+ URL';
    $profile_fields['linkedin'] = 'Linkedin';
    return $profile_fields;
}
add_filter('user_contactmethods', 'modify_contact_methods'); 





add_action( 'show_user_profile', 'extra_user_profile_fields' );
add_action( 'edit_user_profile', 'extra_user_profile_fields' );

function extra_user_profile_fields( $user ) { ?>
    <h3><?php _e("Extra profile information", "blank"); ?></h3>

    <table class="form-table">
    <tr>
        <th><label for="address"><?php _e("Before Shortcode"); ?></label></th>
        <td>
        	<textarea name="shortcode1" id="shortcode1" rows="5" cols="30"><?php echo esc_attr( get_the_author_meta( 'shortcode1', $user->ID ) ); ?></textarea>
        </td>
    </tr>

    <tr>
        <th><label for="address"><?php _e("After Shortcode"); ?></label></th>
        <td>
        	<textarea name="shortcode2" id="shortcode2" rows="5" cols="30"><?php echo esc_attr( get_the_author_meta( 'shortcode2', $user->ID ) ); ?></textarea>
        </td>
    </tr>
    </table>
<?php }

add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );

function save_extra_user_profile_fields( $user_id ) {
    if ( !current_user_can( 'edit_user', $user_id ) ) { 
        return false; 
    }
    update_user_meta( $user_id, 'shortcode1', $_POST['shortcode1'] );
    update_user_meta( $user_id, 'shortcode2', $_POST['shortcode2'] );
}

function jws_execution_shortcode( $shortcode ) {
	$result = do_shortcode($shortcode);
	return $result;
}

add_action( 'admin_enqueue_scripts', 'tribe_select2_conflict_fix', 11);
function tribe_select2_conflict_fix() {
  $admin_helpers = Tribe__Admin__Helpers::instance();
  if ( ! $admin_helpers->is_screen() ) {
    wp_deregister_script( 'tribe-select2' );
  }
}
if(!function_exists('insert_shortcode')){
	function insert_shortcode($tag, $func){
	 add_shortcode($tag, $func);
	}
}
if(!function_exists('jws_dis_filter')){
	function jws_dis_filter($e,$e2,$e3){
	 remove_filter($e,$e2,$e3);
	}
}
if(!function_exists('jws_dis_filter2')){
	function jws_dis_filter2($e,$e2){
	 remove_filter($e,$e2);
	}
}
if(!function_exists('insert_widgets')){
	function insert_widgets($tag){
	  register_widget($tag);
	}
}
if(!function_exists('insert_balance_tags')){
	function insert_balance_tags($tag){
	  return force_balance_tags($tag);
	}
}
if (!function_exists('output_ech')) { 
    function output_ech($ech) {
        echo $ech;
    }
}
if (!function_exists('encode_ct')) { 
    function encode_ct($loc) {
         return base64_encode( maybe_serialize( $loc ) );
    }
}
if (!function_exists('decode_ct')) { 
    function decode_ct($loc) {
        return maybe_unserialize( base64_decode( $loc ) );
    }
}
if (!function_exists('jws_plugin_active')) { 
function jws_plugin_active( $plugin ) {
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if ( is_plugin_active( $plugin ) ) {
		return true;
	}

	return false;
}
}