<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
get_header(); 
if (function_exists('fw_get_db_settings_option')) {
	$general_settings = fw_get_db_settings_option();
}
?>
	<div id="primary" class="content-area">
		<div id="content" class="site-content main-content page-404" role="main">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12 al-center">
						<?php if (isset($general_settings['404_image']['url'])): ?>
							<div class="thumb">
								<img src="<?php if (isset($general_settings['404_image']['url'])) { echo esc_url($general_settings['404_image']['url']); } ?>" alt="<?php echo esc_attr( '404 Image', 'thebrilliance' ); ?>">
							</div>
						<?php endif; ?>
						<h1 class="page-title"><?php esc_html_e( 'This page not be found', 'thebrilliance' ); ?></h1>

						<div class="page-content">
							<p><?php esc_html_e( 'We are really sorry, but the page you requested is missing.. Perhaps searching again can help. Or back to ', 'thebrilliance' ); ?><a href="<?php echo esc_url( home_url() ); ?>"><?php esc_html_e( 'home page', 'thebrilliance' ); ?></a></p>

							<?php get_search_form(); ?>
						</div><!-- .page-content -->

					</div>
				</div>
			</div>

		</div><!-- #content -->
	</div><!-- #primary -->
<?php
get_footer();