<?php
if ( ! function_exists( 'jws_theme_comment' ) ) :
	/**
	 * Template for comments and pingbacks.
	 *
	 * To override this walker in a child theme without modifying the comments template
	 * simply create your own jws_theme_comment(), and that function will be used instead.
	 *
	 * Used as a callback by wp_list_comments() for displaying the comments.
	 *
	 */

	function jws_theme_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;

		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
				?>
				<li class="post pingback">

					<article id="li-comment-<?php comment_ID() ?>" class="comment-body">
						<p><?php esc_html_e( 'Pingback:', 'thebrilliance' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( esc_html__( 'Edit', 'thebrilliance' ), '<span class="edit-link">', '</span>' ); ?></p>
					</article>

				<?php
				break;
			default : ?>
			<li <?php comment_class('comment'); ?> id="li-comment-<?php comment_ID(); ?>">
				<!-- <a name="comment-<?php //comment_ID() ?>"></a> -->
				<div class="comment-body">
					<div class="comment-avatar">
						<div class="avatar"><?php echo get_avatar( $comment->comment_author_email, 90 ); ?></div>
						<?php comment_reply_link( array_merge( $args, array(
								'depth'     => $depth,
								'max_depth' => $args['max_depth'],
								'reply_text' => '<i class="fa fa-reply" aria-hidden="true"></i>',
							) ) ); ?>
					</div>

					<div class="comment-aside">
						<div class="comment-meta">
							<span class="comment-author">
								<span class="link-author"><?php echo get_comment_author(); ?></span>
							</span>

							<span class="comment-date"><span class="icon-calendar"></span><?php comment_date(); ?></span>
							<div class="position-rating">
								<div class="rating-element">
									<?php 
									if ( $rating = get_comment_meta( get_comment_ID(), 'rating', true ) ) {
										$stars = '<p class="stars-bg"><i class="fa fa-star-o" aria-hidden="true"></i><i class="fa fa-star-o" aria-hidden="true"></i><i class="fa fa-star-o" aria-hidden="true"></i><i class="fa fa-star-o" aria-hidden="true"></i><i class="fa fa-star-o" aria-hidden="true"></i></p>';
										$stars .= '<p class="stars">';
										for ( $i = 1; $i <= $rating; $i++ ) {
											$stars .= '<i class="fa fa-star" aria-hidden="true"></i>';
										}
										$stars .= '</p>';

										echo wp_kses_post($stars);
									}
									?>
								</div>
							</div>

						</div>
						<div class="comment-content">
							<p><?php echo wp_kses_post($comment->comment_content); ?></p>

							
						</div>
						<?php if ( $comment->comment_approved == '0' ) : ?>
							<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'thebrilliance' ); ?></em>
							<br/>
						<?php endif; ?>
					</div><!-- /.comment-aside -->

					<div id="comment-<?php comment_ID(); ?>"></div>
				</div><!-- /.comment-container -->
				<?php
				break;
		endswitch;
	}
endif; // ends check for jws_theme_comment()