<?php
if (defined( 'FW' )) {
	$post_setting = fw_get_db_settings_option('posts_settings');
}else{
	$post_setting = array(
		'post_author_box' => 'no',
		'post_navigation' => 'yes',
		'post_single_thumb' => 'yes',
		'post_title' => 'yes',
		'tags_and_socials' => 'no',
		'single_post_meta' => 'yes',
	);
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-thumbnail">
		<?php 
		if ($post_setting['post_single_thumb'] == 'yes')
		the_post_thumbnail('full');
		if ( $post_setting['post_title'] == 'yes') :
			the_title( '<h1 class="entry-title">', '</h1>' );
		endif;
		?>
	</div>

	<?php if ($post_setting['single_post_meta'] == 'yes'): ?>
		<div class="meta-post">
			<div class="author"><span class="icon-user"></span>
				<?php 
					$author = get_userdata( $post->post_author ); 
					echo '<a href="'.get_author_posts_url($post->post_author).'">'.esc_attr($author->display_name).'</a>';
				?> 
			</div>
			<div class="date-post">
				<span class="icon-calendar2"></span>
				<?php echo date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ); ?>
			</div>
		</div>
	<?php endif; ?>

	<?php echo jws_additional_content(); ?>

	<div class="entry-content">
		<?php
			the_content(esc_html__( 'Continue reading <span class="meta-nav">&rarr;</span>', 'thebrilliance' ) );
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'thebrilliance' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
		?>
	</div><!-- .entry-content -->
	<?php 
	if ($post_setting['post_author_box'] == 'yes'){
		echo jwstheme_author_render(); 
	}
	if ($post_setting['post_navigation'] == 'yes'){
		jws_theme_post_nav();
	}
	
	?>
</article><!-- #post-## -->
