<?php
if ( function_exists( 'fw_get_db_settings_option' ) ){
	$post_setting = fw_get_db_settings_option('posts_settings');
}else{
	$post_setting = array(
		'featured_image' => 'yes',
		'posts_layout' => 'column-1',
		'post_meta' => 'yes',
		'enabled_readmore' => 'yes',
		'readmore_text' => esc_html__('Read More','thebrilliance'),
	);
}

if(isset($_GET['posts_layout'])){
	$post_setting['posts_layout'] = $_GET['posts_layout'];
}

$arr_col = array(
	'column-1'  => 'col-md-12',
	'columns-2' => 'col-md-6',
	'columns-3' => 'col-md-4',
	'columns-4' => 'col-md-3',
);

$arr_thumb = array(
	'column-1'  => 'full',
	'columns-2' => 'jws-archive-post-2col',
	'columns-3' => 'jws-archive-post-3col',
	'columns-4' => 'jws-archive-post-4col',
);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class($arr_col[$post_setting['posts_layout']]); ?>>
	<div class="blog-image">
		<?php 
		$feature_post = '';
		$jws_thumbnail = 'jws-theme-full-width';
		if (function_exists('fw_get_db_post_option')) {
			$post_setting_meta = fw_get_db_post_option();
		}else{
			$post_setting_meta = array(
				'post_url' => '',
			);
		}
		
		$video = $post_setting_meta['post_url'];

		if ( !$video ){
			global $_wp_additional_image_sizes;

			$video_size = array( 
				'height' => $_wp_additional_image_sizes[$jws_thumbnail]['height']
			);

			if ( filter_var( $video, FILTER_VALIDATE_URL ) ) { 
				if ( $oembed = @wp_oembed_get( $video,$video_size ) )
					$feature_post .= $oembed;
			} else { 
				$feature_post = $video;
			}

			if ( $feature_post ){
				echo '<div class="post-video">' . $feature_post . '</div>';
			}else{
				the_post_thumbnail($arr_thumb[$post_setting['posts_layout']]);
			}
		}
	    switch (get_post_format()) {
	    	case 'video':
	    		$icon = '<i class="icon-video-camera"></i>';
	    		break;

	    	case 'gallery':
	    		$icon = '<i class="icon-images"></i>';
	    		break;

	    	case 'image':
	    		$icon = '<i class="icon-photo-camera2"></i>';
	    		break;

	    	case 'quote':
	    		$icon = '<i class="icon-quotes-left"></i>';
	    		break;
	    	
	    	default:
	    		$icon = '<i class="icon-file-text2"></i>';
	    		break;
	    }
	    ?>
	    <?php if (has_post_thumbnail()) : ?>
	    	<div class="thumb-format"><?php echo wp_kses_post($icon); ?></div>
	    <?php endif; ?>

	    <?php if ($post_setting['enabled_readmore'] == 'yes'): ?>
			<div class="readmore">
				<a href="<?php the_permalink(); ?> "><?php echo esc_html($post_setting['readmore_text']); ?><span class="lnr lnr-arrow-right"></span></a>
			</div>
		<?php endif; ?>

	</div>

	<div class="wrap-content">

		<?php 
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h1 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h1>' );
		endif; 
		?>

		<?php if ($post_setting['post_meta'] == 'yes'): ?>
			<div class="meta-post">
				<div class="author"><span class="icon-user"></span>
					<?php 
						$author = get_userdata( $post->post_author ); 
						echo '<a href="'.get_author_posts_url($post->post_author).'">'.esc_attr($author->display_name).'</a>';
					?> 
				</div>
				<div class="date-post"><span class="icon-calendar2"></span><?php echo date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ); ?></div>
			</div>
		<?php endif; ?>
		
		<div class="entry-content">
			<?php the_excerpt(); ?>
		</div><!-- .entry-content -->

		
	</div>

</article><!-- #post-## -->
