<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$jws_admin_url          = admin_url();
global $jws_color_settings;
$options = array(
	'main' => array(
		'title'   => false,
		'type'    => 'box',
		'options' => array(
			'media' => array(
				'title'   => esc_html__( 'Page Options', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'page_settings' => array(
						'type'    => 'multi',
						'label'   => false,
						'inner-options' => array(
							'enable_general_meta'   => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'selected_value' => array(
										'label'        => esc_html__( 'Enable General Options', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable the General options?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'no',
									)
								),
								'show_borders' => false,
								'choices'      => array(
									'yes' => array(

										'container_site_type'  => array(
											'type'    => 'multi-picker',
											'label'   => false,
											'desc'    => false,
											'picker'  => array(
												'selected' => array(
													'label'   => esc_html__( 'Website Boxed', 'thebrilliance' ),
													'desc'    => esc_html__( "Select your website's style", 'thebrilliance' ),
													'value'   => fw_get_db_settings_option( 'container_site_type/selected', 'fw-full' ),
													'type'    => 'image-picker',
													'choices' => array(
														'fw-full'       => array(
															'small' => array(
																'height' => 70,
																'src'    => JWS_URI_PATH . '/images/image-picker/full.jpg'
															),
															'large' => array(
																'height' => 214,
																'src'    => JWS_URI_PATH . '/images/image-picker/full.jpg'
															),
														),
														'fw-side-boxed' => array(
															'small' => array(
																'height' => 70,
																'src'    => JWS_URI_PATH . '/images/image-picker/side-boxed.jpg'
															),
															'large' => array(
																'height' => 214,
																'src'    => JWS_URI_PATH . '/images/image-picker/side-boxed.jpg'
															),
														),
													),
												),
											),
										),

										'website_background'   => array(
											'type'          => 'multi',
											'label'         => false,
											'inner-options' => array(
												'website_bg_color' => array(
													'label' => esc_html__( 'Website Background', 'thebrilliance' ),
													'desc'  => esc_html__( 'Select the website background color', 'thebrilliance' ),
													'value' => fw_get_db_settings_option( 'website_background/website_bg_color', '#fff' ),
													'type'  => 'color-picker',
												),
												'website_bg'       => array(
													'type'    => 'background-image',
													'value'   => 'none',

													'label'   => esc_html__( '', 'thebrilliance' ),
													'desc'    => esc_html__( 'Select the patern overlay', 'thebrilliance' ),
													'choices' => array(
														'none' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/no_pattern.jpg',
															'css'  => array(
																'background-image' => 'none'
															),
														),
														'bg-1' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/diagonal_bottom_to_top_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/diagonal_bottom_to_top_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-2' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/diagonal_top_to_bottom_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/diagonal_top_to_bottom_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-3' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/dots_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/dots_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-4' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/noise_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/noise_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-5' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/romb_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/romb_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-6' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/square_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/square_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-7' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/vertical_lines_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/vertical_lines_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
														'bg-8' => array(
															'icon' => JWS_URI_PATH . '/images/patterns/waves_pattern_preview.jpg',
															'css'  => array(
																'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/waves_pattern.png' . '")',
																'background-repeat' => 'repeat',
															)
														),
													)
												)
											)
										),


										'logo_settings'        => array(
											'type'          => 'multi',
											'label'         => false,
											'attr'          => array(
												'class' => 'fw-option-type-multi-show-borders',
											),
											'inner-options' => array(
												'logo' => array(
													'type'         => 'multi-picker',
													'label'        => false,
													'desc'         => false,
													'picker'       => array(
														'selected_value' => array(
															'label'   => esc_html__( 'Logo Type', 'thebrilliance' ),
															'desc'    => esc_html__( 'Select the logo type', 'thebrilliance' ),
															'attr'    => array( 'class' => 'fw-checkbox-float-left' ),
															'value'   => 'text',
															'type'    => 'radio',
															'choices' => array(
																'text'  => esc_html__( 'Text', 'thebrilliance' ),
																'image' => esc_html__( 'Image', 'thebrilliance' ),
															),
														)
													),
													'choices'      => array(
														'text'  => array(
															'title'              => array(
																'label' => esc_html__( 'Title', 'thebrilliance' ),
																'desc'  => esc_html__( 'Enter the title', 'thebrilliance' ),
																'type'  => 'short-text',
																'value' => get_bloginfo( 'name' )
															),

															'logo_title_font'              => array(
																'label' => '',
																'type'  => 'typography',
																'value' => array(
																	'size'           => 40,
																	'family' => 'Playfair Display',
																	'style'  => '900',
																	'color'  => '#000000'
																),
																'desc'  => esc_html__( 'Choose the title font', 'thebrilliance' ),
															),


														),
														'image' => array(
															'image_logo'  => array(
																'label' => esc_html__( '', 'thebrilliance' ),
																'desc'  => esc_html__( 'Upload logo image', 'thebrilliance' ),
																'type'  => 'upload'
															),
														),
													),
													'show_borders' => false,
												),
											),
										),
										

									),
									'no'  => array(),
								),
							),

							'enable_header_meta'   => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'selected_value' => array(
										'label'        => esc_html__( 'Enable Header Options', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable the header options?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'no',
									)
								),
								'show_borders' => false,
								'choices'      => array(
									'yes' => array(


										'header_group'     => array(
											'type'    => 'group',
											'options' => array(
												'header_type_picker'   => array(
													'type'         => 'multi-picker',
													'label'        => false,
													'desc'         => false,
													'picker'       => array(
														'header_type' => array(
															'label'   => esc_html__( 'Header Style', 'thebrilliance' ),
															'type'    => 'image-picker',
															'value'   => fw_get_db_settings_option( 'header_settings/header_type_picker/header_type', 'default' ),
															'desc'    => esc_html__( 'Select the prefered header type', 'thebrilliance' ),
															'choices' => array(
																'default' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-default.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-default.jpg'
																	),
																),
																'1' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type1.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type1.jpg'
																	),
																),
																'2' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type2.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type2.jpg'
																	),
																),
																'3' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type3.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type3.jpg'
																	),
																),
																'4' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type4.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type4.jpg'
																	),
																),
																'5' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type5.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type5.jpg'
																	),
																),
																'6' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type6.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type6.jpg'
																	),
																),
																'7' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type7.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type7.jpg'
																	),
																),
																'8' => array(
																	'small' => array(
																		'height' => 75,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type8.jpg'
																	),
																	'large' => array(
																		'height' => 214,
																		'src'    => JWS_URI_PATH . '/images/image-picker/header-type8.jpg'
																	),
																),
															),
														),
													),
													'choices'      => array(
													),
													'show_borders' => false,
												),

												'logo_text_color' => array(
													'label' => esc_html__( 'Logo text color', 'thebrilliance' ),
													'desc'  => esc_html__( 'Select the logo text color', 'thebrilliance' ),
													'value' => '#181818',
													'type'  => 'color-picker',
												),

												'header_menu' => array(
													'label' => esc_html__( 'Header Menu', 'thebrilliance' ),
													'type'  => 'typography',
													'value' => array(
														'size'   => 13,
														'family' => 'Comfortaa',
														'style'  => 'regular',
														'color'  => '#606060'
													),
												),
											)
										),

										'enable_top_bar'   => array(
											'type'         => 'multi-picker',
											'label'        => false,
											'desc'         => false,
											'picker'       => array(
												'selected_value' => array(
													'label'        => esc_html__( 'Top Bar', 'thebrilliance' ),
													'desc'         => esc_html__( 'Enable the header top bar?', 'thebrilliance' ),
													'type'         => 'switch',
													'right-choice' => array(
														'value' => 'yes',
														'label' => esc_html__( 'Yes', 'thebrilliance' )
													),
													'left-choice'  => array(
														'value' => 'no',
														'label' => esc_html__( 'No', 'thebrilliance' )
													),
													'value'        => fw_get_db_settings_option( 'header_settings/enable_top_bar/selected_value', 'no' ),
												)
											),
											'choices'      => array(
												'yes' => array(
													'top_bar_text'           => array(
														'type'    => 'wp-editor',
														'tinymce' => true,
														'reinit'  => true,
														'wpautop' => true,
														'editor_height' => 200,
														'media_buttons' => false,
														'value'   => fw_get_db_settings_option( 'header_settings/enable_top_bar/yes/top_bar_text', '' ),
														'label'   => esc_html__( 'Text', 'thebrilliance' ),
														'desc'    => esc_html__( 'This top bar text is usually used for an email address or phone no', 'thebrilliance' ),
													),
													'booking_btn'           => array(
														'type'    => 'wp-editor',
														'tinymce' => true,
														'reinit'  => true,
														'wpautop' => true,
														'editor_height' => 200,
														'media_buttons' => false,
														'value'   => fw_get_db_settings_option( 'header_settings/enable_top_bar/yes/booking_btn', '' ),
														'label'   => esc_html__( 'Booking Button', 'thebrilliance' ),
														'desc'    => esc_html__( 'This button text is usually used for an booking', 'thebrilliance' ),
													),


													
												),
												'no'  => array(),
											),
											'show_borders' => false,
										),

									),
									'no'  => array(),
								),
							),

							'enable_footer_meta'   => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'selected_value' => array(
										'label'        => esc_html__( 'Enable Footer Options', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable the Footer options?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'no',
									)
								),
								'show_borders' => false,
								'choices'      => array(

									'yes' => array(

										'footer_shortcode' => array(
											'label'   => esc_html__( 'Footer Shortcode', 'thebrilliance' ),
											'desc'    => esc_html__( 'Select a footer shortcode', 'thebrilliance' ),
											'help'    => esc_html__( 'The users will be redirected to this page when the page they are looking for is not found', 'thebrilliance' ),
											'value'   => fw_get_db_settings_option( 'footer_settings/footer_shortcode', '' ),
											'type'    => 'select',
											'choices' => jws_list_footers(),
										),

										'shortcode_before_footer' => array(
											'type'    => 'wp-editor',
											'tinymce' => true,
											'reinit'  => true,
											'wpautop' => true,
											'editor_height' => 200,
											'media_buttons' => false,
											'value'   => '',
											'label'   => esc_html__( 'Shortcode before footer', 'thebrilliance' ),
										),

										'footer_bg_image'            => array(
											'label' => esc_html__( 'Footer background Image', 'thebrilliance' ),
											'desc'  => esc_html__( 'Upload a background Image', 'thebrilliance' ),
											'type'  => 'upload'
										),

										'footer_bg_color' => array(
											'label' => esc_html__( 'Footer Background Color', 'thebrilliance' ),
											'desc'  => esc_html__( 'Footer Background Color', 'thebrilliance' ),
											'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
											'type'  => 'color-picker',
											'value' => '#000000',
										),

										'footer_text_color' => array(
											'label' => esc_html__( 'Footer Text Color', 'thebrilliance' ),
											'desc'  => esc_html__( 'Footer Text Color', 'thebrilliance' ),
											'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
											'type'  => 'color-picker',
											'value' => '#606060',
										),


									),

									'no'  => array(),
								),
							),




							'enable_color_meta'   => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'selected_value' => array(
										'label'        => esc_html__( 'Enable Color Options', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable the Color options?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'no',
									)
								),
								'show_borders' => false,
								'choices'      => array(
									'yes' => array(

										'primary_color' => array(
											'label' => esc_html__( 'Color Schema', 'thebrilliance' ),
											'desc'  => esc_html__( 'Primary Color', 'thebrilliance' ),
											'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
											'type'  => 'color-picker',
											'value' => fw_get_db_settings_option( 'color_settings/primary_color', '#02c873' ),
										),

										'secondary_color' => array(
											'label' => esc_html__( '', 'thebrilliance' ),
											'desc'  => esc_html__( 'Secondary Color', 'thebrilliance' ),
											'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
											'type'  => 'color-picker',
											'value' => fw_get_db_settings_option( 'color_settings/secondary_color', '#2d5cde' ),
										),
									),
									'no'  => array(),
								),
							),
							'enable_fullpage'     => array(
								'type'         => 'switch',
								'value'        => 'no',
								'label'        => esc_html__( 'Enable Full Page', 'thebrilliance' ),
								'desc'         => esc_html__( 'Turn on/off Full Page', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => 'no',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),

							'css_inline'                  => array(
								'label' => esc_html__( 'Style Inline', 'thebrilliance' ),
								'type'  => 'textarea',
								'value' => '',
							),
						),
					),
				),
			),
		),
	),
);