<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Framework options
 *
 * @var array $options Fill this array with options to generate framework settings form in backend
 */
global $jws_colors, $jws_typography, $jws_admin_url, $jws_color_settings, $jws_typography_settings;

$jws_products_tab =	 array();

if ( class_exists( 'WooCommerce' ) ) {
	$jws_products_tab = fw()->theme->get_options( 'products-tab' );
}

$jws_colors             = array();
$jws_typography          = array(
	'primary_color' => '#02c873',
	'secondary_color' => '#2d5cde'
);
$jws_admin_url           = admin_url();
$jws_color_settings      = fw_get_db_settings_option( 'color_settings', $jws_colors );
$jws_typography_settings = fw_get_db_settings_option( 'typography_settings', $jws_typography );
$options = array(
	'general'        => array(
		'title'   => esc_html__( 'General', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'general-options' => array(
				'title'   => esc_html__( 'General', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'general-box' => array(
						'title'   => esc_html__( 'Global Settings', 'thebrilliance' ),
						'type'    => 'box',
						'options' => array(
							'enable_less'          => array(
								'type'         => 'switch',
								'value'        => 'no',
								'label'        => esc_html__( 'Enable Less', 'thebrilliance' ),
								'desc'         => esc_html__( 'Turn on/off less mode', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => 'no',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),

							// 'enable_rtl'          => array(
							// 	'type'         => 'switch',
							// 	'value'        => 'no',
							// 	'label'        => esc_html__( 'Enable Right to Left', 'thebrilliance' ),
							// 	'desc'         => esc_html__( 'Turn on/off right to left mode', 'thebrilliance' ),
							// 	'left-choice'  => array(
							// 		'value' => 'no',
							// 		'label' => esc_html__( 'No', 'thebrilliance' ),
							// 	),
							// 	'right-choice' => array(
							// 		'value' => 'yes',
							// 		'label' => esc_html__( 'Yes', 'thebrilliance' ),
							// 	),
							// ),

							'container_site_type'  => array(
								'type'    => 'multi-picker',
								'label'   => false,
								'desc'    => false,
								'picker'  => array(
									'selected' => array(
										'label'   => esc_html__( 'Website Boxed', 'thebrilliance' ),
										'desc'    => esc_html__( "Select your website's style", 'thebrilliance' ),
										'value'   => 'fw-full',
										'type'    => 'image-picker',
										'choices' => array(
											'fw-full'       => array(
												'small' => array(
													'height' => 70,
													'src'    => JWS_URI_PATH . '/images/image-picker/full.jpg'
												),
												'large' => array(
													'height' => 214,
													'src'    => JWS_URI_PATH . '/images/image-picker/full.jpg'
												),
											),
											'fw-side-boxed' => array(
												'small' => array(
													'height' => 70,
													'src'    => JWS_URI_PATH . '/images/image-picker/side-boxed.jpg'
												),
												'large' => array(
													'height' => 214,
													'src'    => JWS_URI_PATH . '/images/image-picker/side-boxed.jpg'
												),
											),
										),
									),
								),
								'choices' => array(
									'fw-side-boxed' => array(
										
									)
								)
							),
							'website_background'   => array(
								'type'          => 'multi',
								'label'         => false,
								'inner-options' => array(
									'website_bg_color' => array(
										'label' => esc_html__( 'Website Background', 'thebrilliance' ),
										'desc'  => esc_html__( 'Select the website background color', 'thebrilliance' ),
										'value' => '#fff',
										'type'  => 'color-picker',
									),
									'website_bg'       => array(
										'type'    => 'background-image',
										'value'   => 'none',
										'label'   => esc_html__( '', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select the patern overlay', 'thebrilliance' ),
										'choices' => array(
											'none' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/no_pattern.jpg',
												'css'  => array(
													'background-image' => 'none'
												),
											),
											'bg-1' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/diagonal_bottom_to_top_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/diagonal_bottom_to_top_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-2' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/diagonal_top_to_bottom_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/diagonal_top_to_bottom_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-3' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/dots_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/dots_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-4' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/noise_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/noise_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-5' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/romb_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/romb_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-6' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/square_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/square_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-7' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/vertical_lines_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/vertical_lines_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
											'bg-8' => array(
												'icon' => JWS_URI_PATH . '/images/patterns/waves_pattern_preview.jpg',
												'css'  => array(
													'background-image'  => 'url("' . JWS_URI_PATH . '/images/patterns/waves_pattern.png' . '")',
													'background-repeat' => 'repeat',
												)
											),
										)
									)
								)
							),
							'favicon'            => array(
								'label' => esc_html__( 'Favicon', 'thebrilliance' ),
								'desc'  => esc_html__( 'Upload a favicon', 'thebrilliance' ),
								'type'  => 'upload'
							),
							'logo_settings'        => array(
								'type'          => 'multi',
								'label'         => false,
								'attr'          => array(
									'class' => 'fw-option-type-multi-show-borders',
								),
								'inner-options' => array(
									'logo' => array(
										'type'         => 'multi-picker',
										'label'        => false,
										'desc'         => false,
										'picker'       => array(
											'selected_value' => array(
												'label'   => esc_html__( 'Logo Type', 'thebrilliance' ),
												'desc'    => esc_html__( 'Select the logo type', 'thebrilliance' ),
												'attr'    => array( 'class' => 'fw-checkbox-float-left' ),
												'value'   => 'text',
												'type'    => 'radio',
												'choices' => array(
													'text'  => esc_html__( 'Text', 'thebrilliance' ),
													'image' => esc_html__( 'Image', 'thebrilliance' ),
												),
											)
										),
										'choices'      => array(
											'text'  => array(
												'title'              => array(
													'label' => esc_html__( 'Title', 'thebrilliance' ),
													'desc'  => esc_html__( 'Enter the title', 'thebrilliance' ),
													'type'  => 'short-text',
													'value' => get_bloginfo( 'name' )
												),

												'logo_title_font'              => array(
													'label' => '',
													'type'  => 'typography',
													'value' => array(
														'size'           => 40,
														'family' => 'Playfair Display',
														'style'  => '900',
														'color'  => '#000000'
													),
													'desc'  => esc_html__( 'Choose the title font', 'thebrilliance' ),
												),


											),
											'image' => array(
												'image_logo'  => array(
													'label' => esc_html__( '', 'thebrilliance' ),
													'desc'  => esc_html__( 'Upload logo image', 'thebrilliance' ),
													'type'  => 'upload'
												),
											),
										),
										'show_borders' => false,
									),
								),
							),
							
							'logo_mobile'            => array(
								'label' => esc_html__( 'Logo Mobile', 'thebrilliance' ),
								'desc'  => esc_html__( 'Upload Logo Mobile', 'thebrilliance' ),
								'type'  => 'upload'
							),
							'404_image'            => array(
								'label' => esc_html__( '404 Image', 'thebrilliance' ),
								'desc'  => esc_html__( 'Upload 404 Image', 'thebrilliance' ),
								'type'  => 'upload'
							),
							'scroll_to_top_group'      => array(
								'type'    => 'group',
								'options' => array(
									
									'enable_scroll_to' => array(
										'type'         => 'switch',
										'value'        => 'no',
										'label'        => esc_html__( 'Scroll to Top Button', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable scroll to top?', 'thebrilliance' ),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										)
									),
								)
							),
                            
						)
					),
				)
			),
			'social-options'  => array(
				'title'   => esc_html__( 'Social Profiles', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'social-box' => array(
						'title'   => esc_html__( 'Social', 'thebrilliance' ),
						'type'    => 'box',
						'options' => array(
							'socials' => array(
								'type'          => 'addable-popup',
								'label'         => esc_html__( 'Social Links', 'thebrilliance' ),
								'desc'          => esc_html__( 'Add your social profiles', 'thebrilliance' ),
								'template'      => '{{=social_name}}',
								'popup-options' => array(
									'social_name' => array(
										'label' => esc_html__( 'Name', 'thebrilliance' ),
										'desc'  => esc_html__( 'Enter a name (it is for internal use and will not appear on the front end)', 'thebrilliance' ),
										'type'  => 'text',
									),
									'social_type' => array(
										'type'    => 'multi-picker',
										'label'   => false,
										'desc'    => false,
										'picker'  => array(
											'social-type' => array(
												'label'   => esc_html__( 'Icon', 'thebrilliance' ),
												'desc'    => esc_html__( 'Select social icon type', 'thebrilliance' ),
												'attr'    => array( 'class' => 'fw-checkbox-float-left' ),
												'type'    => 'radio',
												'value'   => 'icon-social',
												'choices' => array(
													'icon-social' => esc_html__( 'Font Awesome', 'thebrilliance' ),
													'upload-icon' => esc_html__( 'Custom Upload', 'thebrilliance' ),
												),
											),
										),
										'choices' => array(
											'icon-social' => array(
												'icon_class' => array(
													'type'  => 'icon',
													'value' => 'fa fa-adn',
													'label' => '',
												),
											),
											'upload-icon' => array(
												'upload-social-icon' => array(
													'label' => '',
													'type'  => 'upload',
												)
											),
										)
									),
									'social-link' => array(
										'label' => esc_html__( 'Link', 'thebrilliance' ),
										'desc'  => esc_html__( 'Enter your social URL link', 'thebrilliance' ),
										'type'  => 'text',
									)
								),
							),
						)
					),
				)
			),
		),
	),







	'posts'          => array(
		'title'   => esc_html__( 'Posts', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'blog-posts' => array(
				'title'   => esc_html__( 'Blog', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'posts-box'        => array(
						'title'   => esc_html__( 'Posts Archive', 'thebrilliance' ),
						'type'    => 'box',
						'options' => array(
							'posts_settings' => array(
								'type'          => 'multi',
								'label'         => false,
								'attr'          => array(
									'class' => 'fw-option-type-multi-show-borders',
								),
								'inner-options' => array(

									'posts_layout'          => array(
										'label'   => esc_html__( 'Posts Layout', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Columns Posts Layout', 'thebrilliance' ),
										'value'   => '',
										'type'    => 'select',
										'choices' => array(
											'column-1'  => esc_html__( '1 Column', 'thebrilliance' ),
											'columns-2' => esc_html__( '2 Columns', 'thebrilliance' ),
											'columns-3' => esc_html__( '3 Columns', 'thebrilliance' ),
											'columns-4' => esc_html__( '4 Columns', 'thebrilliance' ),
										),
									),
									
									'featured_image'          => array(
										'type'         => 'switch',
										'value'        => 'yes',
										'label'        => esc_html__( 'Featured Image', 'thebrilliance' ),
										'desc'         => esc_html__( 'Use featured image in single post?', 'thebrilliance' ),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										),
										// 'help'         => esc_html__( 'Your choice will not apply to posts that are already published, but it will set the default value for image roundness when you create new posts.', 'thebrilliance' ),
									),
									
									'post_meta'             => array(
										'label'        => esc_html__( 'Post Meta', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show post meta?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),

									'enabled_readmore'             => array(
										'label'        => esc_html__( 'Enabled Readmore', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show post Readmore?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),

									'readmore_text' => array(
										'label' => esc_html__( 'Readmore Text', 'thebrilliance' ),
										'desc'  => esc_html__( "Input Readmore Text ", 'thebrilliance' ),
										'type'  => 'short-text',
										'value' =>  esc_html__( 'Readmore', 'thebrilliance' ),
									),

								
									'posts_excerpt_length' => array(
										'label' => esc_html__( 'Post Excerpt Length', 'thebrilliance' ),
										'desc'  => esc_html__( "Input length of post excerpt ", 'thebrilliance' ),
										'type'  => 'short-text',
										'value' => '35',
									),


									'posts_pagination'          => array(
										'label'   => esc_html__( 'Posts Pagination', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Posts Pagination', 'thebrilliance' ),
										'value'   => 'numeric',
										'type'    => 'select',
										'choices' => array(
											'numeric' => esc_html__( 'Numeric', 'thebrilliance' ),
											'loadmore' => esc_html__( 'Loadmore', 'thebrilliance' ),
										),
									),

									



									'post-single-box' => array(
										'title'   => esc_html__( 'Post Single', 'thebrilliance' ),
										'type'    => 'box',
										'options' => array(
											'post_single_group'              => array(
												'type'    => 'group',
												'attr'    => array('class' => 'border-bottom-none'),
												'options' => array(


													'post_single_thumb'          => array(
														'type'         => 'switch',
														'value'        => 'yes',
														'label'        => esc_html__( 'Post Thumbnail', 'thebrilliance' ),
														// 'desc'         => esc_html__( 'Use featured image in single post?', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show post Thumbnail?', 'thebrilliance' ),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' ),
														),
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' ),
														),
														// 'help'         => esc_html__( 'Your choice will not apply to posts that are already published, but it will set the default value for image roundness when you create new posts.', 'thebrilliance' ),
													),

													'post_title'       => array(
														'label'        => esc_html__( 'Post Title', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show post title?', 'thebrilliance' ),
														'type'         => 'switch',
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' ),
														),
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' ),
														),
                                                        	'value'        => 'yes',
													),

													'single_post_meta'             => array(
														'label'        => esc_html__( 'Post Meta', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show post meta?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'yes',
													),


													'post_author_box'         => array(
														'label'        => esc_html__( 'Author Box', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show author box?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'no',
													),

												)
											),
										)
									),

									'post_navigation'         => array(
										'label'        => esc_html__( 'Post Navigation', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show post navigation?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),

									'related_articles'        => array(
										'label'        => esc_html__( 'Related Articles', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show related articles?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),


									'related_columns'          => array(
										'label'   => esc_html__( 'Related Columns', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Related Columns', 'thebrilliance' ),
										'value'   => '3',
										'type'    => 'select',
										'choices' => array(
											'2' => esc_html__( '2 Columns', 'thebrilliance' ),
											'3' => esc_html__( '3 Columns', 'thebrilliance' ),
											'4' => esc_html__( '4 Columns', 'thebrilliance' ),
										),
									),

									'related_style'          => array(
										'label'   => esc_html__( 'Posts Related Style', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Related Style', 'thebrilliance' ),
										'value'   => 'grid',
										'type'    => 'select',
										'choices' => array(
											'grid' => esc_html__( 'Grid', 'thebrilliance' ),
											'carousel' => esc_html__( 'Carousel', 'thebrilliance' ),
										),
									),

								)
							),
						)
					),
				)
			),
		)
	),

	'pages' => array(
		'title' => esc_html__('Pages', 'thebrilliance'),
		'type' => 'tab',
		'options' => array(
			'page-box' => array(
				'title' => esc_html__('Pages', 'thebrilliance'),
				'type' => 'box',
				'options' => array(
					'general_page' => array(
						'type' => 'multi',
						'label' => false,
						'attr' => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(

							'show_title'          => array(
								'type'         => 'switch',
								'value'        => 'yes',
								'label'        => esc_html__( 'Show Title', 'thebrilliance' ),
								'desc'         => esc_html__( 'Use title in page?', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => 'no',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),


							'page_sidebar'               => array(
								'type'    => 'image-picker',
								'label'   => esc_html__( 'Page Sidebar', 'thebrilliance' ),
								'desc'    => esc_html__( 'Select the page sidebar display style', 'thebrilliance' ),
								'value'   => 'full-width',
								'choices' => array(
									'full-width' => array(
										'small' => array(
											'height' => 70,
											'src'    => JWS_URI_PATH . '/images/image-picker/full-width.png'
										),
										'large' => array(
											'height' => 214,
											'src'    => JWS_URI_PATH . '/images/image-picker/full-width.png'
										),
									),
									'sidebar-left' => array(
										'small' => array(
											'height' => 70,
											'src'    => JWS_URI_PATH . '/images/image-picker/left-sidebar.png'
										),
										'large' => array(
											'height' => 214,
											'src'    => JWS_URI_PATH . '/images/image-picker/left-sidebar.png'
										),
									),
									'sidebar-right' => array(
										'small' => array(
											'height' => 70,
											'src'    => JWS_URI_PATH . '/images/image-picker/right-sidebar.png'
										),
										'large' => array(
											'height' => 214,
											'src'    => JWS_URI_PATH . '/images/image-picker/right-sidebar.png'
										),
									),
								),
							),
						)
					)
				)
			),
		)
	),

	'bc_and_oh'          => array(
		'title'   => esc_html__( 'BC and OH', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'overlay_header_box' => array(
				'title'   => esc_html__( 'Breadcrumb and Overlay Header', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'general_bc_and_oh' => array(
						'type'          => 'multi',
						'label'         => false,
						'attr'          => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(
							'overlay_header_height'           => array(
								'label'   => esc_html__( 'Header Height', 'thebrilliance' ),
								'type'    => 'radio-text',
								'value'   => 'fw-section-height-md',
								'choices' => array(
									'fw-section-height-sm' => esc_html__( 'small', 'thebrilliance' ),
									'fw-section-height-md' => esc_html__( 'medium', 'thebrilliance' ),
									'fw-section-height-lg' => esc_html__( 'large', 'thebrilliance' ),
								),
								'custom'  => 'custom_width',
							),
							'overlay_header_image'            => array(
								'label' => esc_html__( 'Header Image', 'thebrilliance' ),
								'desc'  => esc_html__( 'Upload a header image', 'thebrilliance' ),
								'help'  => esc_html__( "This default header image will be used for all your posts if you didn't set one for a specific post.", 'thebrilliance' ),
								'type'  => 'upload'
							),
							'overlay_header_options'  => array(
								'type'    => 'multi-picker',
								'label'   => false,
								'desc'    => false,
								'picker'  => array(
									'header_overlay' => array(
										'type'         => 'switch',
										'label'        => esc_html__( 'Overlay Color', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable image overlay color?', 'thebrilliance' ),
										'value'        => 'no',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
									),
								),
								'choices' => array(
									'no'  => array(),
									'yes' => array(
										'overlay_color'         => array(
											'label'   => esc_html__( '', 'thebrilliance' ),
											'desc'    => esc_html__( 'Select the image overlay color', 'thebrilliance' ),
											'help'    => esc_html__( 'The default color palette can be changed from the', 'thebrilliance' ) . ' <a target="_blank" href="' . $jws_admin_url . 'themes.php?page=fw-settings&_focus_tab=fw-options-tab-colors_tab">' . esc_html__( 'Colors section', 'thebrilliance' ) . '</a> ' . esc_html__( 'found in the Theme Settings page', 'thebrilliance' ),
											'value'   => '',
											'type'  => 'color-picker',
										),
										'overlay_opacity_image' => array(
											'type'       => 'slider',
											'value'      => 80,
											'properties' => array(
												'min' => 0,
												'max' => 100,
												'sep' => 1,
											),
											'label'      => esc_html__( '', 'thebrilliance' ),
											'desc'       => esc_html__( 'Select the overlay color opacity in %', 'thebrilliance' ),
										)
									),
								),
							),

							'enabled_breadcrumb'          => array(
								'type'         => 'switch',
								'value'        => 'no',
								'label'        => esc_html__( 'Show Breadcrumb', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => 'no',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),
							'breadcrumb_separator' => array(
								'label' => esc_html__( 'Breadcrumb Separator', 'thebrilliance' ),
								'type'  => 'short-text',
								'value' => '/',
							),
							'breadcrumb_text_color' => array(
								'label' => esc_html__( 'Breadcrumb Text Color', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#606060',
							),
							'breadcrumb_link_color' => array(
								'label' => esc_html__( 'Breadcrumb Link Color', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#606060',
							),
							
						)
					)
				)
			),
		)
	),
	'header'         => array(
		'title'   => esc_html__( 'Header', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'footer-box' => array(
				'title'   => esc_html__( 'Header', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'header_settings' => array(
						'type'          => 'multi',
						'label'         => false,
						'attr'          => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(
							'header_group'            => array(
								'type'    => 'group',
								'options' => array(
									'header_type_picker'   => array(
										'type'         => 'multi-picker',
										'label'        => false,
										'desc'         => false,
										'picker'       => array(
											'header_type' => array(
												'label'   => esc_html__( 'Header Style', 'thebrilliance' ),
												'type'    => 'image-picker',
												'value'   => 'default',
												'desc'    => esc_html__( 'Select the prefered header type', 'thebrilliance' ),
												'choices' => array(
													'default' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-default.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-default.jpg'
														),
													),
													'1' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type1.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type1.jpg'
														),
													),
													'2' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type2.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type2.jpg'
														),
													),
													'3' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type3.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type3.jpg'
														),
													),
													'4' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type4.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type4.jpg'
														),
													),
													'5' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type5.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type5.jpg'
														),
													),
													'6' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type6.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type6.jpg'
														),
													),
													'7' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type7.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type7.jpg'
														),
													),
													'8' => array(
														'small' => array(
															'height' => 75,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type8.jpg'
														),
														'large' => array(
															'height' => 214,
															'src'    => JWS_URI_PATH . '/images/image-picker/header-type8.jpg'
														),
													),
												),
											),
										),
										'choices'      => array(
										),
										'show_borders' => false,
									),
									'header_bg_color'      => array(
										'label'   => esc_html__( 'Background Color', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select header background color', 'thebrilliance' ),
										'value'   => '#222222',
										'type'  => 'color-picker',
									),
									'dropdown_bg_color'    => array(
										'label'   => esc_html__( 'Dropdown Bg Color', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select the dropdown background color', 'thebrilliance' ),
										'value'   => '#fff',
										'type'    => 'color-picker'
									),
									'dropdown_links_color' => array(
										'label'   => esc_html__( 'Dropdown Links Color', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select the dropdown links color', 'thebrilliance' ),
										'value'   => '#222222',
										'type'    => 'color-picker'
									),
								)
							),
							
							'enable_sticky_header'    => array(
								'type'         => 'switch',
								'value'        => '',
								'attr'         => array(),
								'label'        => esc_html__( 'Sticky Header', 'thebrilliance' ),
								'desc'         => esc_html__( 'Make the header stick with the scroll?', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'fw-header-sticky',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),
							'enable_top_bar'   => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'selected_value' => array(
										'label'        => esc_html__( 'Top Bar', 'thebrilliance' ),
										'desc'         => esc_html__( 'Enable the header top bar?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'no',
									)
								),
								'choices'      => array(
									'yes' => array(
										'top_bar_text'           => array(
											'type'    => 'wp-editor',
											'tinymce' => true,
											'reinit'  => true,
											'wpautop' => true,
											'editor_height' => 200,
											'media_buttons' => false,
											'value'   => '<ul class="topbar-text">
											<li><i class="fa fa-phone" aria-hidden="true"></i>Hotline  0125478963</li>
											<li><i class="fa fa-envelope" aria-hidden="true"></i>info@thebrilliance.com</li></ul>',
											'label'   => esc_html__( 'Text', 'thebrilliance' ),
											'desc'    => esc_html__( 'This top bar text is usually used for an email address or phone no', 'thebrilliance' ),
										),
										'booking_btn'           => array(
											'type'    => 'wp-editor',
											'tinymce' => true,
											'reinit'  => true,
											'wpautop' => true,
											'editor_height' => 200,
											'media_buttons' => false,
											'value'   => '<a href="#" class="btn-booking">REQUEST FOR QUOTE</a><div class="bg-shape"></div>',
											'label'   => esc_html__( 'Booking Button', 'thebrilliance' ),
											'desc'    => esc_html__( 'This button text is usually used for an booking', 'thebrilliance' ),
										),
										'enable_header_socials' => array(
											'type'         => 'multi-picker',
											'label'        => false,
											'desc'         => false,
											'picker'       => array(
												'selected_value' => array(
													'label'        => esc_html__( 'Social Icons', 'thebrilliance' ),
													'desc'         => esc_html__( 'Enable social icons?', 'thebrilliance' ),
													'help'         => sprintf( "%s", esc_html__( 'Your social links can be set from the', 'thebrilliance' ) . ' <a target="_blank" href="' . $jws_admin_url . 'themes.php?page=fw-settings#fw-options-tab-social-options">' . esc_html__( 'Social Profiles', 'thebrilliance' ) . '</a> ' . esc_html__( 'section under the General tab.', 'thebrilliance' ) ),
													'type'         => 'switch',
													'right-choice' => array(
														'value' => 'yes',
														'label' => esc_html__( 'Yes', 'thebrilliance' )
													),
													'left-choice'  => array(
														'value' => 'no',
														'label' => esc_html__( 'No', 'thebrilliance' )
													),
													'value'        => 'yes',
												)
											),
										),
									),
									'no'  => array(),
								),
								'show_borders' => false,
							),
                            
							'login_social_popup'          => array(
										'label' => esc_html__( 'Add Shortcode Social Popup', 'thebrilliance' ),
										'desc'  => esc_html__( 'Please enter the shortocde text', 'thebrilliance' ),
										'type'  => 'textarea',
										'value' => '[miniorange_social_login shape="longbuttonwithtext" theme="default" space="4" width="300" height="50" color="000000"]',
							),
						)
					)
				)
			)
		)
	),
	'footer'         => array(
		'title'   => esc_html__( 'Footer', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'footer-box' => array(
				'title'   => esc_html__( 'Footer', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'footer_settings' => array(
						'type'          => 'multi',
						'label'         => false,
						'attr'          => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(
							
							'footer_shortcode'          => array(
								'label'   => esc_html__( 'Footer Shortcode', 'thebrilliance' ),
								'desc'    => esc_html__( 'Select a footer shortcode', 'thebrilliance' ),
								'help'    => esc_html__( 'The users will be redirected to this page when the page they are looking for is not found', 'thebrilliance' ),
								'value'   => '',
								'type'    => 'select',
								'choices' => jws_list_footers(),
							),

							'copyright_group'     => array(
								'type'    => 'group',
								'attr'    => array( 'class' => 'border-bottom-none' ),
								'options' => array(
									'copyright'          => array(
										'label' => esc_html__( 'Copyright', 'thebrilliance' ),
										'desc'  => esc_html__( 'Please enter the copyright text', 'thebrilliance' ),
										'type'  => 'textarea',
										'value' => 'Copyright &copy; RavoRes 2018. All Right Reserved',
									),
									
								)
							),

							'footer_bg_color' => array(
								'label' => esc_html__( 'Footer Background Color', 'thebrilliance' ),
								'desc'  => esc_html__( 'Footer Background Color', 'thebrilliance' ),
								'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#000000',
							),

							'footer_bg_image'            => array(
								'label' => esc_html__( 'Footer background Image', 'thebrilliance' ),
								'desc'  => esc_html__( 'Upload a background Image', 'thebrilliance' ),
								'type'  => 'upload'
							),

							'footer_text_color' => array(
								'label' => esc_html__( 'Footer Text Color', 'thebrilliance' ),
								'desc'  => esc_html__( 'Footer Text Color', 'thebrilliance' ),
								'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#606060',
							),

							'shortcode_before_footer' => array(
								'type'    => 'wp-editor',
								'tinymce' => true,
								'reinit'  => true,
								'wpautop' => true,
								'editor_height' => 200,
								'media_buttons' => false,
								'value'   => '',
								'label'   => esc_html__( 'Shortcode before footer', 'thebrilliance' ),
							),
						)
					)
				)
			),
		)
	),
	'colors_tab'     => array(
		'title'   => esc_html__( 'Colors', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'colors-box' => array(
				'title'   => esc_html__( 'Colors', 'thebrilliance' ),
				'type'    => 'box',
				'attr'    => array( 'class' => 'fw-color-picker-palette' ),
				'options' => array(
					'color_settings'   => array(
						'type'          => 'multi',
						'label'         => false,
						'inner-options' => array(
							'primary_color' => array(
								'label' => esc_html__( 'Color Schema', 'thebrilliance' ),
								'desc'  => esc_html__( 'Primary Color', 'thebrilliance' ),
								'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#02c873',
							),
							'secondary_color' => array(
								'label' => esc_html__( '', 'thebrilliance' ),
								'desc'  => esc_html__( 'Secondary Color', 'thebrilliance' ),
								'help'  => esc_html__( 'This color affects different elements across the website. Note that changing this color will also change the default color in all the options across the admin.', 'thebrilliance' ),
								'type'  => 'color-picker',
								'value' => '#2d5cde',
							),
							
						)
					),
				)
			),
		)
	),
	'typography_tab' => array(
		'title'   => esc_html__( 'Typography', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'typography-box' => array(
				'title'   => esc_html__( 'Typography', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'typography_settings' => array(
						'type'          => 'multi',
						'label'         => false,
						'attr'          => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(

							'h1' 	=> array(
								'label' => esc_html__( 'H1', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 60,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),

							'h2' 	=> array(
								'label' => esc_html__( 'H2', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 36,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),

							'h3' 	=> array(
								'label' => esc_html__( 'H3', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 28,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),

							'h4' 	=> array(
								'label' => esc_html__( 'H4', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 24,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),

							'h5' 	=> array(
								'label' => esc_html__( 'H5', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 18,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),


							'h6' 	=> array(
								'label' => esc_html__( 'H6', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 14,
									'family' => 'Poppins',
									'style'  => '600',
									'color'  => '#000000'
								),
							),

							'body_text' => array(
								'label' => esc_html__( 'Body Text', 'thebrilliance' ),
								'type'  => 'typography',
								'value' => array(
									'size'   => 14,
									'family' => 'Poppins',
									'style'  => '400',
									'color'  => '#8f8f8f'
								),
							),
							
							'header-typography-box' => array(
								'title'   => esc_html__( 'Header', 'thebrilliance' ),
								'type'    => 'box',
								'options' => array(
									'header_menu_group'              => array(
										'type'    => 'group',
										'attr'    => array('class' => 'border-bottom-none'),
										'options' => array(

											'header_menu' => array(
												'label' => esc_html__( 'Header Menu', 'thebrilliance' ),
												'type'  => 'typography',
												'value' => array(
													'size'   => 13,
													'family' => 'Poppins',
													'style'  => 'regular',
													'color'  => '#fff'
												),
											),

											'header_menu_hover' => array(
												'label'   => esc_html__( 'Header Menu Hover', 'thebrilliance' ),
												'desc'    => esc_html__( 'Select the menu items hover color', 'thebrilliance' ),
												'value'   => '#02c873',
												'type'  => 'color-picker'
											)
										)
									),
								)
							),
						)
					)
				)
			),
		)
	),



	'course_tab'  => array(
		'title'   => esc_html__( 'Courses', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'course-posts' => array(
				'title'   => esc_html__( 'Courses', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'course-box'        => array(
						'title'   => esc_html__( 'Courses Archive', 'thebrilliance' ),
						'type'    => 'box',
						'options' => array(
							'course_settings' => array(
								'type'          => 'multi',
								'label'         => false,
								'attr'          => array(
									'class' => 'fw-option-type-multi-show-borders',
								),
								'inner-options' => array(

									'archive_course_layout'          => array(
										'label'   => esc_html__( 'Courses Archive Layout', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Course Archive Layout', 'thebrilliance' ),
										'value'   => '3',
										'type'    => 'select',
										'choices' => array(
											'1' => esc_html__( 'Column List Inline', 'thebrilliance' ),
											'2' => esc_html__( '2 Columns', 'thebrilliance' ),
											'3' => esc_html__( '3 Columns', 'thebrilliance' ),
											'4' => esc_html__( '4 Columns', 'thebrilliance' ),
										),
									),

									'archive_course_pagination'          => array(
										'label'   => esc_html__( 'Course Archive Pagination', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Course Archive Pagination', 'thebrilliance' ),
										'value'   => 'numeric',
										'type'    => 'select',
										'choices' => array(
											'numeric' => esc_html__( 'Numeric', 'thebrilliance' ),
											'loadmore' => esc_html__( 'Loadmore', 'thebrilliance' ),
										),
									),

									'archive_course_limit_posts' => array(
										'label' => esc_html__( 'Post Per Page ', 'thebrilliance' ),
										'type'  => 'short-text',
										'value' => '6',
									),


									'archive_course_thumb'          => array(
										'type'         => 'switch',
										'value'        => 'yes',
										'label'        => esc_html__( 'Archive Course Thumbnail', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Course Thumbnail?', 'thebrilliance' ),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										),
									),

									'archive_course_image_size' => array(
										'label' => esc_html__( 'Archive Course Image Size', 'thebrilliance' ),
										'type'  => 'short-text',
										'value' => '370x240',
										'desc'  => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
									),


									'archive_course_meta'             => array(
										'label'        => esc_html__( 'Archive Course Meta', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Course Meta?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),


									'archive_course_desc'         => array(
										'label'        => esc_html__( 'Course Archive Description', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Course Description?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),

									




									'course-single-box' => array(
										'title'   => esc_html__( 'Course Single', 'thebrilliance' ),
										'type'    => 'box',
										'options' => array(
											'course_single_group'              => array(
												'type'    => 'group',
												'attr'    => array('class' => 'border-bottom-none'),
												'options' => array(

													'course_single_layout'          => array(
														'label'   => esc_html__( 'Course Single Layout', 'thebrilliance' ),
														'desc'    => esc_html__( 'Select Course Layout', 'thebrilliance' ),
														'value'   => 'layout-1',
														'type'    => 'select',
														'choices' => array(
															'layout-1' => esc_html__( 'Layout 1', 'thebrilliance' ),
															'layout-2' => esc_html__( 'Layout 2', 'thebrilliance' ),
														),
													),


													'course_single_thumb'          => array(
														'type'         => 'switch',
														'value'        => 'yes',
														'label'        => esc_html__( 'Course Thumbnail', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Course Thumbnail?', 'thebrilliance' ),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' ),
														),
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' ),
														),
													),


													'single_course_meta'             => array(
														'label'        => esc_html__( 'Course Meta', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Course meta?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'yes',
													),


													'course_desc'         => array(
														'label'        => esc_html__( 'Course Description', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Course Description?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'no',
													),


													'course_info'         => array(
														'label'        => esc_html__( 'Course Info', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Course Info?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'no',
													),


													


													'course_related_columns'          => array(
														'label'   => esc_html__( 'Course Related Columns', 'thebrilliance' ),
														'desc'    => esc_html__( 'Select Course Related Columns', 'thebrilliance' ),
														'value'   => '3',
														'type'    => 'select',
														'choices' => array(
															'2' => esc_html__( '2 Columns', 'thebrilliance' ),
															'3' => esc_html__( '3 Columns', 'thebrilliance' ),
															'4' => esc_html__( '4 Columns', 'thebrilliance' ),
														),
													),

													'course_related_style'          => array(
														'label'   => esc_html__( 'Course Related Style', 'thebrilliance' ),
														'desc'    => esc_html__( 'Select Related Style', 'thebrilliance' ),
														'value'   => 'grid',
														'type'    => 'select',
														'choices' => array(
															'grid' => esc_html__( 'Grid', 'thebrilliance' ),
															'carousel' => esc_html__( 'Carousel', 'thebrilliance' ),
														),
													),
                                                    	'single_course_image_size' => array(
                    										'label' => esc_html__( 'Single Course Image Size', 'thebrilliance' ),
                    										'type'  => 'short-text',
                    										'value' => '370x240',
                    										'desc'  => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
                    									),

												)
											),
										)
									),


								)
							),
						)
					),
				)
			),
		)
	),


	'event_tab'  => array(
		'title'   => esc_html__( 'Events', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'event-posts' => array(
				'title'   => esc_html__( 'Events', 'thebrilliance' ),
				'type'    => 'tab',
				'options' => array(
					'event-box'        => array(
						'title'   => esc_html__( 'Events Archive', 'thebrilliance' ),
						'type'    => 'box',
						'options' => array(
							'event_settings' => array(
								'type'          => 'multi',
								'label'         => false,
								'attr'          => array(
									'class' => 'fw-option-type-multi-show-borders',
								),
								'inner-options' => array(

									'events_sidebar'               => array(
										'type'    => 'image-picker',
										'label'   => esc_html__( 'Events Sidebar', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select the events sidebar display style', 'thebrilliance' ),
										'value'   => 'full-width',
										'choices' => array(
											'full-width' => array(
												'small' => array(
													'height' => 70,
													'src'    => JWS_URI_PATH . '/images/image-picker/full-width.png'
												),
												'large' => array(
													'height' => 214,
													'src'    => JWS_URI_PATH . '/images/image-picker/full-width.png'
												),
											),
											'sidebar-left' => array(
												'small' => array(
													'height' => 70,
													'src'    => JWS_URI_PATH . '/images/image-picker/left-sidebar.png'
												),
												'large' => array(
													'height' => 214,
													'src'    => JWS_URI_PATH . '/images/image-picker/left-sidebar.png'
												),
											),
											'sidebar-right' => array(
												'small' => array(
													'height' => 70,
													'src'    => JWS_URI_PATH . '/images/image-picker/right-sidebar.png'
												),
												'large' => array(
													'height' => 214,
													'src'    => JWS_URI_PATH . '/images/image-picker/right-sidebar.png'
												),
											),
										),
									),

									'archive_event_layout'          => array(
										'label'   => esc_html__( 'Events Archive Layout', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Event Archive Layout', 'thebrilliance' ),
										'value'   => '3',
										'type'    => 'select',
										'choices' => array(
											'1' => esc_html__( 'Column List Inline', 'thebrilliance' ),
											'2' => esc_html__( '2 Columns', 'thebrilliance' ),
											'3' => esc_html__( '3 Columns', 'thebrilliance' ),
											'4' => esc_html__( '4 Columns', 'thebrilliance' ),
										),
									),

									'archive_event_pagination'          => array(
										'label'   => esc_html__( 'Event Archive Pagination', 'thebrilliance' ),
										'desc'    => esc_html__( 'Select Event Archive Pagination', 'thebrilliance' ),
										'value'   => 'numeric',
										'type'    => 'select',
										'choices' => array(
											'numeric' => esc_html__( 'Numeric', 'thebrilliance' ),
											'loadmore' => esc_html__( 'Loadmore', 'thebrilliance' ),
										),
									),

									'archive_event_thumb'          => array(
										'type'         => 'switch',
										'value'        => 'yes',
										'label'        => esc_html__( 'Archive Event Thumbnail', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Event Thumbnail?', 'thebrilliance' ),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										),
									),

									'archive_event_filter'          => array(
										'type'         => 'switch',
										'value'        => 'yes',
										'label'        => esc_html__( 'Archive Event Filter', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Event Filter?', 'thebrilliance' ),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' ),
										),
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' ),
										),
									),

									'archive_event_image_size' => array(
										'label' => esc_html__( 'Archive Event Image Size', 'thebrilliance' ),
										'type'  => 'short-text',
										'value' => '370x240',
										'desc'  => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'thebrilliance' ),
									),


									'archive_event_meta'             => array(
										'label'        => esc_html__( 'Archive Event Meta', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Event Meta?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),


									'archive_event_desc'         => array(
										'label'        => esc_html__( 'Event Archive Description', 'thebrilliance' ),
										'desc'         => esc_html__( 'Show Archive Event Description?', 'thebrilliance' ),
										'type'         => 'switch',
										'right-choice' => array(
											'value' => 'yes',
											'label' => esc_html__( 'Yes', 'thebrilliance' )
										),
										'left-choice'  => array(
											'value' => 'no',
											'label' => esc_html__( 'No', 'thebrilliance' )
										),
										'value'        => 'yes',
									),

									'event-single-box' => array(
										'title'   => esc_html__( 'Event Single', 'thebrilliance' ),
										'type'    => 'box',
										'options' => array(
											'event_single_group'              => array(
												'type'    => 'group',
												'attr'    => array('class' => 'border-bottom-none'),
												'options' => array(

													'event_single_thumb'          => array(
														'type'         => 'switch',
														'value'        => 'yes',
														'label'        => esc_html__( 'Event Thumbnail', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Event Thumbnail?', 'thebrilliance' ),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' ),
														),
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' ),
														),
													),

													'single_event_meta'             => array(
														'label'        => esc_html__( 'Event Meta', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Event meta?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'yes',
													),

													'event_info'         => array(
														'label'        => esc_html__( 'Event Info', 'thebrilliance' ),
														'desc'         => esc_html__( 'Show Event Info?', 'thebrilliance' ),
														'type'         => 'switch',
														'right-choice' => array(
															'value' => 'yes',
															'label' => esc_html__( 'Yes', 'thebrilliance' )
														),
														'left-choice'  => array(
															'value' => 'no',
															'label' => esc_html__( 'No', 'thebrilliance' )
														),
														'value'        => 'no',
													),

													'event_related_columns'          => array(
														'label'   => esc_html__( 'Event Related Columns', 'thebrilliance' ),
														'desc'    => esc_html__( 'Select Event Related Columns', 'thebrilliance' ),
														'value'   => '3',
														'type'    => 'select',
														'choices' => array(
															'2' => esc_html__( '2 Columns', 'thebrilliance' ),
															'3' => esc_html__( '3 Columns', 'thebrilliance' ),
															'4' => esc_html__( '4 Columns', 'thebrilliance' ),
														),
													),

													'event_related_style'          => array(
														'label'   => esc_html__( 'Event Related Style', 'thebrilliance' ),
														'desc'    => esc_html__( 'Select Related Style', 'thebrilliance' ),
														'value'   => 'grid',
														'type'    => 'select',
														'choices' => array(
															'grid' => esc_html__( 'Grid', 'thebrilliance' ),
															'carousel' => esc_html__( 'Carousel', 'thebrilliance' ),
														),
													),

												)
											),
										)
									),


								)
							),
						)
					),
				)
			),
		)
	),

	'shop_tab' => array(
		'title'   => esc_html__( 'Shop', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'shop-box' => array(
				'title'   => esc_html__( 'Shop', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'shop_settings' => array(
						'type'          => 'multi',
						'label'         => false,
						'attr'          => array(
							'class' => 'fw-option-type-multi-show-borders',
						),
						'inner-options' => array(
							'show_title'          => array(
								'type'         => 'switch',
								'value'        => 'no',
								'label'        => esc_html__( 'Show Title', 'thebrilliance' ),
								'desc'         => esc_html__( 'Turn on/off title shop', 'thebrilliance' ),
								'left-choice'  => array(
									'value' => 'no',
									'label' => esc_html__( 'No', 'thebrilliance' ),
								),
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__( 'Yes', 'thebrilliance' ),
								),
							),

							'shop_columns'          => array(
								'label'   => esc_html__( 'Shop Columns', 'thebrilliance' ),
								'desc'    => esc_html__( 'Select Columns Shop Archive', 'thebrilliance' ),
								'value'   => '',
								'type'    => 'select',
								'choices' => array(
									'columns-2' => esc_html__( '2 Columns', 'thebrilliance' ),
									'columns-3' => esc_html__( '3 Columns', 'thebrilliance' ),
									'columns-4' => esc_html__( '4 Columns', 'thebrilliance' ),
								),
							),

						)
					)
				)
			),
		)
	),


	'custom_css_tab' => array(
		'title'   => esc_html__( 'Custom CSS', 'thebrilliance' ),
		'type'    => 'tab',
		'options' => array(
			'css-box' => array(
				'title'   => esc_html__( 'CSS', 'thebrilliance' ),
				'type'    => 'box',
				'options' => array(
					'quick_css' => array(
						'label' => esc_html__( 'Quick CSS', 'thebrilliance' ),
						'desc'  => esc_html__( 'Quick Css changes that will be applied to the theme', 'thebrilliance' ),
						'help'  => esc_html__( 'If you need to change major portions of the theme please add your custom CSS in the <strong>custom.less</strong> file. This file is located on your server in the <strong>/child-theme/style-less/</strong> folder.', 'thebrilliance' ),
						'type'  => 'textarea',
						'value' => '',
					),
				)
			),
		)
	),
);