<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * @var  string $id
 * @var  array $option
 * @var  array $data
 */

{
	$wrapper_attr = $option['attr'];

	unset(
		$wrapper_attr['value'],
		$wrapper_attr['name']
	);
}

//animation type
$animations = array(
	'animation_seekers'  => array(
		'group'      => esc_html__( 'Attention Seekers', 'thebrilliance' ),
		'animations' => array(
			'bounce'     => esc_html__( 'bounce', 'thebrilliance' ),
			'flash'      => esc_html__( 'flash', 'thebrilliance' ),
			'pulse'      => esc_html__( 'pulse', 'thebrilliance' ),
			'rubberBand' => esc_html__( 'rubberBand', 'thebrilliance' ),
			'shake'      => esc_html__( 'shake', 'thebrilliance' ),
			'swing'      => esc_html__( 'swing', 'thebrilliance' ),
			'tada'       => esc_html__( 'tada', 'thebrilliance' ),
			'wobble'     => esc_html__( 'wobble', 'thebrilliance' ),
			'jello'      => esc_html__( 'jello', 'thebrilliance' ),
		)
	),
	'bouncing_entrances' => array(
		'group'      => esc_html__( 'Bouncing Entrances', 'thebrilliance' ),
		'animations' => array(
			'bounceIn'      => esc_html__( 'bounceIn', 'thebrilliance' ),
			'bounceInDown'  => esc_html__( 'bounceInDown', 'thebrilliance' ),
			'bounceInLeft'  => esc_html__( 'bounceInLeft', 'thebrilliance' ),
			'bounceInRight' => esc_html__( 'bounceInRight', 'thebrilliance' ),
			'bounceInUp'    => esc_html__( 'bounceInUp', 'thebrilliance' ),
		)
	),
	'bouncing_exists'    => array(
		'group'      => esc_html__( 'Bouncing Exits', 'thebrilliance' ),
		'animations' => array(
			'bounceOut'      => esc_html__( 'bounceOut', 'thebrilliance' ),
			'bounceOutDown'  => esc_html__( 'bounceOutDown', 'thebrilliance' ),
			'bounceOutLeft'  => esc_html__( 'bounceOutLeft', 'thebrilliance' ),
			'rubberBand'     => esc_html__( 'rubberBand', 'thebrilliance' ),
			'bounceOutRight' => esc_html__( 'bounceOutRight', 'thebrilliance' ),
			'bounceOutUp'    => esc_html__( 'bounceOutUp', 'thebrilliance' ),
		)
	),
	'fading_entrances'   => array(
		'group'      => esc_html__( 'Fading Entrances', 'thebrilliance' ),
		'animations' => array(
			'fadeIn'         => esc_html__( 'fadeIn', 'thebrilliance' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'thebrilliance' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'thebrilliance' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'thebrilliance' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'thebrilliance' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'thebrilliance' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'thebrilliance' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'thebrilliance' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'thebrilliance' )
		)
	),
	'fading_exists'      => array(
		'group'      => esc_html__( 'Fading Exits', 'thebrilliance' ),
		'animations' => array(
			'fadeOut'         => esc_html__( 'fadeOut', 'thebrilliance' ),
			'fadeOutDown'     => esc_html__( 'fadeOutDown', 'thebrilliance' ),
			'fadeOutDownBig'  => esc_html__( 'fadeOutDownBig', 'thebrilliance' ),
			'fadeOutLeft'     => esc_html__( 'fadeOutLeft', 'thebrilliance' ),
			'fadeOutLeftBig'  => esc_html__( 'fadeOutLeftBig', 'thebrilliance' ),
			'fadeOutRight'    => esc_html__( 'fadeOutRight', 'thebrilliance' ),
			'fadeOutRightBig' => esc_html__( 'fadeOutRightBig', 'thebrilliance' ),
			'fadeOutUp'       => esc_html__( 'fadeOutUp', 'thebrilliance' ),
			'fadeOutUpBig'    => esc_html__( 'fadeOutUpBig', 'thebrilliance' )
		)
	),
	'flippers'           => array(
		'group'      => esc_html__( 'Flippers', 'thebrilliance' ),
		'animations' => array(
			'flip'           => esc_html__( 'flip', 'thebrilliance' ),
			'flipInX'        => esc_html__( 'flipInX', 'thebrilliance' ),
			'flipInY'        => esc_html__( 'flipInY', 'thebrilliance' ),
			'flipOutX'       => esc_html__( 'flipOutX', 'thebrilliance' ),
			'fadeOutLeftBig' => esc_html__( 'flipOutY', 'thebrilliance' ),
			'flipOutY'       => esc_html__( 'fadeOutRight', 'thebrilliance' )
		)
	),
	'lightspeed'         => array(
		'group'      => esc_html__( 'Lightspeed', 'thebrilliance' ),
		'animations' => array(
			'lightSpeedIn'  => esc_html__( 'lightSpeedIn', 'thebrilliance' ),
			'lightSpeedOut' => esc_html__( 'lightSpeedOut', 'thebrilliance' )
		)
	),
	'rotating_entrances' => array(
		'group'      => esc_html__( 'Rotating Entrances', 'thebrilliance' ),
		'animations' => array(
			'rotateIn'          => esc_html__( 'rotateIn', 'thebrilliance' ),
			'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'thebrilliance' ),
			'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'thebrilliance' ),
			'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'thebrilliance' ),
			'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'thebrilliance' )
		)
	),
	'rotating_exists'    => array(
		'group'      => esc_html__( 'Rotating Exits', 'thebrilliance' ),
		'animations' => array(
			'rotateOut'          => esc_html__( 'rotateOut', 'thebrilliance' ),
			'rotateOutDownLeft'  => esc_html__( 'rotateOutDownLeft', 'thebrilliance' ),
			'rotateOutDownRight' => esc_html__( 'rotateOutDownRight', 'thebrilliance' ),
			'rotateOutUpLeft'    => esc_html__( 'rotateOutUpLeft', 'thebrilliance' ),
			'rotateOutUpRight'   => esc_html__( 'rotateOutUpRight', 'thebrilliance' )
		)
	),
	'sliding_entrances'  => array(
		'group'      => esc_html__( 'Sliding Entrances', 'thebrilliance' ),
		'animations' => array(
			'slideInUp'    => esc_html__( 'slideInUp', 'thebrilliance' ),
			'slideInDown'  => esc_html__( 'slideInDown', 'thebrilliance' ),
			'slideInLeft'  => esc_html__( 'slideInLeft', 'thebrilliance' ),
			'slideInRight' => esc_html__( 'slideInRight', 'thebrilliance' )
		)
	),
	'sliding_exists'     => array(
		'group'      => esc_html__( 'Sliding Exits', 'thebrilliance' ),
		'animations' => array(
			'slideOutUp'    => esc_html__( 'slideOutUp', 'thebrilliance' ),
			'slideOutDown'  => esc_html__( 'slideOutDown', 'thebrilliance' ),
			'slideOutLeft'  => esc_html__( 'slideOutLeft', 'thebrilliance' ),
			'slideOutRight' => esc_html__( 'slideOutRight', 'thebrilliance' )
		)
	),
	'zoom_entrances'     => array(
		'group'      => esc_html__( 'Zoom Entrances', 'thebrilliance' ),
		'animations' => array(
			'zoomIn'      => esc_html__( 'zoomIn', 'thebrilliance' ),
			'zoomInDown'  => esc_html__( 'zoomInDown', 'thebrilliance' ),
			'zoomInLeft'  => esc_html__( 'zoomInLeft', 'thebrilliance' ),
			'zoomInRight' => esc_html__( 'zoomInRight', 'thebrilliance' ),
			'zoomInUp'    => esc_html__( 'zoomInUp', 'thebrilliance' )
		)
	),
	'zoom_exists'        => array(
		'group'      => esc_html__( 'Zoom Exits', 'thebrilliance' ),
		'animations' => array(
			'zoomOut'      => esc_html__( 'zoomOut', 'thebrilliance' ),
			'zoomOutDown'  => esc_html__( 'zoomOutDown', 'thebrilliance' ),
			'zoomOutLeft'  => esc_html__( 'zoomOutLeft', 'thebrilliance' ),
			'zoomOutRight' => esc_html__( 'zoomOutRight', 'thebrilliance' ),
			'zoomOutUp'    => esc_html__( 'zoomOutUp', 'thebrilliance' )
		)
	),
	'specials'           => array(
		'group'      => esc_html__( 'Specials', 'thebrilliance' ),
		'animations' => array(
			'hinge'   => esc_html__( 'hinge', 'thebrilliance' ),
			'rollIn'  => esc_html__( 'rollIn', 'thebrilliance' ),
			'rollOut' => esc_html__( 'rollOut', 'thebrilliance' )
		)
	),
);

$animations = apply_filters( 'tf-animate-css', $animations );

?>
<div <?php echo fw_attr_to_html( $wrapper_attr ); ?>>

	<div class="fw-option-tf-animation-option fw-option-tf-animation-option-type fw-border-box-sizing fw-col-sm-8">
		<select data-type="type" name="<?php echo esc_attr( $option['attr']['name'] ) ?>[animation]"
		        class="fw-option-tf-animation-option-type-input">
			<?php foreach ( $animations as $group ): ?>
				<optgroup label="<?php echo esc_attr( $group['group'] ); ?>">

					<?php foreach ( $group['animations'] as $key => $animation ): ?>
						<option
							value="<?php echo esc_attr( $key ); ?>" <?php echo wp_kses_post($data['value']['animation'] === $key ? ' selected="selected" ' : ''); ?>><?php echo esc_html( $animation ); ?></option>
					<?php endforeach; ?>

				</optgroup>
			<?php endforeach; ?>
		</select>
	</div>


	<div class="fw-option-tf-animation-option fw-option-tf-animation-option-delay fw-border-box-sizing fw-col-sm-2">
		<input type="text" name="<?php echo esc_attr( $option['attr']['name'] ) ?>[delay]" id=""
		       class="fw-option fw-option-tf-animation-option-delay-input"
		       value="<?php echo esc_attr($data['value']['delay']); ?>">
	</div>
</div>
