<?php if ( ! defined('ABSPATH')) exit('No direct script access allowed');

if( ! function_exists( 'jws_shortcode_blog' ) ) {
    function jws_shortcode_blog( $atts ) {
        $post_setting = shortcode_atts( array(
            'enabled_readmore'  => 'yes',
            'featured_image'  => 'yes',
            'posts_excerpt_length'  => 32,
            'posts_layout'  => 'columns-3',
            'posts_pagination'  => 'loadmore',
            'readmore_text'  => 'Learn More',
            'post_meta' => 'yes',
            'items_per_page' => 3,
            'ajax_page' => '',
            'title_block' => '',
            'post_type'  => 'post',
            'taxonomies'  => '',
            'length_excerpt' => 8,
            'hide_meta' => false,
            'items_per_page'  => 4,
            'pagination_type'  => '',
            'blog_design' => 'default',
            'img_size' => 'full',
            'blog_columns' =>'2',
            'orderby'  => 'date',
            'order'  => 'DESC',
            'meta_key'  => '',
            'offset'  => '',
            'exclude'  => '',
            'include'  => '',
        ), $atts );

        $arr_col = array(
            'column-1'  => 'col-md-12',
            'columns-2' => 'col-md-6',
            'columns-3' => 'col-md-4',
            'columns-4' => 'col-md-3',
        );
        $arr_thumb = array(
            'column-1'  => 'full',
            'columns-2' => 'jws-archive-post-2col',
            'columns-3' => 'jws-archive-post-3col',
            'columns-4' => 'jws-archive-post-4col',
        );

        extract( $post_setting ); 
        $encoded_atts = json_encode( $post_setting );
        $is_ajax = (defined( 'DOING_AJAX' ) && DOING_AJAX);
        $output = '';
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        if( $ajax_page > 1 ) $paged = $ajax_page;

        $args = array(
            'post_type' => $post_type,
            'status' => 'published',
            'paged' => $paged,  
            'posts_per_page' => $items_per_page
        );

        if( $post_type == 'ids' && $include != '' ) {
            $args['post__in'] = explode(',', $include);
        }

        if( ! empty( $exclude ) ) {
            $args['post__not_in'] = explode(',', $exclude);
        }

        if( ! empty( $taxonomies ) ) {
            $taxonomy_names = get_object_taxonomies( 'post' );
            $terms = get_terms( $taxonomy_names, array(
                'orderby' => 'name',
                'include' => $taxonomies
            ));

            if( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
                $args['tax_query'] = array('relation' => 'OR');
                foreach ($terms as $key => $term) {
                    $args['tax_query'][] = array(
                        'taxonomy' => $term->taxonomy,     
                        'field' => 'slug',                  
                        'terms' => array( $term->slug ),   
                        'include_children' => true,        
                        'operator' => 'IN'  
                    );
                }
            }
        }

        if( ! empty( $order ) ) {
            $args['order'] = $order;
        }

        if( ! empty( $offset ) ) {
            $args['offset'] = $offset;
        }

        if( ! empty( $meta_key ) ) {
            $args['meta_key'] = $meta_key;
        }

        if( ! empty( $orderby ) ) {
            $args['orderby'] = $orderby;
        }
        $blog_query = new WP_Query($args);
        ob_start();
        
        $class = '';
        $class .= ' '.$blog_design;

        $data  = 'data-masonry=\'{"selector":".post-item ", "columnWidth":".grid-sizer","layoutMode":"masonry"}\'';
        if(!$is_ajax) echo '<div class="blog-shortcode jws-atts-shortcode row ' . esc_attr( $class) . '" data-paged="'.$paged.'" data-atts="' . esc_attr( $encoded_atts ) . '"  >';
        if ($blog_design == 'style-1' && $title_block != '') {
           if(!$is_ajax) echo '<div class="wrap-label-title"><div class="title">'.$title_block.'</div></div>';
        }

        if(!$is_ajax) echo '<div class="wrap-list-article">';
        while ( $blog_query->have_posts() ) :
            $blog_query->the_post();
            $num_comments = get_comments_number();
            $classes = array();
            $classes[] = $posts_layout;
            if($blog_design == 'default') {
               ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class($arr_col[$post_setting['posts_layout']]); ?>>
                    <a href="<?php the_permalink(); ?> ">
                        <div class="blog-image">

                            <?php 
                            if ($post_setting['featured_image'] == 'yes'):
                                the_post_thumbnail($arr_thumb[$post_setting['posts_layout']]);
                            endif;
                            ?>
                            <?php 
                            switch (get_post_format()) {
                                case 'video':
                                    $icon = '<i class="icon-video-camera"></i>';
                                    break;

                                case 'gallery':
                                    $icon = '<i class="icon-images"></i>';
                                    break;

                                case 'image':
                                    $icon = '<i class="icon-camera"></i>';
                                    break;

                                case 'quote':
                                    $icon = '<i class="icon-quotes-left"></i>';
                                    break;
                                
                                default:
                                    $icon = '<i class="icon-file-text2"></i>';
                                    break;
                            }
                            ?>

                            <?php if (has_post_thumbnail()) : ?>
                                <div class="thumb-format"><?php echo wp_kses_post($icon); ?></div>
                            <?php endif; ?>

                            <?php if ($post_setting['enabled_readmore'] == 'yes'): ?>
                                <div class="readmore">
                                    <?php echo esc_html($post_setting['readmore_text']); ?><span class="lnr lnr-arrow-right"></span>
                                </div>
                            <?php endif; ?>

                        </div>
                    </a>

                    <div class="wrap-content">
                        <?php 
                        if ( is_single() ) :
                            the_title( '<h5 class="entry-title">', '</h5>' );
                        else :
                            the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' );
                        endif; 
                        ?>

                        <?php if ($post_setting['post_meta'] == 'yes'): ?>
                            <div class="meta-post">
                                <div class="author"><span class="icon-user"></span>
                                    <?php 
                                        $author = get_the_author_meta('ID'); 
                                        echo '<a href="'.get_author_posts_url($author).'">'.get_the_author().'</a>';
                                    ?> 
                                </div>
                                <div class="date-post"><span class="icon-calendar"></span><?php echo date_i18n( get_option( 'date_format' ), strtotime( $blog_query->post_date ) ); ?></div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($post_setting['post_meta'] == 'yes'): ?>
                            <div class="meta-post">
                                <div class="author"><span class="lnr lnr-user"></span>

                                </div>
                                <div class="date-post"><span class="lnr lnr-clock"></span></div>
                                <div class="num-comments"><span class="lnr lnr-menu-circle"></span></div>
                            </div>
                        <?php endif; ?>
                    </div>

                </article>

           
            <?php
            }elseif($blog_design == 'style-1'){ 
            ?>

                <article <?php post_class(); ?>>

                    <div class="blog-image">
                        <?php 
                        if ($post_setting['featured_image'] == 'yes'):
                            the_post_thumbnail(array(100,100));
                        endif;
                        ?>
                    </div>

                    <div class="wrap-content">
                        <?php 
                        if ( is_single() ) :
                            the_title( '<h5 class="entry-title">', '</h5>' );
                        else :
                            the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' );
                        endif; 
                        ?>

                        <?php if ($post_setting['post_meta'] == 'yes'): ?>
                            <div class="meta-post">
                                <div class="date-post"><span class="icon-calendar"></span><?php echo date_i18n( get_option( 'date_format' ), strtotime( $blog_query->post_date ) ); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="clearfix"></div>

                </article>
            <?php
            }
        endwhile;

        if(!$is_ajax) echo '</div></div>';
        wp_reset_postdata();
        $output .= ob_get_clean();
        ob_flush();
        if( $is_ajax ) {
            $output =  array(
                'items' => $output,
                'status' => ( $blog_query->max_num_pages > $paged ) ? 'have-posts' : 'no-more-posts'
            );
        }
        return $output;
    }
    if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_blog', 'jws_shortcode_blog' );
    }
    
}
if( ! function_exists( 'jws_get_post_shortcode_ajax' ) ) {
    add_action( 'wp_ajax_jws_get_post_shortcode', 'jws_get_post_shortcode_ajax' );
    add_action( 'wp_ajax_nopriv_jws_get_post_shortcode', 'jws_get_post_shortcode_ajax' );
    function jws_get_post_shortcode_ajax() {
        if( ! empty( $_POST['atts'] ) ) {
            $atts = $_POST['atts'];
            $paged = (empty($_POST['paged'])) ? 2 : (int) $_POST['paged'] + 1;
            $atts['ajax_page'] = $paged;
            $data = jws_shortcode_blog($atts);
            echo json_encode( $data );
            die();
        }
    }
}
