<?php 
if( ! function_exists( 'jws_images_gallery_shortcode' )) {
    function jws_images_gallery_shortcode($atts) {
        $output = $class = '';
        $parsed_atts = shortcode_atts(  
            array(
            'ids'        => '',
            'images'     => '',
            'columns'    => 3,
            'size'       => '',
            'img_size'   => 'thumbnail',
            'link'       => '',
            'spacing'    => 30,
            'no_padding' => '',
            'img_per_page' => 6,
            'view'       => 'grid',
            'el_class'   => '',
            'layout_msr' => '2 1 1 1 1 2 1 2 1',
            'custom_layout_msr' => '3 1 1 1 1 1 1 2 1 1',
            ), $atts );
        wp_enqueue_script( 'isotope');

        extract( $parsed_atts );
        $_attachments = get_posts(array('include' => $images, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image'));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
        if (empty($attachments)) return '';

        $current = (get_query_var('paged')) ? get_query_var( 'paged' ) : 1;
        $per_page = $img_per_page;
        $offset = ($current-1) * $per_page;
        $big = 999999999; // need an unlikely integer

        $total = sizeof($attachments);
        $total_pages = round($total/$per_page);
        if($total_pages < ($total/$per_page))
            $total_pages = $total_pages+1;

        // Override standard wordpress gallery shortcodes

        if ( ! empty( $atts['ids'] ) ) {
            $atts['images'] = $atts['ids'];
        }

        $arr_col = array(
            2 => 'col-md-6',
            3 => 'col-md-4',
            4 => 'col-md-3',
            5 => 'col-md-1_5',
        );


        extract( $atts );

        if($layout_msr == 'custom-layout')
            $layout_msr = $custom_layout_msr;

        $images = explode(',', $images);
        if ($no_padding == 'yes')
            $class .= 'no-padding';

        $class .= ' ' . $el_class;
        if( $view != 'justified' ) $class .= ' spacing-' . $spacing;

        $class .= ' columns-' . $columns;
        $class .= ' view-' . $view;

        $classs = $data = $sizer = '';
        $data  = 'data-masonry=\'{"selector":".jws-gallery-item ", "columnWidth":".grid-sizer","layoutMode":"masonry"}\'';
        $sizer = '<div style="width: 25%;" class="grid-sizer size-'.$columns.'"></div>';
        $class_column = $arr_col[$columns] . " col-sm-6 col-xs-12";
        ob_start();
          ?>
            <div class="jws-images-gallery row <?php echo esc_attr( $class ); ?>">
                
                <div class="gallery-images  <?php  if( $view == 'masonry' ) echo "jws-masonry" ?>" <?php  if( $view == 'masonry' )  echo wp_kses_post( $data ); ?>>
                    <?php
                    if( $view == 'masonry' )
                    echo wp_kses_post( $sizer );

                    if ( count($images) > 0 ):
                        $counter = 0;
                        $pos = 0;
                        foreach ($attachments as $id => $attachment):
                            $pos++;
                            if(($counter < $per_page)&&($pos > $offset))
                            {   
                                if($view == 'masonry'):
                                    $img_size = jws_get_img_size($layout_msr, $counter);
                                    $class_column = jws_get_class_column($layout_msr, $counter);
                                endif;
                                
                                $counter++;
                                $img = wpb_getImageBySize( array( 'attach_id' => $attachment->ID, 'thumb_size' => $img_size, 'class' => 'jws-gallery-image image-' . $counter ) ); 
                                ?>
                                <div class="jws-gallery-item <?php echo esc_attr($class_column); ?>">
                                    <a href="<?php echo esc_url( $img['p_img_large']['0'] ); ?>" data-index="<?php echo esc_attr($counter); ?>" data-width="<?php echo esc_attr( $img['p_img_large']['1'] ); ?>" data-height="<?php echo esc_attr( $img['p_img_large']['2'] ); ?>">
                                        <?php echo wp_kses_post($img['thumbnail']);?>
                                    </a>
                                </div>
                            <?php
                            }
                        endforeach;
                    endif; 
                    ?>
                </div>
            </div>
            <?php 
            $output .= paginate_links( array(
                'base' => str_replace($big,'%#%',esc_url(get_pagenum_link($big))),
                'format' => '?paged=%#%',
                'current' => $current,
                'total' => $total_pages,
                'prev_text' =>esc_html__( '<i class="fa fa-angle-left"></i>', 'thebrilliance' ),
                'next_text' =>esc_html__( '<i class="fa fa-angle-right"></i>', 'thebrilliance' ),
            ) );

            printf('<nav class="jws-pagination pagination-gallery" role="navigation">%1s</nav>', wp_kses_post($output));
            wp_kses_post($output); 

        $output = ob_get_contents();
        ob_end_clean();

        return $output;
    }

    function jws_get_img_size($layout_msr, $counter) {
        $arr_msr_size = array(
            1   =>  'jws-masonry-square-small',
            2   =>  'jws-masonry-rectangle',
            3   =>  'jws-masonry-square-large'
        );
        $msr = explode(" ",$layout_msr);
        if($counter >= count($msr)){
            $counter -= count($msr);
        }
        
        $result = $arr_msr_size[$msr[$counter]];
        return $result;
    }

    function jws_get_class_column($layout_msr, $counter) {
        $msr = explode(" ",$layout_msr);
        if($counter >= count($msr)){
            $counter -= count($msr);
        }
        $class_column = ($msr[$counter] == 2 || $msr[$counter] == 3)?  "col-md-6 col-sm-6 col-xs-12" : "col-md-3 col-sm-3 col-xs-12";
        return $class_column;
    }

    if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_gallery', 'jws_images_gallery_shortcode' );
    }
}