<?php
if( ! function_exists( 'jws_shortcode_list_icons' ) ) {
    function jws_shortcode_list_icons($atts = array(), $content = null) {
        $posts_query = $el_class = $args = $my_query = $speed = '';
        $slides_per_view = $wrap = $scroll_per_page = $title_out = '';
        $autoplay = $hide_dots = $hide_prev_next_buttons = $output = '';
        $parsed_atts = shortcode_atts( array(
            'layout' => 'slider', // grid slider
            'style' => 'standard', // standard boxed
            'slides_per_view' => 3,
            'hide_prev_next_buttons' => 'no',
            'nav_position' => 'lar',
            'name' => '',
            'bg_img' => '',
            'text_color' => '#000',
            'el_class' => ''
        ) , $atts );

        extract( $parsed_atts );
        wp_enqueue_style('slick');
        $class = array(); 
        $class[] = 'list_icons';
        $class[] = 'container';


        $class[] = $el_class;
        $class[] = ' list_icons-' . $layout;
        $class[] = ' list_icon-style-' . $style;
        $class[] = ( $layout == 'slider' ) ? ' has-slider' : ' list_icon-columns-' . $slides_per_view;
        $carousel_id = 'carousel-' . rand( 1000, 10000);

        ob_start(); ?>
            <div id="<?php echo esc_attr($carousel_id); ?>" class="list_icons-wrapper nav-<?php echo esc_attr($nav_position); ?>" style="background-image: url(<?php echo wp_get_attachment_url($bg_img,'full'); ?>);background-size: contain;background-repeat: no-repeat;" data-cols="<?php echo esc_attr($slides_per_view); ?>" data-nav="<?php echo esc_attr($hide_prev_next_buttons); ?>">
                <div class="<?php echo esc_attr(implode(' ', $class)); ?>" style="color: <?php echo esc_attr($text_color); ?>">
                    <div class="row">
                        <?php echo do_shortcode( $content ); ?>
                    </div>
                </div>
            </div>
            <?php 
                if( $layout == 'slider' ) {
                    $parsed_atts['carousel_id'] = $carousel_id;
                }
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }

      if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'list_icons', 'jws_shortcode_list_icons' );
    }
}

if( ! function_exists( 'jws_shortcode_list_icon' ) ) {
    function jws_shortcode_list_icon($atts, $content) {
        if( ! function_exists( 'wpb_getImageBySize' ) ) return;
        $output = $class = '';
        extract(shortcode_atts( array(
            'item_style' => 'default',
            'image' => '',
            'g1' => '#27c7a0',
            'g2' => '#7ed93e',
            'img_size' => 'thumbnail',
            'columns' => 4,
            'name' => '',
            'title' => '',
            'link' => '#',
            'icon_text' => '',
            'el_class' => ''
        ), $atts ));

        $arr_cols = array(
            1 => 'col-md-12',
            2 => 'col-md-6',
            3 => 'col-md-4',
            4 => 'col-md-3',
            5 => 'col-md-1_5',
            6 => 'col-md-2',
        );

        $img_id = preg_replace( '/[^\d]/', '', $image );
        $img = wpb_getImageBySize( array( 'attach_id' => $img_id, 'thumb_size' => $img_size, 'class' => 'list_icon-avatar-image' ) );

        $class .= ' '.$el_class.' '.$item_style;

        ob_start(); ?>
            <?php if($item_style == 'default'): ?>
            <div class="<?php echo esc_attr( $arr_cols[$columns] ); ?>">
                <a href="<?php echo esc_url($link); ?>">
                <div class="list_icon <?php echo esc_attr( $class ); ?> " style="background-image: linear-gradient(to right,<?php echo esc_attr($g1); ?> 0%,<?php echo esc_attr($g2); ?> 51%,<?php echo esc_attr($g1); ?> 100%); ">
                    
                        <div class="list_icon-inner">
                            <?php if ( $img['thumbnail'] != ''): ?>
                                <div class="list_icon-avatar">
                                    <?php echo wp_kses_post($img['thumbnail']); ?>
                                </div>
                            <?php endif ?>
                            <?php if(!empty($icon_text)) : ?>
                                <div class="list_icon_text">
                                    <span class="<?php echo esc_attr($icon_text); ?>"></span>
                                </div>
                            <?php endif; ?>
                            <div class="list_icon-content">
                                <?php echo do_shortcode( $content ); ?>
                            </div>
                        </div>
                    

                    <div class="test-info">
                        <span class="quote-sign"></span>

                        <div class="wrap-name">
                            <div class="name"><?php echo esc_html( $name ); ?></div>
                            <span class="subtitle"><?php echo esc_html( $title ); ?></span>
                        </div>
                        

                    </div>
                </div>
                </a>
            </div>
            <?php endif; ?>
        <?php
        $output = ob_get_contents();
        ob_end_clean();
        return $output; 
    }

     if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'list_icon', 'jws_shortcode_list_icon' );
    }
}