<?php  
/**
* ------------------------------------------------------------------------------------------------
* instagram shortcode
* ------------------------------------------------------------------------------------------------
*/
if( ! function_exists( 'jws_shortcode_instagram' ) ) {
	function jws_shortcode_instagram( $atts, $content = '' ) {
		$output = '';
        $parsed_atts = shortcode_atts( array(
			'title' => '',
			'username' => 'flickr',
			'number' => 9,
            'slides_per_view' => 8 ,
			'size' => 'thumbnail',
			'target' => '_self',
			'link' => '',
			'design' => 'default',
			'space' => 0,
			'rounded' => 0,
			'per_row' => 3,
            'spacing' => '',
            'banner' => '',
		), $atts );
        
        extract( $parsed_atts );	
		$carousel_id = 'carousel-' . rand(100,999);
		ob_start();
		$class = 'instagram-widget';
		if( $spacing == 1 ) {
			$class .= ' instagram-with-spaces';
		}
		if( $rounded == 1 ) {
			$class .= ' instagram-rounded';
		}
		$class .= ' instagram-per-row-' . $per_row;
		echo '<div id="' . $carousel_id . '" class="' . $class." ".$design.'">';
		if ($username != '') {
			$media_array = jws_scrape_instagram($username, $number);
			if ( is_wp_error($media_array) ) {
			   echo esc_html( $media_array->get_error_message() );
			} else {
				?>
				<?php if ($content != '') : ?>
					<div class="banner"><a href="https://www.instagram.com/<?php echo esc_attr($username); ?>" target="_blank"><?php echo wp_kses_post($content); ?></a></div>
				<?php endif; ?>
				<ul class="instagram-pics <?php echo esc_attr($design); ?>" data-slick='{"slidesToShow": <?php echo esc_attr($slides_per_view); ?> , "autoplay": true, "autoplaySpeed": 2000,"slidesToScroll": 1,"responsive":[{"breakpoint": 1024,"settings":{"slidesToShow": 3}},{"breakpoint": 480,"settings":{"slidesToShow": 2}}]}'><?php
				foreach ($media_array as $item) {
					$image = (! empty( $item[$size] )) ? $item[$size] : $item['thumbnail'];
					echo '<li>
						<a href="'. esc_url( $item['link'] ) .'" target="'. esc_attr( $target ) .'">
						<div class="wrapp-pics">
							<img src="'. esc_url( $image ) .'" alt="'.esc_attr('image','thebrilliance').'" />
							<div class="hover-mask"></div>
						</div>
						</a>
					</li>';
				}
				?></ul><?php
			}
		}
		if ($link != '') {
			?><p class="clear"><a href="//instagram.com/<?php echo trim($username); ?>" rel="me" target="<?php echo esc_attr( $target ); ?>"><?php echo esc_html($link); ?></a></p><?php
		}
	
		echo '</div>';
		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}

      if(function_exists('insert_shortcode')){ 
        insert_shortcode( 'jws_instagram', 'jws_shortcode_instagram' );
    }
}
if( ! function_exists( 'jws_scrape_instagram' ) ) {
	function jws_scrape_instagram($username, $slice = 9) {
		$username = strtolower( $username );
         
		$by_hashtag = ( substr( $username, 0, 1) == '#' );
			$request_param = ( $by_hashtag ) ? 'explore/tags/' . substr( $username, 1) : trim( $username );
			$remote = wp_remote_get( 'http://instagram.com/'. $request_param );
			if ( is_wp_error( $remote ) )
				return new WP_Error( 'site_down',esc_html__( 'Unable to communicate with Instagram.', 'thebrilliance' ) );
			if ( 200 != wp_remote_retrieve_response_code( $remote ) )
				return new WP_Error( 'invalid_response',esc_html__( 'Instagram did not return a 200.', 'thebrilliance' ) );
			$shards = explode( 'window._sharedData = ', $remote['body'] );
			$insta_json = explode( ';</script>', $shards[1] );
			$insta_array = json_decode( $insta_json[0], TRUE );
            
			if ( !$insta_array )
				return new WP_Error( 'bad_json',esc_html__( 'Instagram has returned invalid data.', 'thebrilliance' ) );
			// old style
			if ( isset( $insta_array['entry_data']['UserProfile'][0]['userMedia'] ) ) {
				$images = $insta_array['entry_data']['UserProfile'][0]['userMedia'];
				$type = 'old';
			// new style
			} else if ( isset( $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges']) ) {
				$images = $insta_array['entry_data']['ProfilePage'][0]['graphql']['user']['edge_owner_to_timeline_media']['edges'];
				$type = 'new';
			} elseif( $by_hashtag && isset( $insta_array['entry_data']['TagPage'][0]['tag']['media']['nodes'] ) ) {
				$images = $insta_array['entry_data']['TagPage'][0]['tag']['media']['nodes'];
				$type = 'new';
			} else {
				return new WP_Error( 'bad_json_2',esc_html__( 'Instagram has returned invalid data. ', 'thebrilliance' ) );
			}
            
			if ( !is_array( $images ) )
				return new WP_Error( 'bad_array',esc_html__( 'Instagram has returned invalid data.', 'thebrilliance' ) );
			$instagram = array();
           
			switch ( $type ) {
			 
				case 'old':
					foreach ( $images as $image ) {
					  
						if ( $image['user']['username'] == $username ) {
							$image['link']						  = $image['link'];
							$image['images']['thumbnail']		   = preg_replace( "/^http:/i", "", $image['images']['thumbnail'] );
							$image['images']['standard_resolution'] = preg_replace( "/^http:/i", "", $image['images']['standard_resolution'] );
							$image['images']['low_resolution']	  = preg_replace( "/^http:/i", "", $image['images']['low_resolution'] );
							$instagram[] = array(
								'description'   => $image['edge_media_to_caption']['edegs']['text'],
								'link'		  	=> $image['link'],
								'time'		  	=> $image['created_time'],
								'comments'	  	=> $image['comments']['count'],
								'likes'		 	=> $image['likes']['count'],
								'thumbnail'	 	=> $image['images']['thumbnail'],
								'large'		 	=> $image['images']['standard_resolution'],
								'small'		 	=> $image['images']['low_resolution'],
								'type'		  	=> $image['type']
							);
						}
					}
				break;
				default:
					foreach ( $images as $imagess ) {
                        foreach ($imagess as $image) {
						$image['thumbnail_src'] = preg_replace( "/^https:/i", "", $image['thumbnail_src'] );
						$image['thumbnail'] = $image['thumbnail_resources'][0]['src'];
						$image['medium'] = $image['thumbnail_resources'][2]['src'];
						$image['large'] = $image['thumbnail_src'];
						if ( $image['is_video'] == true ) {
							$type = 'video';
						} else {
							$type = 'image';
						}
						$caption = esc_html__( 'Instagram Image', 'thebrilliance' );
						if ( ! empty( $image['caption'] ) ) {
							$caption = $image['caption'];
						}
						$instagram[] = array(
							'description'   => $caption,
							'link'		  	=> '//instagram.com/p/' . $image['shortcode'],
							'likes'		 	=> $image['edge_media_preview_like']['count'],
							'thumbnail'	 	=> $image['thumbnail'],
							'medium'		=> $image['medium'],
							'large'			=> $image['large'],
							'type'		  	=> $type
						);
                        }
					}
                   
				break;
			}
			// do not set an empty transient - should help catch private or empty accounts
			if ( ! empty( $instagram ) ) {
				$instagram = encode_ct( $instagram ) ;
         
				set_transient( 'instagram-media-new-'.sanitize_title_with_dashes( $username ), $instagram, apply_filters( 'null_instagram_cache_time', HOUR_IN_SECONDS*2 ) );
			}
		if ( ! empty( $instagram ) ) {
		  
			$instagram = decode_ct( $instagram );
			return array_slice( $instagram, 0, $slice );
		} else {
			return new WP_Error( 'no_images',esc_html__( 'Instagram did not return any images.', 'thebrilliance' ) );
		}
	}
}
if( !function_exists( 'jws_instagram_images_only' ) ) {
	function jws_instagram_images_only($media_item) {
		if ($media_item['type'] == 'image')
			return true;
		return false;
	}
}
